/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.data.DataException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataPortable;
import com.wm.data.IDataSharedCursor;
import com.wm.data.IDataTreeCursor;
import com.wm.data.IDataUtil;
import com.wm.util.IDataKeyEnumerator;
import com.wm.util.IDataValueEnumerator;
import com.wm.util.List;
import com.wm.util.SortedValuesEnumerator;
import com.wm.util.Table;
import com.wm.util.coder.Codable;
import com.wm.util.coder.IDataCodable;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.sort.Sortable;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Values
implements IData,
Sortable,
Codable,
Serializable {
    static final long serialVersionUID = -8399639587698064529L;
    final int version = 1;
    IData data;
    Hashtable privData;
    int nextNum = 0;
    String sortKey = "name";
    private boolean recurse_flag = false;
    static final boolean debug = false;

    private Values(IData data) {
        this.data = data;
    }

    public void setErrorMode(int m) {
    }

    public DataException getLastError() {
        return null;
    }

    public boolean isSharedData() {
        return false;
    }

    public synchronized Object get(String key) {
        IDataCursor item = this.data.getCursor();
        Object val = null;
        if (item.first(key)) {
            val = item.getValue();
        }
        item.destroy();
        val = this.wrap(val);
        return val;
    }

    private Object wrap(Object data) {
        Values[] ret = data;
        if (data instanceof Values || data instanceof Values[]) {
            ret = data;
        } else if (data instanceof IData) {
            ret = Values.use((IData)data);
        } else if (data instanceof IData[]) {
            IData[] iArray = data;
            Values[] vArray = new Values[iArray.length];
            for (int i = 0; i < iArray.length; ++i) {
                vArray[i] = Values.use(iArray[i]);
            }
            ret = vArray;
        }
        return ret;
    }

    public static Object wrapIData(Object data) {
        if (data instanceof Values || data instanceof Values[]) {
            return data;
        }
        if (data instanceof IData) {
            return Values.use((IData)data);
        }
        if (data instanceof IData[]) {
            IData[] old = (IData[])data;
            Values[] obj = new Values[old.length];
            for (int i = 0; i < old.length; ++i) {
                obj[i] = Values.use(old[i]);
            }
            return obj;
        }
        if (data instanceof Object[]) {
            Object[] old = (Object[])data;
            for (int i = 0; i < old.length; ++i) {
                old[i] = Values.wrapIData(old[i]);
            }
            return old;
        }
        if (data instanceof Vector) {
            Vector v = (Vector)data;
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                Object o2;
                Object o1 = v.elementAt(i);
                if (o1 == (o2 = Values.wrapIData(o1))) continue;
                v.setElementAt(o2, i);
            }
            return data;
        }
        return data;
    }

    public synchronized Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Data key is null");
        }
        IDataCursor item = this.data.getCursor();
        if (!item.first(key)) {
            item.last();
            item.insertAfter(key, value);
            item.destroy();
            return null;
        }
        Object res = item.getValue();
        item.setValue(value);
        item.destroy();
        return res;
    }

    public synchronized Object remove(String key) {
        IDataCursor item = this.data.getCursor();
        if (!item.first(key)) {
            item.destroy();
            return null;
        }
        Object res = item.getValue();
        item.delete();
        item.destroy();
        return res;
    }

    public synchronized void renameKey(String oldkey, String newkey) {
        IDataCursor item1 = this.data.getCursor();
        IDataCursor item2 = this.data.getCursor();
        if (item2.first(newkey)) {
            item2.delete();
        }
        if (item1.first(oldkey)) {
            item1.setKey(newkey);
        }
        item1.destroy();
        item2.destroy();
    }

    public synchronized boolean contains(Object value) {
        IDataCursor next = this.data.getCursor();
        while (next.next()) {
            Object ref = next.getValue();
            if (!(value == null || ref == null ? ref == value : value.equals(ref))) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        boolean ret = false;
        IDataCursor cursor = this.data.getCursor();
        if (cursor.first(key)) {
            ret = true;
        }
        cursor.destroy();
        return ret;
    }

    public synchronized int size() {
        IDataIndexCursor cursor = this.data.getIndexCursor();
        int ret = cursor.count();
        cursor.destroy();
        return ret;
    }

    public synchronized Enumeration keys() {
        return new IDataKeyEnumerator(this.data.getCursor());
    }

    public synchronized Enumeration elements() {
        return new IDataValueEnumerator(this.data.getCursor());
    }

    public IData getIData() {
        return this.data;
    }

    public static Values use(IData data) {
        if (data instanceof Values || data == null) {
            return (Values)data;
        }
        return new Values(data);
    }

    public Values() {
        this(-1);
    }

    public Values(Hashtable h) {
        this();
        this.copyFrom(h);
    }

    public Values(int size) {
        this.data = IDataFactory.create(size);
    }

    public Values(Object[][] values) {
        this();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].length != 2 || values[i][1] == null) continue;
            this.put((String)values[i][0], values[i][1]);
        }
    }

    public synchronized String[] getValueKeys() {
        Vector foo = new Vector(this.size());
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            foo.addElement(e.nextElement());
        }
        Object[] s = new String[foo.size()];
        foo.copyInto(s);
        return s;
    }

    public Object getValue(String vn) {
        return this.get(vn);
    }

    public void setValue(String vn, Object value) {
        this.put(vn, value);
    }

    public synchronized int compare(Sortable compareTo, boolean reverse, int column) {
        if (compareTo instanceof Values) {
            String skey = this.getSortKeyValue();
            String ctskey = ((Values)compareTo).getSortKeyValue();
            if (skey != null && ctskey != null) {
                return skey.compareTo(ctskey);
            }
        }
        return 0;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public String getSortKeyValue() {
        Object o = this.get(this.sortKey);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public void setSortKey(String key) {
        this.sortKey = key;
    }

    public Object getPrivate(String key) {
        if (this.privData == null) {
            return null;
        }
        return this.privData.get(key);
    }

    public void setPrivate(String key, Object val) {
        if (this.privData == null) {
            this.privData = new Hashtable(3);
        }
        this.privData.put(key, val);
    }

    public void removePrivate(String key) {
        if (this.privData != null) {
            this.privData.remove(key);
        }
    }

    public void copyPrivateDataFrom(Values that) {
        if (that != null && that.privData != null) {
            if (this.privData == null) {
                this.privData = new Hashtable(3);
            }
            Enumeration e = that.privData.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.privData.put(key, that.privData.get(key));
            }
        }
    }

    public Object put(Object value) {
        return this.put("__" + this.nextNum++, value);
    }

    public Object put(String key, int value) {
        return this.put(key, Integer.toString(value));
    }

    public Object put(String key, long value) {
        return this.put(key, Long.toString(value));
    }

    public Values getValues(String key) {
        Object o = this.get(key);
        if (o instanceof Values) {
            return (Values)o;
        }
        return null;
    }

    public Values[] getValuesArray(String key) {
        Object o = this.get(key);
        if (o instanceof Values[]) {
            return (Values[])o;
        }
        if (o instanceof Table) {
            return ((Table)o).getValues();
        }
        return null;
    }

    public String getString(String key) {
        Object o = this.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public String getNonEmptyString(String key) {
        String s = this.getTrimmedString(key);
        if (s != null && s.length() == 0) {
            s = null;
        }
        return s;
    }

    public String getTrimmedString(String key) {
        String s = this.getString(key);
        return s == null ? s : s.trim();
    }

    public String[] getStringArray(String key) {
        Object o = this.get(key);
        if (o instanceof String[]) {
            return (String[])o;
        }
        return null;
    }

    public String[][] getStringTable(String key) {
        Object o = this.get(key);
        if (o instanceof String[][]) {
            return (String[][])o;
        }
        return null;
    }

    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    public int getInt(String key, int def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    public long getLong(String key, long def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean getBoolean(String key) {
        Object o = this.get(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return new Boolean(o.toString());
        }
        return false;
    }

    public synchronized Object get(int index) {
        if (index >= this.size()) {
            return null;
        }
        IDataCursor item = this.data.getCursor();
        item.first();
        for (int i = 0; i < index; ++i) {
            item.next();
        }
        return item.getValue();
    }

    public Object getNode(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(name, "/");
        Values nextVal = this;
        Object next = null;
        while (st.hasMoreTokens()) {
            int index = -1;
            String t = st.nextToken();
            int iPos = t.indexOf(91);
            if (iPos > 0) {
                int iePos = t.indexOf(93, iPos);
                index = Integer.parseInt(t.substring(iPos + 1, iePos));
                t = t.substring(0, iPos);
            }
            if ((next = nextVal.get(t)) == null) {
                return null;
            }
            if (next instanceof Object[] && index >= 0) {
                next = ((Object[])next)[index];
            }
            if (!(next instanceof Values)) {
                return next;
            }
            nextVal = (Values)next;
        }
        return next;
    }

    public Object putNode(String name, Object value) {
        if (name == null || name.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(name, "/");
        Values nextVal = this;
        Object next = null;
        while (st.hasMoreTokens()) {
            int index = -1;
            boolean array = false;
            String t = st.nextToken();
            if (!st.hasMoreTokens()) {
                nextVal.put(t, value);
                break;
            }
            int iPos = t.indexOf(91);
            if (iPos > 0) {
                array = true;
                int iePos = t.indexOf(93, iPos);
                index = Integer.parseInt(t.substring(iPos + 1, iePos));
                t = t.substring(0, iPos);
            }
            if ((next = nextVal.get(t)) == null) {
                next = array ? new Values[Math.max(0, index)] : new Values();
                nextVal.put(t, next);
            }
            if (next instanceof Object[] && index >= 0) {
                next = ((Object[])next)[index];
            }
            if (!(next instanceof Values)) {
                return next;
            }
            nextVal = (Values)next;
        }
        return next;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized Enumeration sortedKeys() {
        return new SortedValuesEnumerator(this.getValueKeys());
    }

    public String getHashId() {
        return Integer.toString(this.hashCode());
    }

    public synchronized boolean equals(Object in) {
        if (in == this) {
            return true;
        }
        if (in == null || !(in instanceof Values)) {
            return false;
        }
        Values v = (Values)in;
        if (this.size() != v.size()) {
            return false;
        }
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object ov;
            String key = (String)e.nextElement();
            if (!v.containsKey(key)) {
                return false;
            }
            Object o = this.get(key);
            if (this.match(o, ov = v.get(key))) continue;
            return false;
        }
        return true;
    }

    private boolean match(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        if (o1 == o2) {
            return true;
        }
        if (!(o1 instanceof IData)) {
            if (o1 instanceof ValuesCodable) {
                o1 = ((ValuesCodable)o1).getValues();
            } else if (o1 instanceof IDataCodable) {
                o1 = ((IDataCodable)o1).getIData();
            } else if (o1 instanceof IDataPortable) {
                o1 = ((IDataPortable)o1).getAsData();
            }
        }
        if (!(o2 instanceof IData)) {
            if (o2 instanceof ValuesCodable) {
                o2 = ((ValuesCodable)o2).getValues();
            } else if (o2 instanceof IDataCodable) {
                o2 = ((IDataCodable)o2).getIData();
            } else if (o2 instanceof IDataPortable) {
                o2 = ((IDataPortable)o2).getAsData();
            }
        }
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        if (o1 instanceof Object[]) {
            if (!(o2 instanceof Object[])) {
                return false;
            }
            return this.match((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof Vector) {
            if (!(o2 instanceof Vector)) {
                return false;
            }
            Vector v1 = (Vector)o1;
            Vector v2 = (Vector)o2;
            if (v1.size() != v2.size()) {
                return false;
            }
            Enumeration e1 = v1.elements();
            Enumeration e2 = v2.elements();
            int ctr = 0;
            while (e1.hasMoreElements()) {
                if (!this.match(e1.nextElement(), e2.nextElement())) {
                    return false;
                }
                ++ctr;
            }
            return true;
        }
        if (o1 instanceof List) {
            if (!(o2 instanceof List)) {
                return false;
            }
            List v1 = (List)o1;
            List v2 = (List)o2;
            if (v1.size() != v2.size()) {
                return false;
            }
            Enumeration e1 = v1.elements();
            Enumeration e2 = v2.elements();
            int ctr = 0;
            while (e1.hasMoreElements()) {
                if (!this.match(e1.nextElement(), e2.nextElement())) {
                    return false;
                }
                ++ctr;
            }
            return true;
        }
        boolean b = o1.equals(o2);
        return b;
    }

    private boolean match(Object[] a1, Object[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (this.match(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public synchronized Object clone() {
        Values copy = new Values();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            Object o = this.get(k);
            copy.put(k, o);
        }
        copy.privData = this.privData;
        return copy;
    }

    public Values copyFrom(Values v) {
        if (v == null) {
            return null;
        }
        Enumeration e = v.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            this.put(k, v.get(k));
        }
        this.privData = v.privData;
        return this;
    }

    public Values copyFrom(Hashtable v) {
        if (v == null) {
            return null;
        }
        Enumeration e = v.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            this.put(k, v.get(k));
        }
        return this;
    }

    public synchronized String toString() {
        if (this.recurse_flag) {
            return " >>> Values object recursed <<< ";
        }
        this.recurse_flag = true;
        StringBuffer sb = new StringBuffer(" >>>");
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object val = this.get(key);
            if (val instanceof Object[]) {
                Object[] v = (Object[])val;
                StringBuffer ab = new StringBuffer();
                for (int j = 0; j < v.length; ++j) {
                    ab.append("[" + j + "]" + this.valuesString(v[j]) + (j < v.length - 1 ? "," : ""));
                }
                val = ab.toString();
            }
            sb.append(key + "=" + this.valuesString(val) + (e.hasMoreElements() ? ", " : ""));
        }
        sb.append("<<< ");
        this.recurse_flag = false;
        return sb.toString();
    }

    private Object valuesString(Object o) {
        if (!(o instanceof IData)) {
            if (o instanceof IDataCodable) {
                o = ((IDataCodable)o).getIData();
            } else if (o instanceof IDataPortable) {
                o = ((IDataPortable)o).getAsData();
            }
        }
        return o;
    }

    public static IData create() {
        return new Values();
    }

    public IDataCursor getCursor() {
        return this.data.getCursor();
    }

    public IDataIndexCursor getIndexCursor() {
        return this.data.getIndexCursor();
    }

    public IDataTreeCursor getTreeCursor() {
        return this.data.getTreeCursor();
    }

    public IDataHashCursor getHashCursor() {
        return this.data.getHashCursor();
    }

    public IDataSharedCursor getSharedCursor() {
        return this.data.getSharedCursor();
    }

    public IData copy() {
        IData copy = IDataFactory.create(this.size());
        IDataUtil.copy(this.data, copy);
        return copy;
    }
}

