/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.AppRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class UniqueApp {
    public static final String OK = "OK";
    public static final String DENIED = "DENIED";
    public static final String INIT = "init";
    public static final String UPDATE = "update";
    public static final String QUIT = "quit";
    public static final int PORT = 4321;
    public static final int MAX_PORTS = 100;
    public static final int UPDATE_INTERVAL = 1000;
    public static boolean DEBUG = false;
    private AppHeartbeat heartbeat_ = null;
    AppRegistry registry_ = null;
    private String iden_;
    private int port_ = 4321;
    private int lastPort_ = 4321;

    public UniqueApp(String iden) {
        this(iden, 4321, 4421);
    }

    public UniqueApp(String iden, int port) {
        this(iden, port, port);
    }

    public UniqueApp(int port) {
        this(null, port, port);
    }

    public UniqueApp(String iden, int port, int lastPort) {
        this.iden_ = iden == null ? System.getProperty("user.dir") : iden;
        this.port_ = port;
        this.lastPort_ = lastPort;
    }

    public void start() throws DeniedException {
        if (this.port_ > this.lastPort_) {
            UniqueApp.debugPrint("UNQ  ERROR: port_ (" + this.port_ + ") > lastPort_ (" + this.lastPort_ + ")");
        }
        while (this.port_ <= this.lastPort_) {
            UniqueApp.debugPrint("UNQ  attempting connection on port " + this.port_);
            try {
                UniqueApp.debugPrint("UNQ  " + this.iden_ + " sending initial message");
                String response = this.send(INIT);
                UniqueApp.debugPrint("UNQ  " + this.iden_ + " got response " + response);
                if (response == null) {
                    UniqueApp.debugPrint("UNQ  connected on port " + this.port_ + ", but no response");
                } else {
                    if (response.equals(DENIED)) {
                        throw new DeniedException();
                    }
                    if (response.equals(OK)) {
                        this.runHeartbeat();
                        break;
                    }
                    UniqueApp.debugPrint("UNQ  connected on port " + this.port_ + ", but incomprehensible response");
                }
            }
            catch (IOException ioe) {
                if (DEBUG) {
                    ioe.printStackTrace(System.out);
                }
                this.runRegistry();
                break;
            }
            ++this.port_;
        }
    }

    public UniqueApp() {
        this(null);
    }

    public String send(String type) throws IOException {
        int timeout = 3000;
        Socket socket = new Socket("localhost", this.port_);
        socket.setSoTimeout(timeout);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        String msg = type + ": " + this.iden_;
        out.println(msg);
        out.flush();
        return in.readLine();
    }

    public void runHeartbeat() {
        UniqueApp.debugPrint("UNQ  " + this.iden_ + " running heartbeat");
        this.heartbeat_ = new AppHeartbeat();
    }

    public void runRegistry() {
        UniqueApp.debugPrint("UNQ  " + this.iden_ + " starting registry on port " + this.port_);
        this.registry_ = new AppRegistry(this.iden_, this.port_);
    }

    public int port() {
        return this.port_;
    }

    public void quit() {
        UniqueApp.debugPrint("UNQ  " + this.iden_ + " quitting");
        if (this.registry_ == null) {
            UniqueApp.debugPrint("UNQ  " + this.iden_ + " sending quit message");
            try {
                this.send(QUIT);
            }
            catch (IOException se) {
                UniqueApp.debugPrint("UNQ  I/O exception");
                if (DEBUG) {
                    se.printStackTrace(System.out);
                }
            }
        } else {
            UniqueApp.debugPrint("UNQ  " + this.iden_ + " stopping registry");
            this.registry_.stop();
        }
    }

    protected static void debugPrint(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    public static void main(String[] args) {
        new UniqueApp(3333);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }

    class AppHeartbeat
    implements Runnable {
        private volatile Thread thread_ = new Thread((Runnable)this, "webM AppHeartbeat");

        public AppHeartbeat() {
            this.thread_.start();
        }

        public void run() {
            while (this.thread_ != null) {
                try {
                    UniqueApp.debugPrint("HBT  " + UniqueApp.this.iden_ + " running");
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    UniqueApp.this.send(UniqueApp.UPDATE);
                    UniqueApp.debugPrint("HBT  sent update");
                }
                catch (IOException se) {
                    UniqueApp.debugPrint("HBT  I/O exception");
                    if (DEBUG) {
                        se.printStackTrace(System.out);
                    }
                    UniqueApp.this.runRegistry();
                    break;
                }
                catch (InterruptedException ie) {
                    UniqueApp.debugPrint("HBT  thread interrupted");
                    break;
                }
            }
        }

        public void stop() {
            this.thread_ = null;
        }
    }

    public class DeniedException
    extends Exception {
    }
}

