/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class URIParser {
    private static final String PARENT_AXIS = "..";
    private static final int NET_PARENT_AXIS_LEXICAL_REP_LENGTH = 3;
    private static final int LOCAL_PARENT_AXIS_LEXICAL_REP_LENGTH = 2 + File.separator.length();
    private static final String CURRENT_LEVEL = ".";

    public static final String abs(String baseURI, String relativeURI) {
        String qualFile;
        String baseFile;
        String baseProtocol;
        String basePort;
        String baseHost;
        if (baseURI == null || relativeURI == null || relativeURI.length() == 0) {
            return relativeURI;
        }
        String tmp = (relativeURI = relativeURI.trim()).toLowerCase();
        if (tmp.startsWith("#") || tmp.startsWith("http://") || tmp.startsWith("https://") || tmp.startsWith("mailto:") || tmp.startsWith("javascript:") || tmp.startsWith("telnet:") || tmp.startsWith("nntp:") || tmp.startsWith("news:") || tmp.startsWith("file:") || tmp.startsWith("gopher:") || tmp.startsWith("ftp:")) {
            return relativeURI;
        }
        try {
            URL baseUrl = new URL(baseURI);
            baseHost = baseUrl.getHost();
            int p = baseUrl.getPort();
            basePort = p >= 0 ? ":" + p : "";
            baseProtocol = baseUrl.getProtocol();
            baseFile = baseUrl.getFile();
            int pos = baseFile.lastIndexOf("/");
            baseFile = pos > 0 ? baseFile.substring(0, pos) : "";
        }
        catch (Exception e) {
            return relativeURI;
        }
        try {
            URL qaulUrl = new URL(relativeURI);
            baseProtocol = qaulUrl.getProtocol();
            int colonPos = relativeURI.indexOf(":");
            qualFile = relativeURI.length() > colonPos && relativeURI.substring(0, colonPos).equals(baseProtocol) && relativeURI.charAt(colonPos + 1) != '/' ? relativeURI.substring(colonPos + 1) : qaulUrl.getFile();
        }
        catch (Exception e) {
            qualFile = relativeURI;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(baseProtocol);
        sb.append("://");
        sb.append(baseHost);
        sb.append(basePort);
        if (qualFile.length() != 0 && qualFile.charAt(0) != '/') {
            qualFile = URIParser.removeCurrentLevels(qualFile, "/");
            int steps = URIParser.computeSteps(qualFile = URIParser.removeCurrentLevels(qualFile, File.separator), 3);
            if (steps > 0) {
                qualFile = URIParser.removeParentAxes(qualFile, steps, 3);
                baseFile = URIParser.removeSegments(baseFile, steps, 1);
            }
            sb.append(baseFile);
            sb.append('/');
        }
        sb.append(qualFile);
        return sb.toString();
    }

    public static final String abs2(String baseURI, String relativeURI) {
        block7: {
            if (baseURI == null || relativeURI == null) {
                return relativeURI;
            }
            if (baseURI != null && baseURI.length() > 0) {
                try {
                    new URL(baseURI);
                    return URIParser.abs(baseURI, relativeURI);
                }
                catch (MalformedURLException x) {
                    int lastSeparator;
                    if (relativeURI.indexOf(58) >= 0) break block7;
                    String rURI = URIParser.normalize(relativeURI);
                    int steps = URIParser.computeSteps(rURI = URIParser.removeCurrentLevels(rURI, File.separator), LOCAL_PARENT_AXIS_LEXICAL_REP_LENGTH);
                    if (steps > 0) {
                        rURI = URIParser.removeParentAxes(rURI, steps, LOCAL_PARENT_AXIS_LEXICAL_REP_LENGTH);
                    }
                    if ((lastSeparator = URIParser.locate(baseURI, steps, File.separator)) != -1) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(baseURI.substring(0, lastSeparator + File.separator.length()));
                        if (rURI != null) {
                            sb.append(rURI);
                        }
                        return sb.toString();
                    }
                    return rURI;
                }
            }
        }
        return relativeURI;
    }

    private static final int computeSteps(String relativeURI, int parentAxisLexicalRepLength) {
        String rURI = relativeURI;
        int steps = 0;
        while (rURI.startsWith(PARENT_AXIS)) {
            rURI = rURI.substring(parentAxisLexicalRepLength);
            ++steps;
        }
        return steps;
    }

    private static final int locate(String base, int steps, String separator) {
        String baseURI = URIParser.normalize(base);
        int index = baseURI.lastIndexOf(separator);
        while (index > -1 && steps > 0) {
            index = baseURI.lastIndexOf(separator, index - separator.length());
            --steps;
        }
        return index;
    }

    private static final String removeSegments(String path, int steps, int separatorLength) {
        int index = path.length() - 1;
        while (index > -1 && steps > 0) {
            index = path.lastIndexOf(47, index - separatorLength);
            --steps;
        }
        return path.substring(0, index);
    }

    private static final String removeParentAxes(String path, int steps, int parentAxisLexicalRepLength) {
        return path.substring(steps * parentAxisLexicalRepLength);
    }

    private static final String removeCurrentLevels(String path, String separator) {
        StringTokenizer tokenizer = new StringTokenizer(path, separator);
        StringBuffer buffer = new StringBuffer();
        String segment = null;
        while (tokenizer.hasMoreTokens()) {
            segment = tokenizer.nextToken();
            if (segment.equals(CURRENT_LEVEL)) continue;
            if (buffer.length() != 0) {
                buffer.append(separator);
            }
            buffer.append(segment);
        }
        return buffer.toString();
    }

    public static final String normalize(String path) {
        String aPath = path;
        if (aPath.indexOf(47) != -1 && File.separator.equals("\\")) {
            aPath = aPath.replace('/', '\\');
        }
        if (aPath.indexOf(92) != -1 && File.separator.equals("/")) {
            aPath = aPath.replace('\\', '/');
        }
        return aPath;
    }

    public static final String normalizeFileURL(String path) {
        try {
            URL url = new URL(path);
            if (!url.getProtocol().equals("file")) {
                return path;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(url.getProtocol());
            sb.append("://");
            sb.append(url.getHost());
            String port = url.getPort() >= 0 ? ":" + url.getPort() : "";
            sb.append(port);
            sb.append(url.getFile());
            return sb.toString();
        }
        catch (Exception e) {
            return path;
        }
    }

    public static void main(String[] args) {
    }
}

