/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.QName;
import com.wm.util.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeName {
    private static final String SCHEME = "http://";
    private static final String AUTHORITY_DEFAULT = "localhost";
    private static final String LOCALNAME_PREFIX_DEFAULT = "__";
    private static final String SEPARATOR = "/";
    private static String _authority;
    private static String _localNamePrefix;
    private static final String CONFIG_AUTHORITY_FOR_NAMESPACE_NAME = "watt.core.generatedTypeName.namespaceName.authority";
    private static final String CONFIG_LOCAL_NAME_PREFIX = "watt.core.generatedTypeName.localName.prefix";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createURI(String path, String node) {
        StringBuffer buf;
        StringBuffer stringBuffer = buf = new StringBuffer();
        synchronized (stringBuffer) {
            buf.append(SCHEME);
            buf.append(TypeName.authority());
            TypeName.appendPath(buf, path);
            buf.append(SEPARATOR);
            buf.append(node);
        }
        return buf.toString();
    }

    public static QName create(String path, String node, String name, HashSet typeNames) {
        String namespaceName = TypeName.createURI(path, node);
        return TypeName.create(namespaceName, name, typeNames);
    }

    public static QName create(String namespaceName, String name, HashSet typeNames) {
        return TypeName.create(namespaceName, name, typeNames, null);
    }

    public static QName create(String namespaceName, String name, HashSet typeNames, boolean is46SOAP) {
        return TypeName.create(namespaceName, name, typeNames, null, is46SOAP);
    }

    public static QName create2(String namespaceName, String name, HashSet typeNames) {
        return TypeName.create2(namespaceName, name, typeNames, null);
    }

    public static QName create(String namespaceName, String name, HashSet typeNames, HashMap<QName, QName> duplicatesResolved) {
        return TypeName.create(namespaceName, name, typeNames, duplicatesResolved, false);
    }

    public static QName create(String namespaceName, String name, HashSet typeNames, HashMap<QName, QName> duplicatesResolved, Map typeNamesMap) {
        return TypeName.create(namespaceName, name, typeNames, duplicatesResolved, false, typeNamesMap);
    }

    public static QName create(String namespaceName, String name, HashSet typeNames, HashMap<QName, QName> duplicatesResolved, boolean is46SOAP) {
        return TypeName.create(namespaceName, name, typeNames, duplicatesResolved, is46SOAP, null);
    }

    public static QName create(String namespaceName, String name, HashSet typeNames, HashMap<QName, QName> duplicatesResolved, boolean is46SOAP, Map typeNamesMap) {
        String localName = null;
        localName = is46SOAP ? Strings.cat(name, "ArrayItem") : Strings.cat(TypeName.localNamePrefix(), name);
        QName typeName = QName.create(namespaceName, localName);
        QName originalTypeName = QName.create(namespaceName, name);
        boolean isReplaced = false;
        if (typeNamesMap != null) {
            int i = 1;
            Object o = typeNamesMap.get(typeName);
            if (o != null) {
                i = Integer.parseInt((String)o);
                typeName = QName.create(namespaceName, Strings.cat(localName, Integer.toString(++i)));
                isReplaced = true;
            }
            typeNamesMap.put(typeName, Integer.toString(i));
            if (isReplaced && duplicatesResolved != null) {
                String typeNCName = typeName.getNCName();
                typeNCName = typeNCName.replaceAll(TypeName.localNamePrefix(), "");
                duplicatesResolved.put(QName.create(namespaceName, typeNCName), originalTypeName);
            }
        } else if (typeNames != null) {
            int i = 1;
            while (typeNames.contains(typeName)) {
                typeName = QName.create(namespaceName, Strings.cat(localName, Integer.toString(++i)));
                isReplaced = true;
            }
            typeNames.add(typeName);
            if (isReplaced && duplicatesResolved != null) {
                String typeNCName = typeName.getNCName();
                typeNCName = typeNCName.replaceAll(TypeName.localNamePrefix(), "");
                duplicatesResolved.put(QName.create(namespaceName, typeNCName), originalTypeName);
            }
        }
        return typeName;
    }

    public static QName create2(String namespaceName, String name, HashSet typeNames, HashMap<QName, QName> duplicatesResolved) {
        QName typeName;
        QName originalTypeName = typeName = QName.create(namespaceName, name);
        boolean isReplaced = false;
        if (typeNames != null) {
            int i = 1;
            while (typeNames.contains(typeName)) {
                typeName = QName.create(namespaceName, Strings.cat(name, Integer.toString(++i)));
                isReplaced = true;
            }
            typeNames.add(typeName);
            if (isReplaced && duplicatesResolved != null) {
                duplicatesResolved.put(typeName, originalTypeName);
            }
        }
        return typeName;
    }

    public static String typeNameCheck(String tag) {
        String localName = Strings.cat(TypeName.localNamePrefix(), tag);
        return localName;
    }

    public static void main(String[] args) {
        String namespaceName = TypeName.createURI("pub.string", "concat");
        System.out.println(namespaceName);
        HashSet typeNames = new HashSet();
        QName typeName = TypeName.create(namespaceName, "inString", typeNames);
        System.out.println(typeName.getNamespace() + "#" + typeName.getNCName());
        QName typeName2 = TypeName.create(namespaceName, "inString", typeNames);
        System.out.println(typeName2.getNamespace() + "#" + typeName2.getNCName());
    }

    private static void appendPath(StringBuffer buf, String folder) {
        StringTokenizer tokenizer = new StringTokenizer(folder, ".");
        while (tokenizer.hasMoreTokens()) {
            buf.append(SEPARATOR);
            buf.append(tokenizer.nextToken());
        }
    }

    private static String authority() {
        if (_authority == null && (_authority = System.getProperty(CONFIG_AUTHORITY_FOR_NAMESPACE_NAME)) == null) {
            _authority = AUTHORITY_DEFAULT;
        }
        return _authority;
    }

    private static String localNamePrefix() {
        if (_localNamePrefix == null && (_localNamePrefix = System.getProperty(CONFIG_LOCAL_NAME_PREFIX)) == null) {
            _localNamePrefix = LOCALNAME_PREFIX_DEFAULT;
        }
        return _localNamePrefix;
    }
}

