/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.ArchiveJob;
import com.wm.util.B2BListResourceBundle;
import com.wm.util.Config;
import com.wm.util.Cron;
import com.wm.util.CronJob;
import com.wm.util.Debug2;
import com.wm.util.EncUtil;
import com.wm.util.FacilityInfo;
import com.wm.util.List;
import com.wm.util.LogStringInfo;
import com.wm.util.MsgResources;
import com.wm.util.Values;
import com.wm.util.sort.QuickSort;
import com.wm.util.sort.Sortable;
import com.wm.util.xform.DateTimeDT;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Trace {
    public static final int VERBOSE6 = 10;
    public static final int VERBOSE5 = 9;
    public static final int VERBOSE4 = 8;
    public static final int VERBOSE3 = 7;
    public static final int VERBOSE2 = 6;
    public static final int VERBOSE = 5;
    public static final int DEBUG = 4;
    public static final int WARNING = 3;
    public static final int ERROR = 2;
    public static final int CRITICAL = 1;
    public static final int OFF = 0;
    public static final int ALL = 1;
    public static final int LOG_ENABLED = 0;
    public static final int LOG_DISABLED_FAC = 1;
    public static final int LOG_DISABLED_LEV = 2;
    static final int numWidth = 5;
    static final int padWidth = 22;
    static final String zeros = "000000";
    static final String space = "                       ";
    static final String dash = "------";
    static final int facLength = 4;
    static String sep = System.getProperty("line.separator");
    public static String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss z";
    public static String DEFAULT_LOG_FORMAT = "{4}  [{6}{7}.{1}.{0,number,0000}] {3}";
    public static final int LOG_MSG = 9999;
    public static final int LOG_EXCEPTION = 9998;
    public static final int DEBUG_MSG = 9999;
    public static final int EXCEPTION_MSG = 9998;
    public static final int CLEAR_ALL_FACILITIES = 1000;
    public static final int SET_ALL_FACILITIES = 999;
    public static final int FAC_ENABLED = 998;
    protected static final String DEFAULT_GROUP = "B2B";
    protected static final String DEFAULT_COMPONENT = "UNKW";
    protected static final int SECTION_FACILITY_STR = 1;
    protected static final int SECTION_OUTPUT_FORMAT_STR = 2;
    protected static final int SECTION_LOG_STR = 3;
    protected static final int SECTION_IGNORE = 4;
    protected static String LOG_FORMAT = "watt.server.serverLogFmt";
    protected static String LOG_FORMAT_DEPR = "watt.server.logFormat";
    protected static final String[] SEVERITY_STRING = new String[]{"OFF ", "CRIT", "ERR ", "WARN", "DEBG", "VERB"};
    protected MessageFormat gMsgFmt;
    protected MessageFormat gDefMsgFmt;
    protected MessageFormat gArgMsgFmt;
    private static Hashtable gOpenedFiles = new Hashtable();
    protected MsgResources gMsgRes;
    protected String gResPath = null;
    protected ResourceBundle gFacBundle = ResourceBundle.getBundle("com.wm.util.resources.FacilitiesBundle");
    protected Hashtable gLogStringMap;
    protected Hashtable gFacilityMap;
    protected BitSet gLogFacility;
    protected String gLogOutputFormat;
    protected String gCommentLine;
    protected String gDateFormat;
    protected String gOutputLine;
    protected String gFormatLine;
    protected long gMaxLogSize;
    protected int gCheckFullRate;
    protected boolean gWriteMsgOnly;
    protected String gLogStringFileName;
    protected boolean gEnabled;
    protected boolean gOutFileCreated;
    protected boolean gLogToConsole = false;
    protected int gCurrentFac = 0;
    public int level;
    protected String logFile;
    protected OutputStream log;
    protected int msgnum;
    protected Cron gArchiveScheduler;
    protected boolean gI18NLogging = true;
    protected boolean logToFile = false;
    protected String gProdGroup = null;
    protected String gProdComponent = null;

    public Trace(String resPath) {
        this.gResPath = resPath;
        try {
            this.gEnabled = false;
            this.initMembers();
            this.Init();
        }
        catch (NegativeArraySizeException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Trace() {
        try {
            this.gEnabled = false;
            this.initMembers();
            this.Init();
        }
        catch (NegativeArraySizeException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Trace(String dictionaryFile, String outputFile, Properties props) {
        try {
            this.gEnabled = false;
            this.initMembers();
            this.Init(dictionaryFile, outputFile, props);
        }
        catch (NegativeArraySizeException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public Trace(String dictionaryFile, String outputFile) {
        this(dictionaryFile, outputFile, null);
    }

    private void initMembers() throws NegativeArraySizeException, IllegalArgumentException {
        String str = Config.getProperty("true", "watt.server.I18NLogging");
        if (Config.getProperty("true", "watt.server.I18NLogging").equalsIgnoreCase("false")) {
            this.gI18NLogging = false;
        }
        this.gArchiveScheduler = null;
        this.level = 2;
        this.logFile = null;
        this.log = System.out;
        this.msgnum = 0;
        this.gMsgRes = new MsgResources();
        this.gLogFacility = new BitSet(128);
        this.gLogStringMap = new Hashtable(3, 0.8f);
        this.gFacilityMap = new Hashtable(3, 0.8f);
        this.gLogOutputFormat = Config.getProperty(LOG_FORMAT) != null ? Config.getProperty(LOG_FORMAT) : (Config.getProperty(LOG_FORMAT_DEPR) != null ? Config.getProperty(LOG_FORMAT_DEPR) : (this.gI18NLogging ? DEFAULT_LOG_FORMAT : " {4}  {1}{0,number,0000}{2}  {3}"));
        this.gWriteMsgOnly = false;
        this.gOutFileCreated = false;
        this.gMsgFmt = new MessageFormat(this.gLogOutputFormat);
        this.gArgMsgFmt = new MessageFormat("%0");
        this.gDefMsgFmt = new MessageFormat("%0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate(Object dest) {
        try {
            Hashtable hashtable = gOpenedFiles;
            synchronized (hashtable) {
                Enumeration enumFiles = gOpenedFiles.elements();
                while (enumFiles.hasMoreElements()) {
                    Trace tr;
                    Trace trace = tr = (Trace)enumFiles.nextElement();
                    synchronized (trace) {
                        StringTokenizer st;
                        String fileName = null;
                        if (tr.getLogStream() == System.out || tr.getLogStream() == System.err) {
                            continue;
                        }
                        tr.getLogStream().close();
                        File current = new File(tr.getLogFile());
                        fileName = current.getName();
                        if (fileName.indexOf("/") > -1) {
                            st = new StringTokenizer(current.getName(), "/");
                            while (st.hasMoreElements()) {
                                fileName = st.nextToken();
                            }
                        }
                        if (fileName.indexOf("\\") > -1) {
                            st = new StringTokenizer(current.getName(), "\\");
                            while (st.hasMoreElements()) {
                                fileName = st.nextToken();
                            }
                        }
                        if (fileName != null) {
                            if (dest instanceof File) {
                                current.renameTo(new File((File)dest, fileName));
                            } else {
                                String cpath = current.getCanonicalPath();
                                int inx = cpath.lastIndexOf(File.separator);
                                String ppath = cpath.substring(0, inx);
                                inx = fileName.lastIndexOf(".");
                                if (inx > 0) {
                                    String nam = fileName.substring(0, inx);
                                    String ext = fileName.substring(inx + 1);
                                    current.renameTo(new File(new File(ppath), nam + "." + dest + "." + ext));
                                } else {
                                    current.renameTo(new File(new File(ppath), fileName + "." + dest));
                                }
                            }
                        }
                        this.msgnum = 0;
                        tr.setLogFile(tr.getLogFile());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean getOutFileCreated() {
        return this.gOutFileCreated;
    }

    protected void setOutFileCreated(boolean val) {
        this.gOutFileCreated = val;
    }

    public boolean getWriteMsgOnly() {
        return this.gWriteMsgOnly;
    }

    public void setWriteMsgOnly(boolean val) {
        this.gWriteMsgOnly = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogOutputFormat(String outputFormat) {
        try {
            String string = this.gLogOutputFormat;
            synchronized (string) {
                if (outputFormat != null) {
                    this.gLogOutputFormat = outputFormat;
                    MessageFormat messageFormat = this.gMsgFmt;
                    synchronized (messageFormat) {
                        this.gMsgFmt.applyPattern(this.gLogOutputFormat);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogOutputFormat() {
        String string = this.gLogOutputFormat;
        synchronized (string) {
            return this.gLogOutputFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Values[] getFacility() {
        try {
            Hashtable hashtable = this.gFacilityMap;
            synchronized (hashtable) {
                BitSet bitSet = this.gLogFacility;
                synchronized (bitSet) {
                    List facs = new List();
                    for (int i = 0; i < this.gLogFacility.size(); ++i) {
                        FacilityInfo facinfo = (FacilityInfo)this.gFacilityMap.get(new Integer(i));
                        if (facinfo == null) continue;
                        String facilityMsg = facinfo.facilityStr;
                        String facilityDesc = facinfo.facilityDesc;
                        if (facilityMsg == null) continue;
                        Values v = new Values();
                        v.put("Fac", facilityMsg);
                        if (facilityDesc == null || facilityDesc.length() == 0) {
                            String value;
                            try {
                                value = this.gFacBundle.getString(String.valueOf(i));
                            }
                            catch (MissingResourceException mre) {
                                value = "";
                            }
                            v.put("FacDesc", value);
                        } else {
                            v.put("FacDesc", facilityDesc);
                        }
                        v.put("Value", new Integer(i));
                        if (this.isFacilitySet(i)) {
                            v.put("Selected", new Integer(1));
                        }
                        v.setSortKey("Fac");
                        facs.addElement(v);
                    }
                    Object[] f = new Values[facs.size()];
                    facs.copyInto(f);
                    QuickSort.sort((Sortable[])f);
                    return f;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setFacility(String facs) {
        try {
            StringTokenizer st = new StringTokenizer(facs, ", ");
            while (st.hasMoreElements()) {
                String tok = (String)st.nextElement();
                this.setFacility(Integer.parseInt(tok));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacility(int iFacility) {
        try {
            BitSet bitSet = this.gLogFacility;
            synchronized (bitSet) {
                BitSet tempBS = (BitSet)this.gLogFacility.clone();
                switch (iFacility) {
                    case 1000: {
                        this.gLogFacility.xor(tempBS);
                        break;
                    }
                    case 999: {
                        for (int i = 0; i < this.gLogFacility.size(); ++i) {
                            this.gLogFacility.set(i);
                        }
                        break;
                    }
                    default: {
                        this.gLogFacility.set(iFacility);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean isFacilitySet(int iFacility) {
        try {
            if (iFacility == 998) {
                return true;
            }
            return this.gLogFacility.get(iFacility);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public void setProductGroup(String pgroup) {
        this.gProdGroup = pgroup;
    }

    public void setProductComponent(String pcomp) {
        this.gProdComponent = pcomp;
    }

    public void registerBundle(B2BListResourceBundle rb) {
        this.gMsgRes.registerBundle(rb);
    }

    public void setFacBundle(String baseName) {
        this.gFacBundle = ResourceBundle.getBundle(baseName);
    }

    public int isLogEnabledForCode(int code, int fac) {
        LogStringInfo LogInfo = null;
        try {
            if (!this.isFacilitySet(fac)) {
                return 1;
            }
            Hashtable map = (Hashtable)this.gLogStringMap.get(new Integer(fac));
            if (map != null) {
                LogInfo = (LogStringInfo)map.get(new Integer(code));
            }
        }
        catch (Exception e) {
            LogInfo = null;
        }
        if (LogInfo == null) {
            return 2;
        }
        if (LogInfo.gSeverity <= this.getLevel()) {
            return 0;
        }
        return 2;
    }

    protected void ReadLogStringMap(String LogStringFileName) throws FileNotFoundException, IOException {
        this.gLogStringMap.clear();
        this.gFacilityMap.clear();
        boolean status = false;
        if (LogStringFileName == null) {
            throw new FileNotFoundException();
        }
        try {
            String str;
            int section = 4;
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(LogStringFileName), EncUtil.getFileEncoding());
            BufferedReader in = new BufferedReader(isr);
            block12: while ((str = in.readLine()) != null) {
                String strTok;
                StringTokenizer stok = new StringTokenizer(str);
                try {
                    strTok = stok.nextToken();
                }
                catch (NoSuchElementException e) {
                    continue;
                }
                if (strTok.compareTo(this.gCommentLine) == 0 || strTok.startsWith(this.gCommentLine)) continue;
                if (strTok.compareTo(this.gOutputLine) == 0 || strTok.startsWith(this.gOutputLine)) {
                    section = 2;
                }
                if (strTok.compareTo(this.gFormatLine) == 0 || strTok.startsWith(this.gFormatLine)) {
                    section = 1;
                }
                switch (section) {
                    case 1: {
                        section = this.ProcessFacilityLine(stok);
                        continue block12;
                    }
                    case 3: {
                        this.ProcessLogStringLine(stok, strTok);
                        continue block12;
                    }
                    case 2: {
                        this.gLogOutputFormat = stok.nextToken("\n\r");
                        this.gLogOutputFormat = this.gLogOutputFormat.trim();
                        continue block12;
                    }
                }
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    protected void ProcessLogStringLine(StringTokenizer stok, String strTok) {
        Integer severity;
        Integer code;
        try {
            code = new Integer(strTok);
        }
        catch (NumberFormatException e) {
            return;
        }
        strTok = stok.nextToken();
        try {
            severity = new Integer(strTok);
        }
        catch (NumberFormatException e) {
            return;
        }
        LogStringInfo LogInfo = new LogStringInfo();
        LogInfo.gSeverity = severity;
        LogInfo.gLogString = stok.nextToken("\n\r");
        LogInfo.gLogString = LogInfo.gLogString.trim();
        try {
            Integer i = new Integer(this.gCurrentFac);
            Hashtable map = (Hashtable)this.gLogStringMap.get(i);
            if (map != null) {
                map.put(code, LogInfo);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected int ProcessFacilityLine(StringTokenizer stok) {
        Integer code;
        String strTok;
        try {
            strTok = stok.nextToken();
        }
        catch (NoSuchElementException e) {
            this.gCurrentFac = 0;
            return 4;
        }
        try {
            code = new Integer(strTok);
        }
        catch (NumberFormatException e) {
            this.gCurrentFac = 0;
            return 4;
        }
        String facilityStr = null;
        if (stok.hasMoreTokens()) {
            facilityStr = stok.nextToken();
            facilityStr.trim();
        }
        String facilityDesc = null;
        if (stok.hasMoreTokens()) {
            facilityDesc = stok.nextToken("\n\r");
            facilityDesc.trim();
        }
        FacilityInfo facinfo = new FacilityInfo(facilityStr, facilityDesc);
        this.gFacilityMap.put(code, facinfo);
        if (this.gLogStringMap.get(code) == null) {
            try {
                Hashtable map = new Hashtable(10);
                this.gLogStringMap.put(code, map);
            }
            catch (Exception e) {
                return 4;
            }
        }
        this.gCurrentFac = code;
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WriteDefaultLog(int code, int facility, int severity, Object[] args) {
        String errorMsg = "Error Code: " + code + ". Facility: " + facility + ". Severity: " + severity;
        this.WriteLog(code, severity == 0 ? 7 : severity, facility, dash, errorMsg);
        if (args != null && args.length > 0) {
            try {
                StringBuffer msg = new StringBuffer();
                for (int i = 0; i < args.length; ++i) {
                    String s = " Arg " + i + ": {" + i + "} ";
                    msg.append(s);
                }
                String errMsg = null;
                MessageFormat messageFormat = this.gDefMsgFmt;
                synchronized (messageFormat) {
                    this.gDefMsgFmt.applyPattern(msg.toString());
                    errMsg = this.gDefMsgFmt.format(args).trim();
                }
                this.WriteLog(code, severity == 0 ? 4 : severity, facility, dash, errMsg);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void WriteLog(int code, int severity, int facility, String facilityMsg, String msg) {
        this.WriteLog(code, severity, facility, facilityMsg, msg, DEFAULT_GROUP, DEFAULT_COMPONENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void WriteLog(int code, int severity, int facility, String facilityMsg, String msg, String group, String component) {
        if (severity <= this.getLevel()) {
            String errMsg = null;
            Integer IntCode = null;
            Integer IntSev = null;
            Long LongMsgNum = null;
            String dateStamp = null;
            try {
                IntCode = new Integer(code);
                IntSev = new Integer(severity);
                LongMsgNum = new Long(this.msgnum);
                dateStamp = this.getDateStamp();
                String facMsg = facilityMsg;
                if (facilityMsg == null) {
                    facMsg = dash;
                }
                if (group == null) {
                    group = DEFAULT_GROUP;
                }
                if (component == null) {
                    component = DEFAULT_COMPONENT;
                }
                if (Debug2.isEnabled() && this.isLogToServerStream() && facilityMsg.length() < 4) {
                    facMsg = dash.substring(0, 4 - facilityMsg.length()) + facilityMsg;
                }
                Object[] Args = new Object[]{IntCode, facMsg, this.getSeverityAsStr(severity).substring(0, 1), msg == null ? " " : msg, this.hexNum(), dateStamp, group, component};
                MessageFormat messageFormat = this.gMsgFmt;
                synchronized (messageFormat) {
                    errMsg = this.gMsgFmt.format(Args).trim();
                }
            }
            catch (IllegalArgumentException e) {
                errMsg = "Code: " + IntCode.toString() + " Facility: " + facilityMsg + " Severity: " + IntSev.toString() + " " + msg;
            }
            catch (Exception e) {
                errMsg = "Code: " + IntCode.toString() + " Facility: " + facilityMsg + " Severity: " + IntSev.toString() + " " + msg;
            }
            this.print(severity, errMsg);
            this.incrementMsgNum();
        }
    }

    public void log(int code, int facility) {
        this.log(code, facility, 0);
    }

    public void log(int code, int facility, int severity) {
        this.log(code, facility, severity, (Object[])null);
    }

    public void log(int facility, Throwable e) {
        this.log(facility, 0, e);
    }

    public void log(int facility, int severity, Throwable e) {
        this.log(9998, facility, severity, e);
    }

    public void log(int code, int facility, int severity, Throwable e) {
        this.log(code, facility, severity, e.getMessage());
        if (severity == 0 && this.getLevel() > 5 || severity > 0 && this.getLevel() >= severity) {
            e.printStackTrace();
        }
    }

    public void log(int code, int facility, Object[] args) {
        this.log(code, facility, 0, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int code, int facility, int severity, Object[] args) {
        String facilityMsg = null;
        String facilityProdComp = this.gProdComponent;
        String facilityProdGroup = this.gProdGroup;
        LogStringInfo LogInfo = null;
        if (severity > this.getLevel() || !this.isFacilitySet(facility)) {
            return;
        }
        try {
            Integer i = new Integer(facility);
            FacilityInfo facinfo = (FacilityInfo)this.gFacilityMap.get(i);
            facilityMsg = facinfo.facilityStr;
            if (facinfo.facilityGroup != null) {
                facilityProdGroup = facinfo.facilityGroup;
            }
            if (facinfo.facilityComp != null) {
                facilityProdComp = facinfo.facilityComp;
            }
            if (code == 9998 || code == 9999) {
                LogInfo = new LogStringInfo();
                LogInfo.gLogString = code == 9998 ? "Exception => " : "";
                LogInfo.gLogString = LogInfo.gLogString + (String)args[0];
                LogInfo.gSeverity = severity > 0 ? severity : 7;
            } else {
                Hashtable map = (Hashtable)this.gLogStringMap.get(i);
                if (map != null) {
                    i = new Integer(code);
                    LogInfo = (LogStringInfo)map.get(i);
                    if (severity > 0) {
                        LogInfo.gSeverity = severity;
                    }
                } else {
                    LogInfo = null;
                }
            }
        }
        catch (NumberFormatException e) {
            LogInfo = null;
        }
        catch (Exception e) {
            LogInfo = null;
        }
        if (LogInfo == null) {
            this.WriteDefaultLog(code, facility, severity, args);
        } else {
            if (LogInfo.gSeverity > this.getLevel()) {
                return;
            }
            if (args == null) {
                this.WriteLog(code, LogInfo.gSeverity, facility, facilityMsg, LogInfo.gLogString, facilityProdGroup, facilityProdComp);
            } else {
                try {
                    String errMsg;
                    MessageFormat e = this.gArgMsgFmt;
                    synchronized (e) {
                        this.gArgMsgFmt.applyPattern(LogInfo.gLogString);
                        errMsg = this.gArgMsgFmt.format(args).trim();
                    }
                    this.WriteLog(code, LogInfo.gSeverity, facility, facilityMsg, errMsg, facilityProdGroup, facilityProdComp);
                }
                catch (IllegalArgumentException e) {
                    this.WriteLog(code, 10, facility, "", "");
                }
                catch (Exception e) {
                    this.WriteLog(code, 10, facility, "", "");
                }
            }
        }
    }

    public void log(int code, int facility, String arg1) {
        this.log(code, facility, 0, arg1);
    }

    public void log(int code, int facility, int severity, String arg1) {
        String Arg1 = arg1 == null ? new String("null") : arg1;
        Object[] args = new Object[]{Arg1};
        this.log(code, facility, severity, args);
    }

    public void log(int code, int facility, String arg1, String arg2) {
        this.log(code, facility, 0, arg1, arg2);
    }

    public void log(int code, int facility, int severity, String arg1, String arg2) {
        String Arg1 = arg1 == null ? new String("null") : arg1;
        String Arg2 = arg2 == null ? new String("null") : arg2;
        Object[] args = new Object[]{Arg1, Arg2};
        this.log(code, facility, severity, args);
    }

    public void log(int code, int facility, long arg1) {
        this.log(code, facility, 0, arg1);
    }

    public void log(int code, int facility, int severity, long arg1) {
        Object[] args = new Object[]{Long.toString(arg1)};
        this.log(code, facility, severity, args);
    }

    public void log(int code, int facility, long arg1, long arg2) {
        this.log(code, facility, 0, arg1, arg2);
    }

    public void log(int code, int facility, int severity, long arg1, long arg2) {
        Object[] args = new Object[]{Long.toString(arg1), Long.toString(arg2)};
        this.log(code, facility, severity, args);
    }

    public void log(int code, int facility, Date arg1) {
        this.log(code, facility, 0, arg1);
    }

    public void log(int code, int facility, int severity, Date arg1) {
        Date Arg1 = arg1 == null ? new Date() : arg1;
        Object[] args = new Object[]{Arg1.toString()};
        this.log(code, facility, severity, args);
    }

    public void getSettings(Values serverSettings) {
        try {
            serverSettings.put("Facs", this.getFacility());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            serverSettings.put("DebugLevel", this.getLevel());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSettings(Values in) {
        String level;
        String[] facs;
        StringBuffer prop;
        try {
            prop = new StringBuffer();
        }
        catch (Exception e) {
            return;
        }
        String component = in.getString("component");
        boolean isServer = true;
        if (component != null) {
            isServer = component.equalsIgnoreCase("SERVER");
        }
        if ((facs = (String[])in.get("facilityList")) != null) {
            this.setFacility(1000);
            for (int i = 0; i < facs.length; ++i) {
                try {
                    if (prop.length() == 0) {
                        prop.append(facs[i]);
                    } else {
                        prop.append(", " + facs[i]);
                    }
                    int facility = Integer.parseInt(facs[i]);
                    this.setFacility(facility);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (isServer) {
                Config.setProperty("watt.debug2.facList", prop.toString());
            }
        } else {
            String logSettings = (String)in.get("setLogSettings");
            if (logSettings != null && logSettings.length() > 0) {
                this.setFacility(1000);
                if (isServer) {
                    Config.setProperty("watt.debug2.facList", "");
                }
            }
        }
        if ((level = (String)in.get("watt.debug.level")) != null) {
            try {
                this.setLevel(Integer.parseInt(level));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void Init(String dictionaryFile, String outputFile, Properties traceProps) throws FileNotFoundException, IOException {
        String loc_lang;
        Properties props = traceProps;
        if (props == null) {
            props = new Properties();
        }
        this.gCommentLine = props.getProperty("watt.debug2.commentLine", "#");
        this.gFormatLine = props.getProperty("watt.debug2.formatLine", "$");
        this.gOutputLine = props.getProperty("watt.debug2.outputLine", "%");
        this.gDateFormat = props.getProperty("watt.server.dateStampFmt", DEFAULT_DATE_FORMAT);
        try {
            loc_lang = props.getProperty("watt.debug.locale");
            if (loc_lang == null || loc_lang.length() == 0) {
                loc_lang = Locale.getDefault().getLanguage();
            }
        }
        catch (Exception e) {
            loc_lang = Locale.ENGLISH.getLanguage();
        }
        if (dictionaryFile == null || dictionaryFile.length() == 0) {
            String dictionary = props.getProperty("watt.debug2.logstringfile", "lib" + File.separator + "logstr");
            this.gLogStringFileName = dictionary + "_" + loc_lang + ".txt";
            File f = new File(this.gLogStringFileName);
            if (!f.exists()) {
                this.gLogStringFileName = dictionary + "_en.txt";
            }
        } else {
            this.gLogStringFileName = dictionaryFile + "_" + loc_lang + ".txt";
            File f = new File(this.gLogStringFileName);
            if (!f.exists()) {
                this.gLogStringFileName = dictionaryFile + "_en.txt";
            }
            if (!(f = new File(this.gLogStringFileName)).exists()) {
                this.gLogStringFileName = dictionaryFile;
            }
        }
        try {
            this.gCheckFullRate = Integer.parseInt(props.getProperty("watt.debug2.checkfullrate", "8"));
            this.gMaxLogSize = Long.parseLong(props.getProperty("watt.debug2.maxlogsize", "5000000"));
        }
        catch (NumberFormatException e) {
            this.gCheckFullRate = 8;
            this.gMaxLogSize = 5000000L;
        }
        if (dictionaryFile == null || dictionaryFile.length() == 0) {
            this.gMsgRes = new MsgResources(this.gResPath);
            this.gLogStringMap = this.gMsgRes.getLogStringMap();
            this.gFacilityMap = this.gMsgRes.getFacilityMap();
        } else {
            try {
                this.ReadLogStringMap(this.gLogStringFileName);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                throw e;
            }
        }
        if (outputFile != null && outputFile.length() != 0) {
            this.setLogFile(outputFile);
        }
        this.setFacility(1000);
        String facList = props.getProperty("watt.debug2.facList", Integer.toString(999));
        if (facList != null) {
            this.setFacility(facList);
        } else {
            this.setFacility(999);
        }
        this.gEnabled = true;
    }

    public void Init() throws FileNotFoundException, IOException {
        this.Init(null, null, System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFacility(int facility, String facilityString) throws IllegalArgumentException, Exception {
        if (facility < 1 || facility > this.gLogFacility.size()) {
            throw new IllegalArgumentException();
        }
        Hashtable hashtable = this.gFacilityMap;
        synchronized (hashtable) {
            FacilityInfo facinfo = new FacilityInfo(facilityString.trim(), null);
            this.gFacilityMap.put(new Integer(facility), facinfo);
        }
        Hashtable map = new Hashtable(10);
        Hashtable hashtable2 = this.gLogStringMap;
        synchronized (hashtable2) {
            this.gLogStringMap.put(new Integer(facility), map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorCode(int facility, int errorCode, int severity, String formatMessage) throws IllegalArgumentException, Exception {
        if (errorCode < 0 || severity < 0 || facility < 1 || facility > this.gLogFacility.size()) {
            throw new IllegalArgumentException();
        }
        Hashtable facMap = null;
        Hashtable hashtable = this.gLogStringMap;
        synchronized (hashtable) {
            facMap = (Hashtable)this.gLogStringMap.get(new Integer(facility));
            if (facMap == null) {
                throw new Exception("No Such Facility");
            }
            LogStringInfo LogInfo = new LogStringInfo();
            LogInfo.gSeverity = severity;
            LogInfo.gLogString = formatMessage;
            facMap.put(new Integer(errorCode), LogInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            Hashtable hashtable = gOpenedFiles;
            synchronized (hashtable) {
                gOpenedFiles.remove(this.getLogFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getSeverityAsStr(int severity) {
        if (severity < 0 || severity > 10) {
            return null;
        }
        return SEVERITY_STRING[severity > 5 ? 5 : severity];
    }

    public void setLogStream(OutputStream stream) {
        try {
            if (this.log != System.out && this.log != System.err) {
                this.log.close();
            }
            System.setErr(new PrintStream(stream));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log = stream;
    }

    public OutputStream getLogStream() {
        return this.log;
    }

    public String getLogFile() {
        return this.logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogFile(String file) {
        this.logFile = file;
        if (file == null) {
            this.logToFile = false;
            this.setLogStream(System.out);
            return;
        }
        if (file.equalsIgnoreCase("none") || file.equals("-")) {
            this.logToFile = false;
            this.setLogStream(System.out);
            return;
        }
        try {
            File f = new File(file);
            this.gOutFileCreated = !f.exists();
            this.setLogStream(new FileOutputStream(file, true));
            this.logToFile = true;
            this.writeInitLine();
            Hashtable hashtable = gOpenedFiles;
            synchronized (hashtable) {
                gOpenedFiles.put(this.getLogFile(), this);
            }
        }
        catch (Exception e) {
            this.logFile = null;
            this.logToFile = false;
            this.setLogStream(System.out);
        }
    }

    public boolean isLogToConsole() {
        return this.log != null && (this.log == System.out || this.log == System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogToConsole() {
        this.setLogStream(System.out);
        if (this.isLogToServerStream()) {
            MessageFormat messageFormat = this.gMsgFmt;
            synchronized (messageFormat) {
                this.gMsgFmt.applyPattern(Debug2.getLogOutputFormat());
            }
        }
    }

    public boolean isLogToServerStream() {
        return this.log != null && this.log == Debug2.dbg.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogToServerStream() {
        this.setLogStream(Debug2.dbg.log);
        MessageFormat messageFormat = this.gMsgFmt;
        synchronized (messageFormat) {
            this.gMsgFmt.applyPattern(Debug2.getLogOutputFormat());
        }
    }

    public String getDateStamp() {
        try {
            if (this.gDateFormat != null) {
                return DateTimeDT.currentDate(this.gDateFormat, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DateTimeDT.currentDate(DEFAULT_DATE_FORMAT, null);
    }

    public synchronized void setLevel(String lvl) {
        try {
            this.level = Integer.valueOf(lvl);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public synchronized void setLevel(int lvl) {
        this.level = lvl;
    }

    public int getLevel() {
        return this.level;
    }

    public void dateMark() {
        String outFormat = this.getLogOutputFormat();
        this.setLogOutputFormat("{4}  {1}  {3}");
        try {
            this.WriteLog(9999, 1, 998, "-----------", this.getDateStamp());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLogOutputFormat(outFormat);
    }

    public void log(int lvl, String msg) {
        try {
            this.WriteLog(9999, lvl, 998, dash, msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void log(int lvl, Throwable e, String msg) {
        try {
            this.WriteLog(9999, lvl, 998, dash, msg);
            if (this.getLevel() > 5) {
                e.printStackTrace();
            }
        }
        catch (Exception ee) {
            // empty catch block
        }
    }

    public void log(int lvl, String func, String msg) {
        try {
            String pad = dash;
            int l = func.length() < pad.length() ? pad.length() - func.length() : 0;
            String fac = func + pad.substring(0, l);
            this.WriteLog(9999, lvl, 998, fac.substring(0, 6).toUpperCase(), msg);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(String msg) {
        String enc = null;
        enc = this.isLogToConsole() ? EncUtil.getLogEncoding() : EncUtil.getLogFileEncoding();
        try {
            OutputStream outputStream = this.log;
            synchronized (outputStream) {
                if (enc == null) {
                    this.log.write(msg.getBytes());
                } else {
                    this.log.write(msg.getBytes(enc));
                }
            }
        }
        catch (IOException e) {
            System.err.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(int lvl, String msg) {
        if (Debug2.isEnabled() && this.isLogToServerStream()) {
            Debug2.write(msg);
            return;
        }
        String enc = null;
        enc = this.isLogToConsole() ? EncUtil.getLogEncoding() : EncUtil.getLogFileEncoding();
        try {
            OutputStream outputStream = this.log;
            synchronized (outputStream) {
                if (enc == null) {
                    this.log.write((msg + sep).getBytes());
                } else {
                    this.log.write((msg + sep).getBytes(enc));
                }
            }
        }
        catch (IOException e) {
            System.err.println(msg);
        }
    }

    protected String pad(String msg, int width) {
        int l = msg.length();
        if (l <= width) {
            return msg + space.substring(0, width - l);
        }
        return msg.substring(0, width - 3) + "...";
    }

    protected String proc(String msg) {
        if (msg == null) {
            return "";
        }
        return msg.replace('\u0000', '_');
    }

    protected String num() {
        String ns = Integer.toString(this.getMsgNum());
        int l = ns.length() < 5 ? 5 - ns.length() : 0;
        return ns + ") " + space.substring(0, l);
    }

    protected String hexNum() {
        String ns = Integer.toHexString(this.getMsgNum()).toUpperCase();
        int l = ns.length() < zeros.length() ? zeros.length() - ns.length() : 0;
        return zeros.substring(0, l) + ns;
    }

    protected synchronized void incrementMsgNum() {
        if (Debug2.isEnabled() && this.isLogToServerStream()) {
            ++Debug2.dbg.msgnum;
        } else {
            ++this.msgnum;
        }
    }

    public boolean isEnabled() {
        return this.gEnabled;
    }

    protected int getMsgNum() {
        if (Debug2.isEnabled() && this.isLogToServerStream()) {
            return Debug2.dbg.msgnum;
        }
        return this.msgnum;
    }

    public void noValidKey(String wmProduct) {
        this.noValidKey(wmProduct, false);
    }

    public void noValidKey(String wmProduct, boolean fatal) {
        this.log(1, "Product Key", "no valid key was found for " + wmProduct);
        this.log(1, "Product Key", "please contact webMethods to obtain a current key");
        if (fatal) {
            System.exit(1);
        }
    }

    public void wait(int millis) {
        long startMillis = System.currentTimeMillis();
        long endMillis = startMillis + (long)millis;
        while (System.currentTimeMillis() < endMillis) {
        }
    }

    public void waitForEnter() {
        try {
            while (System.in.available() != 0) {
                System.in.read();
            }
            System.in.read();
            while (System.in.available() != 0) {
                System.in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printStackTrace() {
        new Exception().printStackTrace();
    }

    protected void writeInitLine() {
        this.dateMark();
    }

    public void scheduleLogRotate() {
        if (this.gArchiveScheduler != null) {
            return;
        }
        try {
            this.gArchiveScheduler = new Cron(2, 2, "Trace File Archive Daemon");
            CronJob job = new CronJob("Trace File Archive Job", new ArchiveJob(this), System.currentTimeMillis() + Trace.getTimeUntilFirstRecycle(), Trace.getInterval());
            this.gArchiveScheduler.scheduleTask(job);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long getTimeUntilFirstRecycle() {
        GregorianCalendar now = new GregorianCalendar();
        int tillTomorrow = ((24 - now.get(11) - 1) * 60 + (60 - now.get(12))) * 60000;
        String test = Config.getProperty("watt.server.logRotateFirstInterval");
        int testinterval = 0;
        if (test != null) {
            try {
                tillTomorrow = testinterval = Integer.valueOf(test).intValue();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return tillTomorrow;
    }

    public static long getInterval() {
        long interval = 86400000L;
        String test = Config.getProperty("watt.server.logRotateInterval");
        long testinterval = 0L;
        if (test != null) {
            try {
                interval = testinterval = (long)Integer.valueOf(test).intValue();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return interval;
    }

    public static void main(String[] args) {
        Trace dbgTrace = new Trace(null, "\\server.log");
        try {
            dbgTrace.addFacility(1, "ABC");
            dbgTrace.addFacility(2, "DEF");
            dbgTrace.addErrorCode(1, 105, 3, "Hello, how are you ?");
            dbgTrace.addErrorCode(1, 106, 9, "{0}, how are you ?");
            dbgTrace.addErrorCode(1, 107, 5, "{0}, how are you {1} ?");
            dbgTrace.addErrorCode(2, 105, 3, "{0}, how are you {1} ?");
            dbgTrace.addErrorCode(2, 106, 9, "{0}, how are you {1} ?");
            dbgTrace.addErrorCode(2, 107, 5, "{0}, how are you {1} ?");
        }
        catch (Exception e) {
            System.err.println("uh-oh");
        }
        dbgTrace.setFacility(1000);
        dbgTrace.setFacility(2);
        dbgTrace.setLevel(5);
        System.err.println(dbgTrace.isLogEnabledForCode(105, 1) + " " + dbgTrace.isLogEnabledForCode(106, 1) + " " + dbgTrace.isLogEnabledForCode(107, 1));
        System.err.println(dbgTrace.isLogEnabledForCode(105, 2) + " " + dbgTrace.isLogEnabledForCode(106, 2) + " " + dbgTrace.isLogEnabledForCode(107, 2));
        System.err.println(dbgTrace.isLogEnabledForCode(108, 2) + " " + dbgTrace.isLogEnabledForCode(107, 3));
    }
}

