/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedMap<K, V>
extends TreeMap<K, V> {
    private Map<K, Date> _accessTimes = new TreeMap<K, Date>();
    private long _maxTimeInMillis;
    private long _lastSweepTime = 0L;

    public void touch(K key) {
        this._accessTimes.put(key, new Date());
    }

    public void setMaxTime(long timeInMillis) {
        this._maxTimeInMillis = timeInMillis;
    }

    public void sweep() {
        long now = System.currentTimeMillis();
        ArrayList<K> toRemove = new ArrayList<K>();
        for (Object key : this._accessTimes.keySet()) {
            Date access = this._accessTimes.get(key);
            long timeSince = now - access.getTime();
            if (timeSince <= this._maxTimeInMillis) continue;
            toRemove.add(key);
        }
        for (Object key : toRemove) {
            this.remove(key);
        }
        this._lastSweepTime = now;
    }

    @Override
    public V remove(Object key) {
        Object val = super.remove(key);
        this._accessTimes.remove(key);
        return val;
    }

    @Override
    public V get(Object key) {
        Object val = super.get(key);
        this.touch(key);
        return val;
    }

    @Override
    public V put(K key, V value) {
        V orig = super.put(key, value);
        if (System.currentTimeMillis() > this._lastSweepTime + this._maxTimeInMillis) {
            this.sweep();
        }
        this.touch(key);
        return orig;
    }

    public static void main(String[] args) {
        TimedMap<String, Integer> map = new TimedMap<String, Integer>();
        map.setMaxTime(500L);
        long start = System.currentTimeMillis();
        map.put("hello", 5);
        map.put("world", 10);
        System.out.println("map: " + map);
        System.out.println("dur: " + (System.currentTimeMillis() - start));
        for (String x : new String[]{"this", "is", "a", "test"}) {
            map.put(x, x.length());
            System.out.println("map: " + map);
            System.out.println("dur: " + (System.currentTimeMillis() - start));
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        map.sweep();
    }
}

