/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.Cron;
import com.wm.util.CronJob;
import java.util.Enumeration;
import java.util.Hashtable;

public class TimedHash
implements Runnable {
    private Cron cron;
    private Hashtable hash;
    private long timeout;
    private CronJob job;

    public TimedHash(Cron cron, long timeout) {
        this(cron, timeout, 11);
    }

    public TimedHash(Cron cron, long timeout, int size) {
        this.cron = cron;
        this.hash = new Hashtable(size);
        this.timeout = timeout;
        this.job = new CronJob("Timed Hash", this, 0L, 60000L);
        cron.scheduleTask(this.job);
    }

    public synchronized Object get(Object key) {
        wrapper w = (wrapper)this.hash.get(key);
        if (w != null) {
            return w.touch();
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        wrapper w = (wrapper)this.hash.get(key);
        if (w == null) {
            return this.hash.put(key, new wrapper(key, value));
        }
        return w.set(value);
    }

    public synchronized void remove(Object key) {
        this.hash.remove(key);
    }

    public void stopHash() {
        this.cron.cancelTask(this.job);
    }

    public int size() {
        return this.hash.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long now = System.currentTimeMillis();
        TimedHash timedHash = this;
        synchronized (timedHash) {
            Enumeration e = this.hash.keys();
            while (e.hasMoreElements()) {
                Object k = e.nextElement();
                wrapper v = (wrapper)this.hash.get(k);
                if (!v.expire(now, this.timeout)) continue;
                this.remove(k);
            }
        }
    }

    class wrapper
    implements Runnable {
        long touched;
        Object key;
        Object value;

        wrapper(Object key, Object value) {
            this.key = key;
            this.value = value;
            this.touch();
        }

        Object touch() {
            this.touched = System.currentTimeMillis();
            return this.value;
        }

        Object set(Object newval) {
            Object old = this.value;
            this.value = newval;
            this.touch();
            return old;
        }

        public boolean expire(long now, long timeout) {
            return now - this.touched > timeout;
        }

        public void run() {
            TimedHash.this.remove(this.key);
        }
    }
}

