/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.pool.ObjectPool;
import com.wm.util.pool.PooledObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ThreadSafeSimpleDateFormat {
    String formatString;
    private final int initialPoolSize;
    private final int maxPoolSize;
    private DateFormatPool pool = null;
    private long waitTime = -1L;
    private boolean blocking = true;

    public ThreadSafeSimpleDateFormat(String format, int initialPoolSize, int maxPoolSize) {
        this.formatString = format;
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.pool = new DateFormatPool(initialPoolSize, maxPoolSize, "Date Object Pool", this.formatString);
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
        if (waitTime < 0L) {
            this.blocking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date) {
        DateFormatObject dateFormat = (DateFormatObject)this.pool.allocate(this.blocking, this.waitTime);
        if (dateFormat != null) {
            try {
                dateFormat.setTimeZone(TimeZone.getDefault());
                String string = dateFormat.format(date);
                return string;
            }
            finally {
                this.pool.release(dateFormat);
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.formatString, Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return simpleDateFormat.format(date);
    }

    class DateFormatPool
    extends ObjectPool {
        String formatString;

        public DateFormatPool(int minPool, int maxPool, String pname, String format) {
            super(minPool, maxPool, pname, true);
            this.formatString = format;
            this.initPool();
        }

        public DateFormatPool() {
            super(2, 5, "SimpleDateFormat Pool");
        }

        public PooledObject createObject() {
            return new DateFormatObject(this);
        }

        public void release(DateFormatObject object) {
            super.release(object);
        }

        public DateFormatObject getFree(long time, long value) {
            DateFormatObject e = (DateFormatObject)this.allocate();
            return e;
        }
    }

    class DateFormatObject
    extends PooledObject {
        private SimpleDateFormat simpleDateFormat;

        public DateFormatObject(ObjectPool pool) {
            super(pool);
            this.simpleDateFormat = new SimpleDateFormat(ThreadSafeSimpleDateFormat.this.formatString, Locale.US);
        }

        public String format(Date date) {
            return this.simpleDateFormat.format(date);
        }

        public void setTimeZone(TimeZone zone) {
            this.simpleDateFormat.setTimeZone(zone);
        }

        public void poolInit() {
        }

        public void poolFree() {
        }
    }
}

