/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.util.Values;
import com.wm.util.coder.Codable;
import com.wm.util.pluggable.WmIDataList;
import com.wm.util.pluggable.WmIndexException;
import com.wm.util.pluggable.resources.PluggableExceptionBundle;
import java.util.Vector;

public final class Table
implements Codable,
IDataPortable,
WmIDataList {
    public String name;
    public String[] cols;
    public String[] sizes;
    public Vector rows = new Vector();

    public Table() {
    }

    public Table(String[] cols) {
        this.cols = cols;
    }

    public Table(String name, String[] cols) {
        this(cols);
        this.name = name;
    }

    public Table(String name, String[] cols, String[] sizes) {
        this(name, cols);
        this.sizes = sizes;
    }

    public void addRow(Values v) {
        if (v == null) {
            return;
        }
        Object[] row = this.createRow(v);
        this.rows.addElement(row);
    }

    public void addRow(Object[] o) {
        if (o == null) {
            return;
        }
        this.rows.addElement(o);
    }

    public void deleteRow(int idx) {
        this.rows.removeElementAt(idx);
    }

    public void updateRow(int idx, Values v) {
        if (v == null) {
            return;
        }
        Object[] row = this.createRow(v);
        this.rows.setElementAt(row, idx);
    }

    public void insertRow(int idx, Values v) {
        if (v == null) {
            return;
        }
        Object[] row = this.createRow(v);
        this.rows.insertElementAt(row, idx);
    }

    public String[] getColumnNames() {
        return this.cols;
    }

    public Values getRow(int idx) {
        Object[] row = (Object[])this.rows.elementAt(idx);
        Values vrow = new Values();
        for (int j = 0; j < this.cols.length; ++j) {
            vrow.put(this.cols[j], row[j]);
        }
        return vrow;
    }

    public Values[] getValues() {
        int len = this.rows.size();
        Values[] result = new Values[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.getRow(i);
        }
        return result;
    }

    public Values toValues() {
        Values result = new Values();
        result.put("name", this.name);
        result.put("data", this.getValues());
        result.put("cols", this.cols);
        result.put("sizes", this.sizes);
        return result;
    }

    public void appendRows(Values[] v) {
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.length; ++i) {
            this.addRow(v[i]);
        }
    }

    public void setRows(Values[] v) {
        this.rows = new Vector();
        this.appendRows(v);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    private Object[] createRow(Values v) {
        int len = this.cols.length;
        Object[] row = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object o = v.get(this.cols[i]);
            if (o == null) continue;
            row[i] = o;
        }
        return row;
    }

    private Object[] createRow(IData v) {
        int len = this.cols.length;
        Object[] row = new Object[len];
        IDataCursor idc = v.getCursor();
        for (int i = 0; i < len; ++i) {
            if (!idc.first(this.cols[i])) continue;
            row[i] = idc.getValue();
        }
        idc.destroy();
        return row;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("com.wm.util.Table " + this.name + " (");
        if (this.cols != null) {
            for (int i = 0; i < this.cols.length; ++i) {
                sb.append(this.cols[i]);
                if (i == this.cols.length - 1) continue;
                sb.append(", ");
            }
        }
        if (this.rows != null) {
            sb.append(") " + this.rows.size() + " rows");
        }
        return sb.toString();
    }

    public IData getIData() {
        IData id = IDataFactory.create();
        IDataCursor result = id.getCursor();
        result.last();
        result.insertAfter("name", this.name);
        result.insertAfter("rows", this.rows);
        result.insertAfter("cols", this.cols);
        result.insertAfter("sizes", this.sizes);
        result.destroy();
        return id;
    }

    public void setIData(IData id) {
        IDataCursor result = id.getCursor();
        if (result.first("name")) {
            this.name = IDataUtil.getString(result);
        }
        if (result.first("cols")) {
            this.cols = IDataUtil.getStringArray(result);
        }
        if (result.first("sizes")) {
            this.sizes = IDataUtil.getStringArray(result);
        }
        if (result.first("rows")) {
            this.rows = (Vector)result.getValue();
        } else if (result.first("data")) {
            Values[] data = (Values[])result.getValue();
            for (int i = 0; i < data.length; ++i) {
                this.setRows(data);
            }
        }
        result.destroy();
    }

    public Object getValue(String key) {
        if (key.equals("cols")) {
            return this.cols;
        }
        if (key.equals("rows")) {
            return this.rows;
        }
        if (key.equals("name")) {
            return this.name;
        }
        if (key.equals("sizes")) {
            return this.sizes;
        }
        return null;
    }

    public void setValue(String key, Object value) {
        if (key.equals("cols")) {
            this.cols = (String[])value;
        } else if (key.equals("rows")) {
            this.rows = (Vector)value;
        } else if (key.equals("name")) {
            this.name = (String)value;
        } else if (key.equals("sizes")) {
            this.sizes = (String[])value;
        } else if (key.equals("data")) {
            Values[] data = (Values[])value;
            for (int i = 0; i < data.length; ++i) {
                this.setRows(data);
            }
        }
    }

    public String[] getValueKeys() {
        String[] s = new String[]{"cols", "rows", "name", "sizes"};
        return s;
    }

    public Class getPluggableType() {
        return null;
    }

    public Class getBaseType() {
        return this.getClass();
    }

    public int getDimension() {
        return 1;
    }

    public Class getType() {
        return null;
    }

    public void putItemAt(IData item, int idx) throws WmIndexException {
        if (item == null) {
            return;
        }
        Object[] row = this.createRow(item);
        if (idx < 0) {
            Object[] subs = new String[]{Integer.toString(idx), Integer.toString(this.rows.size())};
            throw new WmIndexException(PluggableExceptionBundle.class, PluggableExceptionBundle.TABLE_INDEX, "", subs);
        }
        if (idx >= this.rows.size()) {
            this.rows.addElement(row);
        } else {
            this.rows.setElementAt(row, idx);
        }
    }

    public IData getItemAt(int idx) throws WmIndexException {
        if (idx < 0 || idx > this.rows.size()) {
            Object[] subs = new String[]{Integer.toString(idx), Integer.toString(this.rows.size())};
            throw new WmIndexException(PluggableExceptionBundle.class, PluggableExceptionBundle.TABLE_INDEX, "", subs);
        }
        Object[] row = (Object[])this.rows.elementAt(idx);
        IData vrow = IDataFactory.create();
        IDataCursor idc = vrow.getCursor();
        for (int j = 0; j < this.cols.length; ++j) {
            idc.insertAfter(this.cols[j], row[j]);
        }
        idc.destroy();
        return vrow;
    }

    public void putItems(IData[] items) {
        try {
            for (int i = 0; i < items.length; ++i) {
                this.putItemAt(items[i], i);
            }
        }
        catch (WmIndexException wmIndexException) {
            // empty catch block
        }
    }

    public IData[] getItems() {
        int len = this.rows.size();
        IData[] result = new IData[len];
        try {
            for (int i = 0; i < len; ++i) {
                result[i] = this.getItemAt(i);
            }
        }
        catch (WmIndexException wmIndexException) {
            // empty catch block
        }
        return result;
    }

    public void deleteItemAt(int idx) throws WmIndexException {
        if (idx < 0 || idx > this.rows.size()) {
            Object[] subs = new String[]{Integer.toString(idx), Integer.toString(this.rows.size())};
            throw new WmIndexException(PluggableExceptionBundle.class, PluggableExceptionBundle.TABLE_INDEX, "", subs);
        }
        this.rows.removeElementAt(idx);
    }

    public int getSize() {
        return this.rows.size();
    }

    public IData getAsData() {
        return this.getIData();
    }

    public void setFromData(IData data) {
        this.setIData(data);
    }
}

