/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.ByteOutputBuffer;
import com.wm.util.List;
import com.wm.util.sort.QuickSort;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public final class Strings {
    static final String[] a = new String[]{"123", "234", "345", "456", "567", "678"};

    public static String pad(String s, char pc, int len) {
        return Strings.rpad(s, pc, len);
    }

    public static String lpad(String s, char pc, int len) {
        if (s.length() >= len) {
            return s.substring(0, len);
        }
        StringBuffer sb = new StringBuffer();
        int diff = len - s.length();
        for (int i = 0; i < diff; ++i) {
            sb.append(pc);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String rpad(String s, char pc, int len) {
        if (s.length() >= len) {
            return s.substring(0, len);
        }
        StringBuffer sb = new StringBuffer(s);
        int diff = len - s.length();
        for (int i = 0; i < diff; ++i) {
            sb.append(pc);
        }
        return sb.toString();
    }

    public static String[] sort(String[] s) {
        return QuickSort.sort(s);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String getErrorText(Throwable err, boolean compact) {
        ByteOutputBuffer b = new ByteOutputBuffer();
        PrintWriter ps = new PrintWriter(b);
        err.printStackTrace(ps);
        ps.flush();
        String msg = new String(b.toByteArray());
        if (!compact) {
            return msg;
        }
        StringTokenizer st = new StringTokenizer(msg, "\n");
        st.nextToken();
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken().trim().substring(3) + System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    public static void writeLow(OutputStream os, String s) throws IOException {
        if (s == null) {
            return;
        }
        int sl = s.length();
        char[] c = new char[sl];
        s.getChars(0, sl, c, 0);
        byte[] b = new byte[sl];
        for (int i = 0; i < sl; ++i) {
            b[i] = (byte)(c[i] & 0xFF);
        }
        os.write(b);
    }

    public static String cat(String s1, String s2) {
        int s1l = s1.length();
        int s2l = s2.length();
        char[] c = new char[s1l + s2l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        return new String(c);
    }

    public static String cat(String s1, String s2, String s3) {
        int s1l = s1.length();
        int s2l = s2.length();
        int s3l = s3.length();
        char[] c = new char[s1l + s2l + s3l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        s3.getChars(0, s3l, c, s1l + s2l);
        return new String(c);
    }

    public static String cat(String s1, String s2, String s3, String s4) {
        int s1l = s1.length();
        int s2l = s2.length();
        int s3l = s3.length();
        int s4l = s4.length();
        char[] c = new char[s1l + s2l + s3l + s4l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        s3.getChars(0, s3l, c, s1l + s2l);
        s4.getChars(0, s4l, c, s1l + s2l + s3l);
        return new String(c);
    }

    public static String cat(String s1, String s2, String s3, String s4, String s5) {
        int s1l = s1.length();
        int s2l = s2.length();
        int s3l = s3.length();
        int s4l = s4.length();
        int s5l = s5.length();
        char[] c = new char[s1l + s2l + s3l + s4l + s5l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        s3.getChars(0, s3l, c, s1l + s2l);
        s4.getChars(0, s4l, c, s1l + s2l + s3l);
        s5.getChars(0, s5l, c, s1l + s2l + s3l + s4l);
        return new String(c);
    }

    public static String cat(String s1, String s2, String s3, String s4, String s5, String s6) {
        int s1l = s1.length();
        int s2l = s2.length();
        int s3l = s3.length();
        int s4l = s4.length();
        int s5l = s5.length();
        int s6l = s6.length();
        char[] c = new char[s1l + s2l + s3l + s4l + s5l + s6l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        s3.getChars(0, s3l, c, s1l + s2l);
        s4.getChars(0, s4l, c, s1l + s2l + s3l);
        s5.getChars(0, s5l, c, s1l + s2l + s3l + s4l);
        s6.getChars(0, s6l, c, s1l + s2l + s3l + s4l + s5l);
        return new String(c);
    }

    public static String cat(String s1, String s2, String s3, String s4, String s5, String s6, String s7) {
        int s1l = s1.length();
        int s2l = s2.length();
        int s3l = s3.length();
        int s4l = s4.length();
        int s5l = s5.length();
        int s6l = s6.length();
        int s7l = s7.length();
        char[] c = new char[s1l + s2l + s3l + s4l + s5l + s6l + s7l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        s3.getChars(0, s3l, c, s1l + s2l);
        s4.getChars(0, s4l, c, s1l + s2l + s3l);
        s5.getChars(0, s5l, c, s1l + s2l + s3l + s4l);
        s6.getChars(0, s6l, c, s1l + s2l + s3l + s4l + s5l);
        s7.getChars(0, s7l, c, s1l + s2l + s3l + s4l + s5l + s6l);
        return new String(c);
    }

    public static String replace(String str, String match, String replace) {
        int last = 0;
        int idx = 0;
        int len = str.length();
        int mlen = match.length();
        StringBuffer sb = new StringBuffer(len);
        while (true) {
            if ((idx = str.indexOf(match, idx)) < 0) break;
            if (idx - last > 0) {
                sb.append(str.substring(last, idx));
            }
            sb.append(replace);
            last = idx += mlen;
        }
        sb.append(str.substring(last));
        return sb.toString();
    }

    public static String[] parseCSL(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        List l = new List();
        StringReader r = new StringReader(s);
        StringBuffer sb = new StringBuffer();
        boolean idx = false;
        try {
            int ch;
            block6: while ((ch = r.read()) != -1) {
                switch (ch) {
                    case 92: {
                        ch = r.read();
                        if (ch == -1) continue block6;
                        sb.append((char)ch);
                        continue block6;
                    }
                    case 44: {
                        l.addElement(sb.toString());
                        sb.setLength(0);
                        continue block6;
                    }
                }
                sb.append((char)ch);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (sb.length() > 0) {
            l.addElement(sb.toString());
        }
        Object[] arr = new String[l.size()];
        l.copyInto(arr);
        return arr;
    }

    public static String[] getCSL(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        List l = new List();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String next = st.nextToken().trim();
            l.addElement(next);
        }
        Object[] arr = new String[l.size()];
        l.copyInto(arr);
        return arr;
    }

    public static byte[] getBytesUTF8(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getStringUTF8(byte[] b) {
        try {
            return new String(b, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        String s5;
        String s4;
        String s3;
        String s2;
        String s1;
        if (args.length < 4) {
            args = a;
        }
        int loops = 100000;
        System.out.println(Strings.cat(a[0], a[1]));
        System.out.println(Strings.cat(a[0], a[1], a[2]));
        System.out.println(Strings.cat(a[0], a[1], a[2], a[3]));
        System.out.println(Strings.cat(a[0], a[1], a[2], a[3], a[4]));
        System.out.println(Strings.cat(a[0], a[1], a[2], a[3], a[4], a[5]));
        long start = System.currentTimeMillis();
        String a = args[0];
        String b = args[1];
        String c = args[2];
        String d = args[3];
        String e = args[4];
        String f = args[5];
        for (int i = 0; i < loops; ++i) {
            s1 = a + b;
            s2 = a + b + c;
            s3 = a + b + c + d;
            s4 = a + b + c + d + e;
            s5 = a + b + c + d + e + f;
        }
        long time = System.currentTimeMillis() - start;
        long ops1 = (long)(loops * 1000) / (time + 1L);
        System.out.println("test 1) " + time + " = " + ops1 + " ops/s");
        start = System.currentTimeMillis();
        for (int i = 0; i < loops; ++i) {
            s1 = Strings.cat(a, b);
            s2 = Strings.cat(a, b, c);
            s3 = Strings.cat(a, b, c, d);
            s4 = Strings.cat(a, b, c, d, e);
            s5 = Strings.cat(a, b, c, d, e, f);
        }
        time = System.currentTimeMillis() - start;
        long ops2 = (long)(loops * 1000) / (time + 1L);
        System.out.println("test 2) " + time + " = " + ops2 + " ops/s");
        System.out.println(ops2 * 100L / ops1 + "% faster");
        System.out.println(Strings.replace("123 12323  12123", "123", "xxx"));
        System.out.println(Strings.replace("xxx xxxxx  xxxxx", "xxx", "123"));
        System.out.println(Strings.replace("xxx xxxxxx xxxxx", "xxx", "123"));
    }
}

