/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.Name;
import com.wm.util.StringSetEntry;
import com.wm.util.StringSetEnumerator;
import com.wm.util.coder.Codable;
import java.util.Enumeration;
import java.util.Vector;

public class StringSet
implements Codable {
    private StringSetEntry[] table = new StringSetEntry[this.capacity];
    private int count;
    private int threshold = (int)((float)this.capacity * this.loadFactor);
    private float loadFactor = 0.75f;
    private int capacity = 101;

    public Enumeration elements() {
        return new StringSetEnumerator(this.table);
    }

    public void insert(String name) {
        this.insert(Name.create(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Name name) {
        StringSetEntry[] stringSetEntryArray = this.table;
        synchronized (this.table) {
            boolean i = false;
            if (this.contains(name)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.count >= this.threshold) {
                this.rehash();
            }
            int hash = name.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.capacity;
            StringSetEntry e = new StringSetEntry();
            e.name = name;
            e.next = this.table[index];
            this.table[index] = e;
            ++this.count;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int size() {
        return this.count;
    }

    public String remove(String name) {
        return this.remove(Name.create(name)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name remove(Name name) {
        StringSetEntry[] stringSetEntryArray = this.table;
        synchronized (this.table) {
            int hash = name.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.capacity;
            StringSetEntry e = this.table[index];
            StringSetEntry prev = null;
            while (e != null) {
                if (e.name == name) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        this.table[index] = e.next;
                    }
                    --this.count;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return name;
                }
                prev = e;
                e = e.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public boolean contains(String name) {
        return this.contains(Name.create(name));
    }

    public boolean contains(Name name) {
        int hash = name.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.capacity;
        StringSetEntry e = this.table[index];
        while (e != null) {
            if (e.name == name) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    private void rehash() {
        int oldcap = this.capacity;
        this.capacity = this.capacity * 2 + 1;
        StringSetEntry[] newTable = new StringSetEntry[this.capacity];
        this.threshold = (int)((float)this.capacity * this.loadFactor);
        int i = oldcap;
        while (i-- > 0) {
            StringSetEntry old = this.table[i];
            while (old != null) {
                StringSetEntry e = old;
                old = old.next;
                int hash = e.name.hashCode();
                int index = (hash & Integer.MAX_VALUE) % this.capacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
        this.table = newTable;
    }

    public Object getValue(String key) {
        if (!key.equals("elements")) {
            return null;
        }
        Vector<String> elements = new Vector<String>();
        int i = this.capacity;
        while (i-- > 0) {
            StringSetEntry e = this.table[i];
            while (e != null) {
                elements.addElement(e.name.toString());
                e = e.next;
            }
        }
        return elements;
    }

    public void setValue(String key, Object value) {
        if (!key.equals("elements")) {
            return;
        }
        if (!(value instanceof Vector)) {
            return;
        }
        Vector v = (Vector)value;
        int l = v.size();
        for (int i = 0; i < l; ++i) {
            this.insert((String)v.elementAt(i));
        }
    }

    public String[] getValueKeys() {
        String[] s = new String[]{"elements"};
        return s;
    }

    public static void main(String[] args) {
        StringSet ss = new StringSet();
        for (int i = 0; i < args.length; ++i) {
            ss.insert(args[i]);
        }
        if (ss.contains(args[0])) {
            System.out.println("true");
        }
        ss.remove(args[0]);
        if (ss.contains(args[0])) {
            System.out.println("false");
        }
        Enumeration e = ss.elements();
        while (e.hasMoreElements()) {
            System.out.println((String)e.nextElement());
        }
    }
}

