/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.List;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringParser {
    private String s;
    private String dCh;
    private String qCh;
    private List tokens;
    private Enumeration enumvar;
    char[] curToken = new char[50];
    int tokPos = 0;

    public void addTokChar(char ch) {
        if (this.tokPos >= this.curToken.length) {
            char[] newTok = new char[this.curToken.length * 2];
            System.arraycopy(this.curToken, 0, newTok, 0, this.curToken.length);
            this.curToken = newTok;
        }
        this.curToken[this.tokPos++] = ch;
    }

    public String getTokString() {
        return new String(this.curToken, 0, this.tokPos);
    }

    public StringParser(String s, char delimCh, char quoteCh) {
        this.parse(s, new Character(delimCh).toString(), new Character(quoteCh).toString(), true);
    }

    public StringParser(String s, String delimCh, String quoteCh, boolean inclQuoteCh) {
        this.parse(s, delimCh, quoteCh, inclQuoteCh);
    }

    private void parse(String s, String delimCh, String quoteCh, boolean inclQuoteCh) {
        this.s = s;
        this.dCh = delimCh;
        this.qCh = quoteCh;
        this.tokens = new List();
        boolean inLiteral = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == quoteChar) {
                inLiteral = false;
                quoteChar = '\u0000';
                if (!inclQuoteCh) continue;
                this.addTokChar(ch);
                continue;
            }
            if (quoteChar == '\u0000' && this.qCh.indexOf(ch) != -1) {
                quoteChar = ch;
                inLiteral = true;
                if (!inclQuoteCh) continue;
                this.addTokChar(ch);
                continue;
            }
            if (this.dCh.indexOf(ch) != -1) {
                if (i <= 0) continue;
                if (inLiteral) {
                    this.addTokChar(ch);
                    continue;
                }
                this.tokens.addElement(this.getTokString());
                this.tokPos = 0;
                continue;
            }
            if (ch == '\\') {
                if (i < s.length() - 1 && (!inLiteral && this.dCh.indexOf(s.charAt(i + 1)) >= 0 || this.qCh.indexOf(s.charAt(i + 1)) >= 0)) {
                    this.addTokChar(s.charAt(++i));
                    continue;
                }
                this.addTokChar(ch);
                continue;
            }
            this.addTokChar(ch);
        }
        if (this.tokPos > 0) {
            this.tokens.addElement(this.getTokString());
        }
        this.enumvar = this.tokens.elements();
    }

    public String[] getTokens() {
        Object[] a = new String[this.tokens.size()];
        this.tokens.copyInto(a);
        return a;
    }

    public int countTokens() {
        return this.tokens.size();
    }

    public boolean hasMoreTokens() {
        return this.enumvar.hasMoreElements();
    }

    public String nextToken() throws NoSuchElementException {
        return (String)this.enumvar.nextElement();
    }

    public static void main(String[] args) {
        System.err.println("a0 = (" + args[0] + ")");
        if (args[0].equals("-e")) {
            StringParser sp = new StringParser(args[1], ',', '\'');
            System.out.print(args[1] + ":");
            while (sp.hasMoreTokens()) {
                System.out.print(" " + sp.nextToken());
            }
            System.out.println();
        } else if (args[0].equals("-r")) {
            StringParser sp = new StringParser(args[1], '-', '\'');
            System.out.print(args[1] + ":");
            while (sp.hasMoreTokens()) {
                System.out.print(" " + sp.nextToken());
            }
            System.out.println();
        } else if (args[0].equals("-t")) {
            long start = System.currentTimeMillis();
            for (int j = 0; j < 50; ++j) {
                System.gc();
                for (int i = 0; i < 1000; ++i) {
                    new StringParser("this is, really, a test dude", " ,", "'", false);
                }
            }
            System.err.println(">> time: " + (System.currentTimeMillis() - start));
        } else {
            StringParser sp = new StringParser(args[0], '.', '\'');
            System.out.print(args[0] + ":");
            while (sp.hasMoreTokens()) {
                System.out.print(" " + sp.nextToken());
            }
            System.out.println();
        }
    }
}

