/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class StringMatcher
implements Serializable {
    private String pattern;
    private String explicit = null;
    boolean isPattern = false;
    private int[] components;
    private String[] substrings;
    private boolean allowTokens = false;
    private boolean ignoreCase = false;
    private StringBuffer tokenString;
    private static final int MULTI_WILDCARD = 1;
    private static final int SINGLE_WILDCARD = 2;
    private static final int TOKEN = 3;
    private static final int DELIMTOKEN = 4;
    private static final int SUBSTRING = 5;
    private static final int WORD = 6;

    public StringMatcher(String pattern) {
        this.parsePattern(pattern);
    }

    public StringMatcher(String pattern, boolean allowTokens) {
        this.allowTokens = allowTokens;
        this.parsePattern(pattern);
    }

    public void setIgnoreCase(boolean newValue) {
        this.ignoreCase = newValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean match(String s) {
        int i;
        boolean wildcard = false;
        if (this.explicit != null) {
            return this.explicit.equals(s);
        }
        if (s == null) return false;
        if (this.components == null) {
            return false;
        }
        this.tokenString = new StringBuffer();
        int sLength = s.length();
        int curIndex = 0;
        block8: for (i = 0; curIndex <= sLength && i < this.components.length; ++i) {
            switch (this.components[i]) {
                case 5: {
                    if (wildcard) {
                        if ((curIndex = s.indexOf(this.substrings[i], curIndex)) == -1) break block8;
                        curIndex += this.substrings[i].length();
                        wildcard = false;
                        break;
                    }
                    if (curIndex + this.substrings[i].length() > sLength) break block8;
                    String subs = s.substring(curIndex, curIndex + this.substrings[i].length());
                    if (!this.ignoreCase && !this.substrings[i].equals(subs) || this.ignoreCase && !this.substrings[i].equalsIgnoreCase(subs)) break block8;
                    curIndex += this.substrings[i].length();
                    break;
                }
                case 1: {
                    wildcard = true;
                    break;
                }
                case 2: {
                    wildcard = false;
                    ++curIndex;
                    break;
                }
                case 6: {
                    boolean gotWord = false;
                    while (curIndex < sLength && Character.isSpaceChar(s.charAt(curIndex))) {
                        ++curIndex;
                    }
                    while (curIndex < sLength && !Character.isSpaceChar(s.charAt(curIndex))) {
                        if (!gotWord) {
                            gotWord = true;
                        }
                        ++curIndex;
                    }
                    if (gotWord) break;
                    break block8;
                }
                case 3: {
                    boolean gotToken = false;
                    while (curIndex < sLength && Character.isSpaceChar(s.charAt(curIndex))) {
                        ++curIndex;
                    }
                    while (curIndex < sLength && !Character.isSpaceChar(s.charAt(curIndex))) {
                        if (!gotToken) {
                            gotToken = true;
                            if (this.tokenString.length() != 0) {
                                this.tokenString.append(' ');
                            }
                        }
                        this.tokenString.append(s.charAt(curIndex));
                        ++curIndex;
                    }
                    if (gotToken) break;
                    break block8;
                }
                case 4: {
                    boolean gotToken = false;
                    while (curIndex < sLength && Character.isSpaceChar(s.charAt(curIndex))) {
                        ++curIndex;
                    }
                    while (!(curIndex >= sLength || i != this.components.length - 1 && this.substrings[i + 1] != null && s.regionMatches(curIndex, this.substrings[i + 1], 0, this.substrings[i + 1].length()))) {
                        if (!gotToken) {
                            gotToken = true;
                            if (this.tokenString.length() != 0) {
                                this.tokenString.append(' ');
                            }
                        }
                        this.tokenString.append(s.charAt(curIndex));
                        ++curIndex;
                    }
                    if (!gotToken) break block8;
                }
            }
        }
        if (this.allowTokens && !wildcard && curIndex < sLength) {
            if (this.tokenString.length() != 0 && !s.regionMatches(curIndex, " ", 0, 1)) {
                this.tokenString.append(' ');
            }
            this.tokenString.append(s.substring(curIndex));
        }
        if (i != this.components.length) return false;
        if (wildcard) return true;
        if (curIndex == sLength) return true;
        if (!this.allowTokens) return false;
        if (curIndex >= sLength) return false;
        return true;
    }

    public String getTokens(String s) {
        if (!this.allowTokens || s == null || !this.match(s)) {
            return null;
        }
        if (this.tokenString != null) {
            return this.tokenString.toString();
        }
        return this.explicit;
    }

    private void parsePattern(String pattern) {
        int i;
        if (pattern == null) {
            return;
        }
        Vector<Object> v = new Vector<Object>();
        StringBuffer tmp = new StringBuffer();
        int len = pattern.length();
        block8: for (i = 0; i < len; ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '\\': {
                    if (++i == len) continue block8;
                    tmp.append(pattern.charAt(i));
                    continue block8;
                }
                case '$': {
                    if (!this.allowTokens) {
                        tmp.append(pattern.charAt(i));
                    } else {
                        if (tmp.length() > 0) {
                            v.addElement(tmp.toString());
                        }
                        v.addElement(new Integer(3));
                        tmp = new StringBuffer(len);
                    }
                    this.isPattern = true;
                    continue block8;
                }
                case '&': {
                    if (!this.allowTokens) {
                        tmp.append(pattern.charAt(i));
                    } else {
                        if (tmp.length() > 0) {
                            v.addElement(tmp.toString());
                        }
                        v.addElement(new Integer(4));
                        tmp = new StringBuffer(len);
                    }
                    this.isPattern = true;
                    continue block8;
                }
                case '*': {
                    if (tmp.length() > 0) {
                        v.addElement(tmp.toString());
                    }
                    v.addElement(new Integer(1));
                    tmp = new StringBuffer(len);
                    this.isPattern = true;
                    continue block8;
                }
                case '%': {
                    if (tmp.length() > 0) {
                        v.addElement(tmp.toString());
                    }
                    v.addElement(new Integer(6));
                    tmp = new StringBuffer(len);
                    this.isPattern = true;
                    continue block8;
                }
                case '?': {
                    if (tmp.length() > 0) {
                        v.addElement(tmp.toString());
                    }
                    v.addElement(new Integer(2));
                    tmp = new StringBuffer(len);
                    this.isPattern = true;
                    continue block8;
                }
                default: {
                    tmp.append(pattern.charAt(i));
                    if (i != len - 1) continue block8;
                    v.addElement(tmp.toString());
                }
            }
        }
        if (v.size() == 1 && !this.isPattern) {
            this.explicit = v.elementAt(0).toString();
        } else {
            Enumeration enumvar = v.elements();
            this.components = new int[v.size()];
            this.substrings = new String[v.size()];
            i = 0;
            while (enumvar.hasMoreElements()) {
                Object o = enumvar.nextElement();
                if (o instanceof String) {
                    this.components[i] = 5;
                    this.substrings[i] = (String)o;
                    ++i;
                    continue;
                }
                this.components[i] = (Integer)o;
                this.substrings[i] = null;
                ++i;
            }
        }
    }
}

