/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.data.IData;
import com.wm.data.IDataCursor;

public class StringComposer {
    public static final String toString(IData data) {
        StringBuffer sb = new StringBuffer();
        StringComposer.appendReport(sb, 0, data);
        return sb.toString();
    }

    private static final void appendReport(StringBuffer sb, int indent, IData data) {
        IDataCursor cursor = data.getCursor();
        while (cursor.next()) {
            String key = cursor.getKey();
            Object value = cursor.getValue();
            if (value == null) {
                StringComposer.appendKey(sb, indent, key + " = null\n");
                continue;
            }
            if (value instanceof Object[]) {
                int i;
                if (value instanceof IData[]) {
                    IData[] dataArray = (IData[])value;
                    for (i = 0; i < dataArray.length; ++i) {
                        StringComposer.appendKey(sb, indent, key + '[' + i + ']' + '\n');
                        StringComposer.appendReport(sb, indent + 2, dataArray[i]);
                    }
                    continue;
                }
                if (value instanceof String[]) {
                    String[] stringArray = (String[])value;
                    StringComposer.appendKey(sb, indent, key + " = {");
                    for (i = 0; i < stringArray.length; ++i) {
                        sb.append(stringArray[i]);
                        if (i + 1 >= stringArray.length) continue;
                        sb.append(", ");
                    }
                    sb.append("}\n");
                    continue;
                }
                Object[] objectArray = (Object[])value;
                StringComposer.appendKey(sb, indent, key + " = *object[], size=" + objectArray.length + '\n');
                continue;
            }
            if (value instanceof IData) {
                StringComposer.appendKey(sb, indent, key + " = \n");
                StringComposer.appendReport(sb, indent + 2, (IData)value);
                continue;
            }
            if (value instanceof String) {
                String string = (String)value;
                StringComposer.appendKey(sb, indent, key + " = " + string + "\n");
                continue;
            }
            StringComposer.appendKey(sb, indent, key + " = " + value.toString() + " (" + value.getClass() + ")\n");
        }
    }

    private static final void appendKey(StringBuffer sb, int indent, String key) {
        char[] charArray = new char[indent];
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = 32;
        }
        sb.append(charArray);
        sb.append(key);
    }
}

