/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

public class StringColor {
    private static boolean useColor = System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0;
    public static int CYAN = 36;
    public static int PURPLE = 35;
    public static int BLUE = 34;
    public static int YELLOW = 33;
    public static int GREEN = 32;
    public static int RED = 31;
    public static int BLACK = 30;
    public static int WHITE = 29;
    public static int BRIGHT = 1;
    public static int NORMAL = 0;

    public static boolean supportsColor() {
        return useColor;
    }

    public static String ize(Object s, int mode, int color) {
        return StringColor.ize(s, mode, color, false);
    }

    public static String ize(Object s, int mode, int color, boolean nested) {
        if (!useColor) {
            return s.toString();
        }
        if (nested) {
            return "\u001b[" + mode + ";" + color + "m" + s;
        }
        return "\u001b[" + mode + ";" + color + "m" + s + "\u001b[0m";
    }

    public static String cyan(Object s) {
        return StringColor.ize(s, NORMAL, CYAN);
    }

    public static String purple(Object s) {
        return StringColor.ize(s, NORMAL, PURPLE);
    }

    public static String blue(Object s) {
        return StringColor.ize(s, NORMAL, BLUE);
    }

    public static String yellow(Object s) {
        return StringColor.ize(s, NORMAL, YELLOW);
    }

    public static String green(Object s) {
        return StringColor.ize(s, NORMAL, GREEN);
    }

    public static String red(Object s) {
        return StringColor.ize(s, NORMAL, RED);
    }

    public static String black(Object s) {
        return StringColor.ize(s, NORMAL, BLACK);
    }

    public static String white(Object s) {
        return StringColor.ize(s, NORMAL, WHITE);
    }

    public static String CYAN(Object s) {
        return StringColor.ize(s, BRIGHT, CYAN);
    }

    public static String PURPLE(Object s) {
        return StringColor.ize(s, BRIGHT, PURPLE);
    }

    public static String BLUE(Object s) {
        return StringColor.ize(s, BRIGHT, BLUE);
    }

    public static String YELLOW(Object s) {
        return StringColor.ize(s, BRIGHT, YELLOW);
    }

    public static String GREEN(Object s) {
        return StringColor.ize(s, BRIGHT, GREEN);
    }

    public static String RED(Object s) {
        return StringColor.ize(s, BRIGHT, RED);
    }

    public static String BLACK(Object s) {
        return StringColor.ize(s, BRIGHT, BLACK);
    }

    public static String WHITE(Object s) {
        return StringColor.ize(s, BRIGHT, WHITE);
    }
}

