/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.ByteOutputBuffer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

public class Streams {
    public static byte[] readFully(InputStream is) throws IOException {
        BufferedInputStream bi = new BufferedInputStream(is);
        ByteOutputBuffer os = new ByteOutputBuffer();
        int len = 0;
        int prevlen = 0;
        byte[] tempIn = new byte[2048];
        while (len != -1) {
            try {
                prevlen = len;
                len = bi.read(tempIn);
            }
            catch (EOFException e) {
                len = -1;
            }
            catch (SocketException se) {
                if (prevlen <= 0) {
                    throw se;
                }
                len = -1;
            }
            if (len <= 0) continue;
            os.write(tempIn, 0, len);
        }
        return os.toByteArray();
    }

    public static byte[] readBytes(InputStream is, long size) throws IOException {
        int bread;
        ByteOutputBuffer os = new ByteOutputBuffer();
        byte[] b = new byte[1024];
        for (int total = (int)size; total > 0; total -= bread) {
            try {
                bread = is.read(b);
            }
            catch (EOFException e) {
                bread = -1;
            }
            if (bread == -1) {
                return os.toByteArray();
            }
            if (bread <= 0) continue;
            os.write(b, 0, bread);
        }
        return os.toByteArray();
    }

    public static void pipe(InputStream is, OutputStream os) throws IOException {
        Streams.pipe(is, os, 2048, 0, true);
    }

    public static void pipe(InputStream is, OutputStream os, int bsize, int max, boolean flush) throws IOException {
        int tot = 0;
        int len = 0;
        byte[] tempIn = new byte[2048];
        while (len != -1) {
            try {
                len = is.read(tempIn);
            }
            catch (EOFException e) {
                len = -1;
            }
            if (len <= 0) continue;
            tot += len;
            os.write(tempIn, 0, len);
            if (flush) {
                os.flush();
            }
            if (max <= 0 || tot <= max) continue;
            break;
        }
    }

    public static String readLine(InputStream input) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(100);
        boolean curPos = false;
        int ch;
        while ((ch = input.read()) != -1) {
            if (ch == 13) {
                ch = input.read();
                if (ch == 10) {
                    return new String(buffer.toByteArray());
                }
                buffer.write(13);
                buffer.write(ch);
                continue;
            }
            if (ch == 10) {
                return new String(buffer.toByteArray());
            }
            buffer.write(ch);
        }
        return !curPos ? null : new String(buffer.toByteArray());
    }
}

