/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class SortedPropertiesWriter {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private Properties props = null;
    private TreeMap tmap = null;

    public SortedPropertiesWriter(Properties p) {
        this.props = p;
    }

    private void sortProperties() {
        this.tmap = new TreeMap();
        Enumeration<Object> en = this.props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = (String)this.props.get(key);
            this.tmap.put(key, val);
        }
    }

    public synchronized void store(OutputStream out, String header2) throws IOException {
        this.sortProperties();
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header2 != null) {
            SortedPropertiesWriter.writeln(awriter, "#" + header2);
        }
        SortedPropertiesWriter.writeln(awriter, "#" + new Date().toString());
        for (Map.Entry entry : this.tmap.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            key = this.saveConvert(key, true);
            val = this.saveConvert(val, false);
            SortedPropertiesWriter.writeln(awriter, key + "=" + val);
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(SortedPropertiesWriter.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(SortedPropertiesWriter.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(SortedPropertiesWriter.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(SortedPropertiesWriter.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static void main(String[] args) throws Exception {
        Properties prp = new Properties();
        prp.put("key2", "value 2");
        prp.put("key1", "value 1");
        prp.put("key3", "value 3");
        FileOutputStream os = new FileOutputStream("unsortedProps.txt");
        prp.store(os, "standard properties");
        os = new FileOutputStream("sortedProps.txt");
        SortedPropertiesWriter spw = new SortedPropertiesWriter(prp);
        spw.store(os, "sorted properties");
    }
}

