/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;

public class SimpleDateFormatPool {
    public static int DEFAULT_INIT_CAPACITY = 10;
    private int _capacity;
    private List _stack = new LinkedList();
    private String _pattern;

    public SimpleDateFormatPool(String pattern) {
        this(pattern, DEFAULT_INIT_CAPACITY);
    }

    public SimpleDateFormatPool(String pattern, int capacity) {
        this._pattern = pattern;
        this._capacity = capacity;
        for (int i = 0; i < this._capacity; ++i) {
            this._stack.add(this.createInstance());
        }
    }

    public synchronized SimpleDateFormat getInstance() {
        if (this._stack.size() > 0) {
            return (SimpleDateFormat)this._stack.remove(0);
        }
        return this.createInstance();
    }

    public synchronized void returnInstance(SimpleDateFormat in) {
        this._stack.add(in);
    }

    private SimpleDateFormat createInstance() {
        return new SimpleDateFormat(this._pattern);
    }
}

