/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.List;
import java.util.Enumeration;

public class ScrollableEnumeration
implements Enumeration {
    List alreadyRead = new List();
    Enumeration remaining;
    int current;

    public ScrollableEnumeration(Enumeration e) {
        this.remaining = e;
        this.current = -1;
    }

    public Object firstElement() {
        this.current = -1;
        return this.nextElement();
    }

    public Object lastElement() {
        this.current = this.size() - 2;
        return this.nextElement();
    }

    public Object elementAt(int idx) {
        int i = this.fillTo(idx);
        if (this.alreadyRead.size() <= idx) {
            return null;
        }
        this.current = idx;
        return this.alreadyRead.elementAt(idx);
    }

    public Object nextElement() {
        int next_current = this.current + 1;
        int i = this.fillTo(next_current);
        if (i > next_current) {
            this.current = next_current;
            return this.alreadyRead.elementAt(next_current);
        }
        return null;
    }

    public Object previousElement() {
        return this.current < 0 ? null : this.alreadyRead.elementAt(this.current--);
    }

    public boolean hasMoreElements() {
        return this.current < this.alreadyRead.size() - 1 ? true : this.remaining.hasMoreElements();
    }

    public int size() {
        while (this.remaining.hasMoreElements()) {
            this.alreadyRead.addElement(this.remaining.nextElement());
        }
        return this.alreadyRead.size();
    }

    private int fillTo(int idx) {
        int i;
        for (i = this.alreadyRead.size(); i <= idx && this.remaining.hasMoreElements(); ++i) {
            Object o = this.remaining.nextElement();
            this.alreadyRead.addElement(o);
        }
        return i;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("current: ").append(this.current).append("\n");
        s.append("alreadyRead: ").append(this.alreadyRead).append("\n");
        s.append("Remaining: ").append(this.remaining).append("\n");
        return s.toString();
    }

    public static void main(String[] args) {
        int i;
        List l = new List();
        for (int i2 = 0; i2 < 100; ++i2) {
            l.addElement(Integer.toString(i2));
        }
        ScrollableEnumeration s = new ScrollableEnumeration(l.elements());
        System.err.println("first = " + s.firstElement());
        for (i = 0; i < 10; ++i) {
            System.err.println("next = " + s.nextElement());
        }
        System.err.println();
        System.err.println("last = " + s.lastElement());
        for (i = 0; i < 10; ++i) {
            System.err.println("previous = " + s.previousElement());
        }
    }
}

