/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.app.repov4.IRepoDirectory;
import com.wm.app.repov4.IRepoServer;
import com.wm.app.repov4.IRepository;
import com.wm.app.repov4.ISecurityCredentials;
import com.wm.app.repov4.RepoClient;
import com.wm.app.repov4.RepositoryException;
import com.wm.data.IData;
import com.wm.driver.data.fs.FSData;
import com.wm.driver.data.fs.FSException;
import com.wm.passman.PasswordManager;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public abstract class RepositoryManager {
    public static final String ROOT_CTX = "SYSTEM/SERVER/";
    private static RepositoryManager _repoMgr = null;
    private RepoClient _clientFactory = null;
    private IRepoServer _localServer = null;
    private FSData _FSLocalEngine = null;

    public RepositoryManager() {
        _repoMgr = this;
    }

    public static RepositoryManager getCurrent() {
        return _repoMgr;
    }

    public IRepository getRepository() throws RepositoryException {
        return this._clientFactory.create();
    }

    public IRepository getDefaultRepoLogon() throws RepositoryException {
        IRepository repo = this._clientFactory.create();
        IRepoDirectory dir = repo.logon(null, new ISecurityCredentials(){});
        dir.destroy();
        repo.commit();
        return repo;
    }

    public IRepository getLocalRepoLogon() throws RepositoryException {
        IRepository repo = this._clientFactory.create();
        IRepoDirectory dir = repo.logon("local", new ISecurityCredentials(){});
        dir.destroy();
        repo.commit();
        return repo;
    }

    public void shutdown() throws IOException, FSException {
        if (this._FSLocalEngine != null) {
            this._FSLocalEngine.close();
            this._FSLocalEngine = null;
        }
    }

    protected IData initLocalIData(Properties prop, PasswordManager pswdMgr) throws RepositoryException {
        this.setLocalEngine(this.initIData(prop));
        this.getLocalEngine().setPasswordManager(pswdMgr);
        return this.getLocalEngine().getData();
    }

    protected FSData initIData(Properties prop) throws RepositoryException {
        FSData fsdata = null;
        int debuglevel = new Integer(prop.getProperty("debuglevel", "0").trim());
        Throwable openException = null;
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        boolean exists = true;
        try {
            try {
                exists = FSData.checkDataDevices((Properties)prop);
            }
            catch (FSException ex) {
                // empty catch block
            }
            if (!exists) {
                try {
                    fsdata = FSData.create((Properties)prop);
                }
                catch (IOException ex) {
                    this.deleteFSData(prop);
                    throw ex;
                }
                catch (FSException ex) {
                    this.deleteFSData(prop);
                    throw ex;
                }
            }
            try {
                fsdata = FSData.open((Properties)prop);
            }
            catch (FSException ex) {
                openException = ex;
            }
            catch (IOException ex) {
                openException = ex;
            }
            if (openException != null) {
                this.openExceptionMsg((Exception)openException);
                String renamed = "damaged" + sdf.format(now);
                try {
                    FSData.rename((Properties)prop, (String)renamed);
                    this.renameMsg(renamed);
                }
                catch (FSException ex2) {
                    this.renameExceptionMsg((Exception)((Object)ex2));
                    throw ex2;
                }
                try {
                    fsdata = FSData.create((Properties)prop);
                }
                catch (IOException ex2) {
                    this.recreateFail(prop, ex2);
                    throw ex2;
                }
                catch (FSException ex2) {
                    this.recreateFail(prop, (Exception)((Object)ex2));
                    throw ex2;
                }
            }
            if (debuglevel > 9) {
                fsdata.setLogLevel(6);
            }
        }
        catch (IOException e) {
            throw new RepositoryException(new String(e.getClass().getName() + ":" + e.getMessage()));
        }
        catch (FSException e) {
            throw new RepositoryException(new String(((Object)((Object)e)).getClass().getName() + ":" + e.getMessage()));
        }
        catch (Exception e) {
            throw new RepositoryException(new String(e.getClass().getName() + ":" + e.getMessage()));
        }
        return fsdata;
    }

    protected void deleteFSData(Properties prop) {
        try {
            FSData.delete((Properties)prop);
        }
        catch (FSException fSException) {
            // empty catch block
        }
    }

    protected abstract void recreateFail(Properties var1, Exception var2);

    protected abstract void openExceptionMsg(Exception var1);

    protected abstract void renameMsg(String var1);

    protected abstract void renameExceptionMsg(Exception var1);

    public RepoClient getFactory() throws RepositoryException {
        return this.getClientFactory();
    }

    protected RepoClient getClientFactory() {
        return this._clientFactory;
    }

    protected void setClientFactory(RepoClient factory) {
        this._clientFactory = factory;
    }

    protected FSData getLocalEngine() {
        return this._FSLocalEngine;
    }

    protected void setLocalEngine(FSData localEngine) {
        this._FSLocalEngine = localEngine;
    }

    protected IRepoServer getLocalServer() {
        return this._localServer;
    }

    protected void setLocalServer(IRepoServer server) {
        this._localServer = server;
    }
}

