/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.LocalizedException;
import com.wm.util.NCName;
import com.wm.util.QName;
import com.wm.util.resources.UtilExceptionBundle;

public class QNameComposer {
    static final char COLON = ':';

    public static final QName compose(String tag, String namespaceName, boolean useSoapRPCStyle) throws LocalizedException {
        if (useSoapRPCStyle) {
            String localName = tag;
            int indexOfColon = tag.indexOf(58);
            if (indexOfColon > -1) {
                localName = indexOfColon + 1 < tag.length() ? tag.substring(indexOfColon + 1) : "";
            }
            return QName.create(namespaceName, NCName.validate(localName) ? localName : NCName.encode(localName));
        }
        String localName = tag;
        int indexOfColon = tag.indexOf(58);
        String prefix = null;
        if (indexOfColon > -1) {
            prefix = tag.substring(0, indexOfColon);
            localName = indexOfColon + 1 < tag.length() ? tag.substring(indexOfColon + 1) : "";
        }
        if (namespaceName == null && prefix != null) {
            throw new LocalizedException(UtilExceptionBundle.class, UtilExceptionBundle.PREFIX_WO_NAMESPACE, null, tag);
        }
        if (!NCName.validate(localName)) {
            throw new LocalizedException(UtilExceptionBundle.class, UtilExceptionBundle.INVALID_NC_NAME, null, tag);
        }
        return QName.create(namespaceName, localName);
    }

    private static void test(String tag, String namespaceName, boolean useSoapRPCStyle) {
        try {
            QName q = QNameComposer.compose(tag, namespaceName, useSoapRPCStyle);
            System.out.println("tag=" + tag + "; namespaceName=" + namespaceName + "; useSoapRPCStyle=" + useSoapRPCStyle + "; QName=" + q.toDisplayString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        QNameComposer.test("oag:po", "http://www.oag.org/", true);
        QNameComposer.test("oag:po", "http://www.oag.org/", false);
        QNameComposer.test("oag:", "http://www.oag.org/", true);
        QNameComposer.test("oag:", "http://www.oag.org/", false);
        QNameComposer.test("oag:po", null, true);
        QNameComposer.test("oag:po", null, false);
        QNameComposer.test("oag:59", "http://www.oag.org/", true);
        QNameComposer.test("oag:59", "http://www.oag.org/", false);
        QNameComposer.test("oag:5<", "http://www.oag.org/", true);
        QNameComposer.test("oag:5<", "http://www.oag.org/", false);
    }
}

