/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedException;
import com.wm.util.NCName;
import com.wm.util.Name;
import com.wm.util.QNameComparable;
import com.wm.util.Showable;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.resources.UtilExceptionBundle;
import com.wm.util.sort.Sortable;
import java.text.Collator;
import java.util.concurrent.ConcurrentHashMap;

public class QName
implements IDataPortable,
ValuesCodable,
Showable,
Sortable {
    private static final ConcurrentHashMap<String, QName> names = new ConcurrentHashMap(10000, 0.75f, 1);
    public static final QName END = QName.create(null, "$");
    public static final Name NO_NAMESPACE = Name.create("http://www.webMethods.com/noNamespace/");
    Name _xmlns;
    Name _ncName;
    int _hash;
    String _id;
    public static final String KEY_QNAME_XMLNS = "xmlns";
    public static final String KEY_QNAME_NCNAME = "ncName";
    private static final String KEY_NAMESPACE_URI = "namespace name";
    private static final String KEY_LOCAL_NAME = "local name";

    private QName(String xmlns, String ncName, String id, int hash) {
        this._xmlns = Name.create(xmlns);
        this._ncName = Name.create(ncName);
        this._id = id;
        this._hash = hash;
    }

    protected QName() {
    }

    public String getNamespace() {
        return this._xmlns != null ? this._xmlns.toString() : null;
    }

    public String getNCName() {
        return this._ncName != null ? this._ncName.toString() : null;
    }

    public Name getNamespaceName() {
        return this._xmlns;
    }

    public Name getLocalName() {
        return this._ncName;
    }

    public void setValues(Values values) {
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_QNAME_XMLNS, this._xmlns != null && this._xmlns.toString().length() != 0 ? this._xmlns.toString() : null}, {KEY_QNAME_NCNAME, this._ncName != null && this._ncName.toString().length() != 0 ? this._ncName.toString() : null}};
        return new Values(o);
    }

    public void setFromData(IData values) {
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_QNAME_XMLNS, this._xmlns != null ? this._xmlns.toString() : null}, {KEY_QNAME_NCNAME, this._ncName != null ? this._ncName.toString() : null}};
        return IDataFactory.create(o);
    }

    public static final QName create(IData values) {
        if (values == null) {
            return null;
        }
        IDataCursor ic = values.getCursor();
        QName tmp = QName._create(IDataUtil.getString(ic, KEY_QNAME_XMLNS), IDataUtil.getString(ic, KEY_QNAME_NCNAME));
        ic.destroy();
        return tmp;
    }

    public static final QName create(Values values) {
        if (values == null) {
            return null;
        }
        IDataCursor ic = values.getCursor();
        QName tmp = QName._create(IDataUtil.getString(ic, KEY_QNAME_XMLNS), IDataUtil.getString(ic, KEY_QNAME_NCNAME));
        ic.destroy();
        return tmp;
    }

    public static final QName create(String xmlns, String ncName) {
        return QName._create(xmlns, ncName);
    }

    public static final QName create(Name xmlns, Name ncName) {
        return QName._create(xmlns != null && xmlns.toString().length() != 0 ? xmlns.toString() : null, ncName != null && ncName.toString().length() != 0 ? ncName.toString() : null);
    }

    private static final QName _create(String xmlns, String ncName) {
        int hash;
        QName alreadyCached;
        String id = ncName + '#' + xmlns;
        QName qn = names.get(id);
        if (qn == null && (alreadyCached = names.putIfAbsent(id, qn = new QName(xmlns, ncName, id, hash = id.hashCode()))) != null) {
            qn = alreadyCached;
        }
        return qn;
    }

    public String toString() {
        return this._id;
    }

    public boolean equals(Object lhs) {
        if (this == lhs) {
            return true;
        }
        if (lhs != null && lhs instanceof QNameComparable) {
            return lhs.equals(this);
        }
        return false;
    }

    public int hashCode() {
        return this._hash;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{KEY_NAMESPACE_URI, this._xmlns.toString()}, {KEY_LOCAL_NAME, this._ncName.toString()}};
        return new Values(o);
    }

    public static final QName computeQName(String ref, ElementNodeBase node) throws WMDocumentException, RuntimeException {
        if (ref == null) {
            return null;
        }
        int colon = ref.indexOf(58);
        String prefix = null;
        String ncName = null;
        Name namespaceURI = null;
        if (colon > -1) {
            prefix = ref.substring(0, colon);
        }
        ncName = ref.substring(colon + 1, ref.length());
        if (prefix != null) {
            Name composedPrefix = Name.create(prefix);
            NamespaceDecl ns = node.lookUpInScopeNSDeclByPrefix(composedPrefix);
            if (ns != null) {
                namespaceURI = ns.getUri();
            }
            if (namespaceURI == null) {
                throw new RuntimeException();
            }
        } else {
            NamespaceDecl ns = node.lookUpInScopeNSDeclByPrefix(null);
            if (ns != null) {
                namespaceURI = ns.getUri();
            }
        }
        if (namespaceURI == NO_NAMESPACE) {
            namespaceURI = null;
        }
        return QName.create(namespaceURI, Name.create(ncName));
    }

    public int compare(Sortable cmp, boolean reverse, int sort_by) {
        int result = 0;
        if (cmp instanceof QName) {
            QName anotherQName = (QName)cmp;
            Collator coll = Collator.getInstance();
            String origNamespace = this.getNamespace();
            String anotherNamespace = anotherQName.getNamespace();
            result = origNamespace == null && anotherNamespace == null ? 0 : (origNamespace != null && anotherNamespace == null ? 1 : (origNamespace == null && anotherNamespace != null ? -1 : coll.compare(origNamespace, anotherNamespace)));
            if (result == 0) {
                result = coll.compare(this.getNCName(), anotherQName.getNCName());
            }
            if (reverse) {
                result = 0 - result;
            }
        }
        return result;
    }

    public int size() {
        if (this._xmlns == null && this._ncName == null) {
            return 0;
        }
        if (this._xmlns != null && this._ncName == null) {
            return this._xmlns.toString().length();
        }
        if (this._xmlns == null && this._ncName != null) {
            return this._ncName.toString().length();
        }
        if (this._xmlns != null && this._ncName != null) {
            return this._xmlns.toString().length() + this._ncName.toString().length();
        }
        return -1;
    }

    public static void main(String[] args) {
        QName q1 = QName.create("http://www.webmethods.com/", "po");
        QName q2 = QName.create("http://www.b2b.com/", "po");
        QName q3 = QName.create("http://www.webmethods.com/", "po");
        QName q4 = QName.create("http://www.b2b.com/", "invoice");
        System.out.println("q1 == q2 : " + q1.equals(q2));
        System.out.println("q2 == q3 : " + q2.equals(q3));
        System.out.println("q1 == q3 : " + q1.equals(q3));
        try {
            System.out.println(QName.validate("a", "b"));
            try {
                System.out.println(QName.validate("", ""));
            }
            catch (LocalizedException e) {
                System.out.println(e.getMessage());
            }
            try {
                System.out.println(QName.validate(null, ""));
            }
            catch (LocalizedException e) {
                System.out.println(e.getMessage());
            }
            try {
                System.out.println(QName.validate(null, null));
            }
            catch (LocalizedException e) {
                System.out.println(e.getMessage());
            }
            System.out.println(QName.validate(null, "b"));
            try {
                System.out.println(QName.validate("", "po"));
            }
            catch (LocalizedException e) {
                System.out.println(e.getMessage());
            }
            try {
                System.out.println(QName.validate("URIa", "5amount"));
            }
            catch (LocalizedException e) {
                System.out.println(e.getMessage());
            }
        }
        catch (LocalizedException e) {
            e.printStackTrace();
        }
        System.out.println(q1.toDisplayString());
        System.out.println(q2.toDisplayString());
        System.out.println(q3.toDisplayString());
        System.out.println(q4.toDisplayString());
        System.out.println(QName.create(null, "po").toDisplayString());
    }

    public static boolean validate(String namespaceName, String localName) throws LocalizedException {
        if (localName == null) {
            throw new LocalizedException(UtilExceptionBundle.class, UtilExceptionBundle.INVALID_LOCALNAME0, "");
        }
        if (localName.length() == 0) {
            throw new LocalizedException(UtilExceptionBundle.class, UtilExceptionBundle.INVALID_LOCALNAME1, "");
        }
        if (namespaceName != null && namespaceName.length() == 0) {
            throw new LocalizedException(UtilExceptionBundle.class, UtilExceptionBundle.EMPTY_NAMESPACE_NAME, "");
        }
        boolean valid = NCName.validate(localName);
        if (!valid) {
            throw new LocalizedException(UtilExceptionBundle.class, UtilExceptionBundle.INVALID_LOCALNAME2, "", localName);
        }
        return valid;
    }

    public String toDisplayString() {
        if (this._xmlns == null) {
            return this._ncName.toString();
        }
        return Strings.cat(this._ncName.toString() + " ", "{", this._xmlns.toString(), "}");
    }
}

