/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.passman.PasswordManager;
import com.wm.passman.PasswordManagerException;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import com.wm.util.Password;
import com.wm.util.Values;
import com.wm.util.security.WmSecureString;
import java.util.StringTokenizer;

public class ProxySettings {
    private static String _httpHost;
    private static String _httpPort;
    private static String _httpUser;
    private static WmSecureString _httpPass;
    private static String _secureHttpHost;
    private static String _secureHttpPort;
    private static String _secureHttpUser;
    private static WmSecureString _secureHttpPass;
    private static String _ftpHost;
    private static String _ftpPort;
    private static String _ftpUser;
    private static WmSecureString _ftpPass;
    private static String _ftpType;
    private static String _jvmProxySkipList;
    private static final String PROXY_SKIP_LIST = "watt.net.proxySkipList";
    private static final String NET_PROP_PREFIX = "watt.net.";
    private static final String JVM_HTTP_PROP_PREFIX = "http.";
    private static final String JVM_HTTPS_PROP_PREFIX = "https.";
    private static final String HTTP_HOST_PROP_SUFFIX = "proxyHost";
    private static final String HTTP_PORT_PROP_SUFFIX = "proxyPort";
    private static final String HTTP_USER_PROP_SUFFIX = "proxyUser";
    private static final String HTTP_PASS_PROP_SUFFIX = "proxyPass";
    private static final String HTTP_PROXY_SKIP_SUFFIX = "nonProxyHosts";
    private static final String SECURE_HOST_PROP_SUFFIX = "secureProxyHost";
    private static final String SECURE_PORT_PROP_SUFFIX = "secureProxyPort";
    private static final String SECURE_USER_PROP_SUFFIX = "secureProxyUser";
    private static final String SECURE_PASS_PROP_SUFFIX = "secureProxyPass";
    private static final String FTP_HOST_PROP_SUFFIX = "ftpProxyHost";
    private static final String FTP_PORT_PROP_SUFFIX = "ftpProxyPort";
    private static final String FTP_USER_PROP_SUFFIX = "ftpProxyUser";
    private static final String FTP_PASS_PROP_SUFFIX = "ftpProxyPass";
    private static final String FTP_TYPE_PROP_SUFFIX = "ftpProxyType";
    public static final String HTTP_HOST_PROP_KEY = "watt.net.proxyHost";
    public static final String HTTP_PORT_PROP_KEY = "watt.net.proxyPort";
    public static final String HTTP_USER_PROP_KEY = "watt.net.proxyUser";
    public static final String HTTP_PASS_PROP_KEY = "watt.net.proxyPass";
    public static final String SECURE_HOST_PROP_KEY = "watt.net.secureProxyHost";
    public static final String SECURE_PORT_PROP_KEY = "watt.net.secureProxyPort";
    public static final String SECURE_USER_PROP_KEY = "watt.net.secureProxyUser";
    public static final String SECURE_PASS_PROP_KEY = "watt.net.secureProxyPass";
    public static final String JVM_HTTP_HOST_PROP_KEY = "http.proxyHost";
    public static final String JVM_HTTP_PORT_PROP_KEY = "http.proxyPort";
    public static final String JVM_HTTP_SKIP_PROP_KEY = "http.nonProxyHosts";
    public static final String JVM_SECURE_HOST_PROP_KEY = "https.proxyHost";
    public static final String JVM_SECURE_PORT_PROP_KEY = "https.proxyPort";
    public static final String FTP_HOST_PROP_KEY = "watt.net.ftpProxyHost";
    public static final String FTP_PORT_PROP_KEY = "watt.net.ftpProxyPort";
    public static final String FTP_USER_PROP_KEY = "watt.net.ftpProxyUser";
    public static final String FTP_PASS_PROP_KEY = "watt.net.ftpProxyPass";
    public static final String FTP_TYPE_PROP_KEY = "watt.net.ftpProxyType";
    private static final String PASS_HANDLE_PREFIX = "wm.is.admin.proxy.";
    private static final String HTTP_HANDLE_SUFFIX = "http";
    private static final String SECURE_HANDLE_SUFFIX = "secureHttp";
    private static final String FTP_HANDLE_SUFFIX = "ftp";
    private static final String HTTP_PASS_HANDLE = "wm.is.admin.proxy.http";
    private static final String SECURE_PASS_HANDLE = "wm.is.admin.proxy.secureHttp";
    private static final String FTP_PASS_HANDLE = "wm.is.admin.proxy.ftp";
    private static PasswordManager gPassMan;
    private static final String PIPELINE_PASSWORD_MASK = "********";

    public static void setPasswordManager(PasswordManager inMgr) {
        gPassMan = inMgr;
        try {
            ProxySettings.refreshPasswords();
        }
        catch (PasswordManagerException pme) {
            ProxySettings.logExceptionMessage("ProxySettings.setPasswordManager()", pme);
        }
    }

    public static void load() {
        _httpHost = Config.getProperty(HTTP_HOST_PROP_KEY);
        _httpPort = Config.getProperty(HTTP_PORT_PROP_KEY);
        _httpUser = Config.getProperty(HTTP_USER_PROP_KEY);
        String rawPass = ProxySettings.oldDecode(Config.getProperty(HTTP_PASS_PROP_KEY));
        _httpPass = rawPass == null ? null : new WmSecureString(rawPass);
        Config.setProperty(HTTP_PASS_PROP_KEY, _httpPass);
        _secureHttpHost = Config.getProperty(SECURE_HOST_PROP_KEY);
        _secureHttpPort = Config.getProperty(SECURE_PORT_PROP_KEY);
        _secureHttpUser = Config.getProperty(SECURE_USER_PROP_KEY);
        rawPass = ProxySettings.oldDecode(Config.getProperty(SECURE_PASS_PROP_KEY));
        _secureHttpPass = rawPass == null ? null : new WmSecureString(rawPass);
        Config.setProperty(SECURE_PASS_PROP_KEY, _secureHttpPass);
        _ftpHost = Config.getProperty(FTP_HOST_PROP_KEY);
        _ftpPort = Config.getProperty(FTP_PORT_PROP_KEY);
        _ftpUser = Config.getProperty(FTP_USER_PROP_KEY);
        _ftpType = Config.getProperty(FTP_TYPE_PROP_KEY);
        _jvmProxySkipList = ProxySettings.formatJVMProxySkipList(Config.getProperty(PROXY_SKIP_LIST));
        rawPass = ProxySettings.oldDecode(Config.getProperty(FTP_PASS_PROP_KEY));
        _ftpPass = rawPass == null ? null : new WmSecureString(rawPass);
        Config.setProperty(FTP_PASS_PROP_KEY, _ftpPass);
    }

    public static void save() {
        if (gPassMan != null) {
            if (_httpHost == null || _httpHost.trim().length() <= 1) {
                _httpHost = null;
            }
            if (_httpPort == null || _httpPort.trim().length() <= 1) {
                _httpPort = null;
            }
            if (_jvmProxySkipList == null || _jvmProxySkipList.trim().length() <= 1) {
                _jvmProxySkipList = null;
            }
            if (_httpUser == null || _httpUser.trim().length() <= 1) {
                _httpUser = null;
            }
            if (_httpPass == null || _httpPass.length() <= 1) {
                _httpPass = null;
            }
            Config.setProperty(JVM_HTTP_HOST_PROP_KEY, _httpHost);
            Config.setProperty(HTTP_PORT_PROP_KEY, _httpPort);
            Config.setProperty(JVM_HTTP_PORT_PROP_KEY, _httpPort);
            Config.setProperty(JVM_HTTP_SKIP_PROP_KEY, _jvmProxySkipList);
            Config.setProperty(HTTP_USER_PROP_KEY, _httpUser);
            ProxySettings.storeOrRemovePassword(HTTP_PASS_HANDLE, _httpPass);
            Config.setProperty(SECURE_HOST_PROP_KEY, _secureHttpHost);
            Config.setProperty(JVM_SECURE_HOST_PROP_KEY, _secureHttpHost);
            Config.setProperty(SECURE_PORT_PROP_KEY, _secureHttpPort);
            Config.setProperty(JVM_SECURE_PORT_PROP_KEY, _secureHttpPort);
            Config.setProperty(SECURE_USER_PROP_KEY, _secureHttpUser);
            ProxySettings.storeOrRemovePassword(SECURE_PASS_HANDLE, _secureHttpPass);
            Config.setProperty(FTP_HOST_PROP_KEY, _ftpHost);
            Config.setProperty(FTP_PORT_PROP_KEY, _ftpPort);
            Config.setProperty(FTP_USER_PROP_KEY, _ftpUser);
            Config.setProperty(FTP_TYPE_PROP_KEY, _ftpType);
            ProxySettings.storeOrRemovePassword(FTP_PASS_HANDLE, _ftpPass);
        }
    }

    private static void storeOrRemovePassword(String inHandle, WmSecureString inPass) {
        try {
            if (inPass == null) {
                ProxySettings.removePassword(inHandle);
            } else {
                ProxySettings.storePassword(inHandle, inPass);
            }
        }
        catch (PasswordManagerException pme) {
            ProxySettings.logExceptionMessage("ProxySettings.storeOrRemovePassword(" + inHandle + ")", pme);
        }
    }

    private static String oldDecode(String inPass) {
        if (inPass == null) {
            return null;
        }
        Password pw = new Password("");
        pw.setPasswd(inPass);
        return pw.getClearPasswd();
    }

    public static String getHttpProxyHost() {
        return _httpHost;
    }

    public static String getHttpProxyPort() {
        return ProxySettings.getHttpProxyPort("80");
    }

    public static String getHttpProxyPort(String inDefault) {
        return _httpPort == null ? inDefault : _httpPort;
    }

    public static String getHttpProxyHostAndPort() {
        return _httpHost + ":" + ProxySettings.getHttpProxyPort();
    }

    public static String getHttpProxyUser() {
        return _httpUser;
    }

    public static WmSecureString getHttpProxyPass() {
        if (_httpPass == null) {
            _httpPass = ProxySettings.retrievePassword(HTTP_PASS_HANDLE);
        }
        return _httpPass;
    }

    private static void setHttpProxyPass(String inPass) throws PasswordManagerException {
        if (inPass == null || inPass.trim().length() == 0) {
            _httpPass = null;
            ProxySettings.removePassword(HTTP_PASS_HANDLE);
        } else {
            _httpPass = new WmSecureString(inPass.trim());
            ProxySettings.storePassword(HTTP_PASS_HANDLE, _httpPass);
        }
    }

    public static String getSecureHttpProxyHost() {
        return _secureHttpHost;
    }

    public static String getSecureHttpProxyPort() {
        return ProxySettings.getSecureHttpProxyPort("80");
    }

    public static String getSecureHttpProxyPort(String inDefault) {
        return _secureHttpPort == null ? inDefault : _secureHttpPort;
    }

    public static String getHttpSecureProxyHostAndPort() {
        return _secureHttpHost + ":" + ProxySettings.getSecureHttpProxyPort();
    }

    public static String getSecureHttpProxyUser() {
        return _secureHttpUser;
    }

    public static WmSecureString getSecureHttpProxyPass() {
        if (_secureHttpPass == null) {
            _secureHttpPass = ProxySettings.retrievePassword(SECURE_PASS_HANDLE);
        }
        return _secureHttpPass;
    }

    private static void setSecureHttpProxyPass(String inPass) throws PasswordManagerException {
        if (inPass == null || inPass.trim().length() == 0) {
            _secureHttpPass = null;
            ProxySettings.removePassword(SECURE_PASS_HANDLE);
        } else {
            _secureHttpPass = new WmSecureString(inPass.trim());
            ProxySettings.storePassword(SECURE_PASS_HANDLE, _secureHttpPass);
        }
    }

    public static String getFtpProxyHost() {
        return _ftpHost;
    }

    public static String getFtpProxyPort() {
        return ProxySettings.getFtpProxyPort("80");
    }

    public static String getFtpProxyPort(String inDefault) {
        return _ftpPort == null ? inDefault : _ftpPort;
    }

    public static String getFtpProxyHostAndPort() {
        return _ftpHost + ":" + ProxySettings.getFtpProxyPort();
    }

    public static String getFtpProxyUser() {
        return _ftpUser;
    }

    public static WmSecureString getFtpProxyPass() {
        if (_ftpPass == null) {
            _ftpPass = ProxySettings.retrievePassword(FTP_PASS_HANDLE);
        }
        return _ftpPass;
    }

    private static void setFtpProxyPass(String inPass) throws PasswordManagerException {
        if (inPass == null || inPass.trim().length() == 0) {
            _ftpPass = null;
            ProxySettings.removePassword(FTP_PASS_HANDLE);
        } else {
            _ftpPass = new WmSecureString(inPass.trim());
            ProxySettings.storePassword(FTP_PASS_HANDLE, _ftpPass);
        }
    }

    public static String getFtpProxyType() {
        return _ftpType;
    }

    public static void addSettingsToPipeline(Values inPipe) {
        if (inPipe != null) {
            ProxySettings.addHttpSettingsToPipeline(inPipe);
            ProxySettings.addSecureHttpSettingsToPipeline(inPipe);
            ProxySettings.addFtpSettingsToPipeline(inPipe);
        }
    }

    private static void addHttpSettingsToPipeline(Values inPipe) {
        String host = ProxySettings.getHttpProxyHost();
        if (host != null && host.trim().length() > 0) {
            inPipe.put(HTTP_HOST_PROP_KEY, host);
            Config.setProperty(HTTP_HOST_PROP_KEY, host);
            Config.setProperty(JVM_HTTP_HOST_PROP_KEY, host);
            inPipe.put(HTTP_PORT_PROP_KEY, ProxySettings.getHttpProxyPort());
            Config.setProperty(HTTP_PORT_PROP_KEY, ProxySettings.getHttpProxyPort());
            Config.setProperty(JVM_HTTP_PORT_PROP_KEY, ProxySettings.getHttpProxyPort());
            inPipe.put(HTTP_USER_PROP_KEY, ProxySettings.getHttpProxyUser());
            Config.setProperty(HTTP_USER_PROP_KEY, ProxySettings.getHttpProxyUser());
            inPipe.put(HTTP_PASS_PROP_KEY, PIPELINE_PASSWORD_MASK);
            Config.setProperty(HTTP_PASS_PROP_KEY, ProxySettings.getHttpProxyPass());
            inPipe.put(JVM_HTTP_SKIP_PROP_KEY, _jvmProxySkipList);
            Config.setProperty(JVM_HTTP_SKIP_PROP_KEY, _jvmProxySkipList);
        } else {
            inPipe.remove(HTTP_HOST_PROP_KEY);
            Config.setProperty(HTTP_HOST_PROP_KEY, null);
            Config.setProperty(JVM_HTTP_HOST_PROP_KEY, null);
            inPipe.remove(HTTP_PORT_PROP_KEY);
            Config.setProperty(HTTP_PORT_PROP_KEY, null);
            Config.setProperty(JVM_HTTP_PORT_PROP_KEY, null);
            inPipe.remove(HTTP_USER_PROP_KEY);
            Config.setProperty(HTTP_USER_PROP_KEY, null);
            inPipe.remove(HTTP_PASS_PROP_KEY);
            Config.setProperty(HTTP_PASS_PROP_KEY, null);
            inPipe.put(JVM_HTTP_SKIP_PROP_KEY, null);
            Config.setProperty(JVM_HTTP_SKIP_PROP_KEY, null);
        }
    }

    private static void addSecureHttpSettingsToPipeline(Values inPipe) {
        String host = ProxySettings.getSecureHttpProxyHost();
        if (host != null && host.trim().length() > 0) {
            inPipe.put(SECURE_HOST_PROP_KEY, host);
            Config.setProperty(SECURE_HOST_PROP_KEY, host);
            Config.setProperty(JVM_SECURE_HOST_PROP_KEY, host);
            inPipe.put(SECURE_PORT_PROP_KEY, ProxySettings.getSecureHttpProxyPort());
            Config.setProperty(SECURE_PORT_PROP_KEY, ProxySettings.getSecureHttpProxyPort());
            Config.setProperty(JVM_SECURE_PORT_PROP_KEY, ProxySettings.getSecureHttpProxyPort());
            inPipe.put(SECURE_USER_PROP_KEY, ProxySettings.getSecureHttpProxyUser());
            Config.setProperty(SECURE_USER_PROP_KEY, ProxySettings.getSecureHttpProxyUser());
            inPipe.put(SECURE_PASS_PROP_KEY, PIPELINE_PASSWORD_MASK);
        } else {
            inPipe.remove(SECURE_HOST_PROP_KEY);
            Config.setProperty(SECURE_HOST_PROP_KEY, null);
            Config.setProperty(JVM_SECURE_HOST_PROP_KEY, null);
            inPipe.remove(SECURE_PORT_PROP_KEY);
            Config.setProperty(SECURE_PORT_PROP_KEY, null);
            Config.setProperty(JVM_SECURE_PORT_PROP_KEY, null);
            inPipe.remove(SECURE_USER_PROP_KEY);
            Config.setProperty(SECURE_USER_PROP_KEY, null);
            inPipe.remove(SECURE_PASS_PROP_KEY);
            Config.setProperty(SECURE_PASS_PROP_KEY, null);
        }
    }

    private static void addFtpSettingsToPipeline(Values inPipe) {
        String host = ProxySettings.getFtpProxyHost();
        if (host != null && host.trim().length() > 0) {
            inPipe.put(FTP_HOST_PROP_KEY, host);
            Config.setProperty(FTP_HOST_PROP_KEY, host);
            inPipe.put(FTP_PORT_PROP_KEY, ProxySettings.getFtpProxyPort());
            Config.setProperty(FTP_PORT_PROP_KEY, ProxySettings.getFtpProxyPort());
            inPipe.put(FTP_USER_PROP_KEY, ProxySettings.getFtpProxyUser());
            Config.setProperty(FTP_USER_PROP_KEY, ProxySettings.getFtpProxyUser());
            inPipe.put(FTP_PASS_PROP_KEY, PIPELINE_PASSWORD_MASK);
            Config.setProperty(FTP_PASS_PROP_KEY, ProxySettings.getFtpProxyPass());
            inPipe.put(FTP_TYPE_PROP_KEY, ProxySettings.getFtpProxyType());
            Config.setProperty(FTP_TYPE_PROP_KEY, ProxySettings.getFtpProxyType());
        } else {
            inPipe.remove(FTP_HOST_PROP_KEY);
            Config.setProperty(FTP_HOST_PROP_KEY, null);
            inPipe.remove(FTP_PORT_PROP_KEY);
            Config.setProperty(FTP_PORT_PROP_KEY, null);
            inPipe.remove(FTP_USER_PROP_KEY);
            Config.setProperty(FTP_USER_PROP_KEY, null);
            inPipe.remove(FTP_PASS_PROP_KEY);
            Config.setProperty(FTP_PASS_PROP_KEY, null);
            inPipe.remove(FTP_TYPE_PROP_KEY);
            Config.setProperty(FTP_TYPE_PROP_KEY, null);
        }
    }

    public static String formatJVMProxySkipList(String proxySkipList) {
        if (proxySkipList == null) {
            return null;
        }
        StringBuffer jvmSkipList = new StringBuffer();
        StringTokenizer st = new StringTokenizer(proxySkipList, ",");
        while (st.hasMoreTokens()) {
            jvmSkipList.append(st.nextToken().trim()).append("|");
        }
        return jvmSkipList.toString();
    }

    public static void refreshFromPipeline(Values inPipe) throws PasswordManagerException {
        if (inPipe != null) {
            if (inPipe.containsKey(PROXY_SKIP_LIST)) {
                _jvmProxySkipList = ProxySettings.formatJVMProxySkipList(ProxySettings.getPipelineString(inPipe, PROXY_SKIP_LIST));
            }
            if (inPipe.containsKey(HTTP_HOST_PROP_KEY)) {
                ProxySettings.refreshHttp(inPipe);
            }
            if (inPipe.containsKey(SECURE_HOST_PROP_KEY)) {
                ProxySettings.refreshSecureHttp(inPipe);
            }
            if (inPipe.containsKey(FTP_HOST_PROP_KEY)) {
                ProxySettings.refreshFtp(inPipe);
            }
        }
    }

    private static void refreshHttp(Values inPipe) throws PasswordManagerException {
        String tempHost = ProxySettings.getPipelineString(inPipe, HTTP_HOST_PROP_KEY);
        if (tempHost == null) {
            _httpHost = null;
            _httpPort = null;
            _httpUser = null;
            ProxySettings.setHttpProxyPass(null);
            ProxySettings.addHttpSettingsToPipeline(inPipe);
        } else {
            String tempPort = ProxySettings.getPipelineString(inPipe, HTTP_PORT_PROP_KEY);
            try {
                Integer.parseInt(tempPort);
            }
            catch (NumberFormatException nfe) {
                ProxySettings.addHttpSettingsToPipeline(inPipe);
                String bundle = "com.wm.resources.B2BCoreMsgBundle";
                throw new PasswordManagerException("62.36", bundle, new String[]{tempPort, HTTP_HANDLE_SUFFIX}, "invalid http port: " + tempPort);
            }
            _httpHost = tempHost;
            _httpPort = tempPort;
            _httpUser = ProxySettings.getPipelineString(inPipe, HTTP_USER_PROP_KEY);
            String pipePass = ProxySettings.getPipelineString(inPipe, HTTP_PASS_PROP_KEY);
            if (!PIPELINE_PASSWORD_MASK.equals(pipePass)) {
                ProxySettings.setHttpProxyPass(pipePass);
            }
        }
    }

    private static void refreshSecureHttp(Values inPipe) throws PasswordManagerException {
        String tempHost = ProxySettings.getPipelineString(inPipe, SECURE_HOST_PROP_KEY);
        if (tempHost == null) {
            _secureHttpHost = null;
            _secureHttpPort = null;
            _secureHttpUser = null;
            ProxySettings.setSecureHttpProxyPass(null);
            ProxySettings.addSecureHttpSettingsToPipeline(inPipe);
        } else {
            String tempPort = ProxySettings.getPipelineString(inPipe, SECURE_PORT_PROP_KEY);
            try {
                Integer.parseInt(tempPort);
            }
            catch (NumberFormatException nfe) {
                ProxySettings.addSecureHttpSettingsToPipeline(inPipe);
                String bundle = "com.wm.resources.B2BCoreMsgBundle";
                throw new PasswordManagerException("62.36", bundle, new String[]{tempPort, "https"}, "invalid https port: " + tempPort);
            }
            _secureHttpHost = tempHost;
            _secureHttpPort = tempPort;
            _secureHttpUser = ProxySettings.getPipelineString(inPipe, SECURE_USER_PROP_KEY);
            String pipePass = ProxySettings.getPipelineString(inPipe, SECURE_PASS_PROP_KEY);
            if (!PIPELINE_PASSWORD_MASK.equals(pipePass)) {
                ProxySettings.setSecureHttpProxyPass(pipePass);
            }
        }
    }

    private static void refreshFtp(Values inPipe) throws PasswordManagerException {
        String tempHost = ProxySettings.getPipelineString(inPipe, FTP_HOST_PROP_KEY);
        if (tempHost == null) {
            _ftpHost = null;
            _ftpPort = null;
            _ftpUser = null;
            ProxySettings.setFtpProxyPass(null);
            _ftpType = null;
            ProxySettings.addFtpSettingsToPipeline(inPipe);
        } else {
            String tempPort = ProxySettings.getPipelineString(inPipe, FTP_PORT_PROP_KEY);
            try {
                Integer.parseInt(tempPort);
            }
            catch (NumberFormatException nfe) {
                ProxySettings.addFtpSettingsToPipeline(inPipe);
                String bundle = "com.wm.resources.B2BCoreMsgBundle";
                throw new PasswordManagerException("62.36", bundle, new String[]{tempPort, FTP_HANDLE_SUFFIX}, "invalid ftp port: " + tempPort);
            }
            _ftpHost = tempHost;
            _ftpPort = tempPort;
            _ftpUser = ProxySettings.getPipelineString(inPipe, FTP_USER_PROP_KEY);
            _ftpType = ProxySettings.getPipelineString(inPipe, FTP_TYPE_PROP_KEY);
            String pipePass = ProxySettings.getPipelineString(inPipe, FTP_PASS_PROP_KEY);
            if (!PIPELINE_PASSWORD_MASK.equals(pipePass)) {
                ProxySettings.setFtpProxyPass(pipePass);
            }
        }
    }

    private static String getPipelineString(Values inPipe, String inKey) {
        String returnStr = null;
        if (inPipe.containsKey(inKey)) {
            String temp = (String)inPipe.get(inKey);
            returnStr = temp != null && temp.trim().length() > 0 ? temp.trim() : null;
        }
        return returnStr;
    }

    public static void setProxy(String inProxy) {
        if (inProxy == null || inProxy.length() == 0) {
            _httpHost = null;
            _httpPort = null;
        } else {
            _httpHost = ProxySettings.extractHost(inProxy);
            _httpPort = ProxySettings.extractPort(inProxy, "80");
        }
    }

    public static void setSecureProxy(String inProxy) {
        if (inProxy == null || inProxy.length() == 0) {
            _secureHttpHost = null;
            _secureHttpPort = null;
        } else {
            _secureHttpHost = ProxySettings.extractHost(inProxy);
            _secureHttpPort = ProxySettings.extractPort(inProxy, "80");
        }
    }

    public static void setProxyAuth(String user, String password) {
        _httpUser = user;
        try {
            ProxySettings.setHttpProxyPass(password);
        }
        catch (PasswordManagerException pme) {
            ProxySettings.logExceptionMessage("ProxySettings.setProxyAuth()", pme);
        }
    }

    public static String extractHost(String hostport) {
        if (hostport == null || hostport.length() == 0) {
            return null;
        }
        int pos = hostport.indexOf(58);
        if (pos < 0) {
            return hostport;
        }
        return hostport.substring(0, pos);
    }

    public static String extractPort(String hostport, String defPort) {
        if (hostport == null) {
            return "";
        }
        int pos = hostport.indexOf(58);
        return pos < 0 || pos == hostport.length() - 1 ? defPort : hostport.substring(pos + 1);
    }

    public static boolean isPasswordKey(String inKey) {
        return inKey != null && (inKey.equals("watt.server.cluster.password") || ProxySettings.isProxyPasswordKey(inKey));
    }

    public static boolean isProxyPasswordKey(String inKey) {
        return inKey != null && (inKey.equals(HTTP_PASS_PROP_KEY) || inKey.equals(SECURE_PASS_PROP_KEY) || inKey.equals(FTP_PASS_PROP_KEY));
    }

    public static void setProxy(String host, String user, String pass) {
        ProxySettings.setProxy(host);
        if (host == null || host.length() == 0) {
            ProxySettings.setProxyAuth("", "");
        } else {
            if (user != null) {
                _httpUser = user;
            }
            if (pass != null) {
                try {
                    ProxySettings.setHttpProxyPass(pass);
                }
                catch (PasswordManagerException pme) {
                    ProxySettings.logExceptionMessage("ProxySettings.setProxy()", pme);
                }
            }
        }
    }

    public static void setSecureProxy(String host, String user, String pass) {
        ProxySettings.setSecureProxy(host);
        if (host == null || host.length() == 0) {
            _secureHttpUser = null;
            try {
                ProxySettings.setSecureHttpProxyPass(null);
            }
            catch (PasswordManagerException pme) {
                ProxySettings.logExceptionMessage("ProxySettings.setProxy()", pme);
            }
        } else {
            if (user != null) {
                _secureHttpUser = user;
            }
            if (pass != null) {
                try {
                    ProxySettings.setSecureHttpProxyPass(pass);
                }
                catch (PasswordManagerException pme) {
                    ProxySettings.logExceptionMessage("ProxySettings.setProxy()", pme);
                }
            }
        }
    }

    private static void refreshPasswords() throws PasswordManagerException {
        WmSecureString secStr = ProxySettings.retrievePassword(HTTP_PASS_HANDLE);
        if (secStr != null) {
            ProxySettings.setHttpProxyPass(secStr.toString());
        }
        if ((secStr = ProxySettings.retrievePassword(SECURE_PASS_HANDLE)) != null) {
            ProxySettings.setSecureHttpProxyPass(secStr.toString());
        }
        if ((secStr = ProxySettings.retrievePassword(FTP_PASS_HANDLE)) != null) {
            ProxySettings.setFtpProxyPass(secStr.toString());
        }
    }

    private static void storePassword(String inHandle, WmSecureString inPass) throws PasswordManagerException {
        if (gPassMan == null) {
            JournalLogger.logInfo(5, 77, "ProxySettings.storePassword");
        } else {
            WmSecureString tempPw = gPassMan.retrievePassword(inHandle);
            if (tempPw == null) {
                gPassMan.storePassword(inHandle, inPass);
            } else if (inPass != null && !inPass.equals(tempPw)) {
                String encCode = gPassMan.retrieveEncryptionCode(inHandle);
                gPassMan.storePassword(inHandle, inPass, encCode);
            }
        }
    }

    private static WmSecureString retrievePassword(String inHandle) {
        WmSecureString returnPass = null;
        if (gPassMan == null) {
            JournalLogger.logInfo(5, 77, "ProxySettings.retrievePassword");
        } else {
            try {
                returnPass = gPassMan.retrievePassword(inHandle);
            }
            catch (PasswordManagerException pme) {
                ProxySettings.logExceptionMessage("ProxySettings.retrievePassword(" + inHandle + ")", pme);
            }
        }
        return returnPass;
    }

    private static void removePassword(String inHandle) throws PasswordManagerException {
        if (gPassMan == null) {
            JournalLogger.logInfo(5, 77, "ProxySettings.removePassword");
        } else {
            gPassMan.removePassword(inHandle);
        }
    }

    private static void logExceptionMessage(String inSource, Throwable inExc) {
        Object[] msgParams = new String[]{inSource, inExc.getClass().getName(), inExc.getMessage()};
        JournalLogger.logError(4, 77, msgParams);
    }

    static {
        gPassMan = null;
    }
}

