/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.CharacterClassChecker;
import com.wm.util.XML10Constants;

class NCNameValidator
implements XML10Constants {
    private CharacterClassChecker _charChecker;

    NCNameValidator(CharacterClassChecker charChecker) {
        this._charChecker = charChecker;
    }

    boolean validate(String name) {
        if (name == null) {
            return false;
        }
        int size = name.length();
        if (size < 1) {
            return false;
        }
        boolean isXML = false;
        char c = name.charAt(0);
        if (!this._charChecker.firstChar(c)) {
            return false;
        }
        if (c == 'x' || c == 'X') {
            isXML = true;
        }
        for (int i = 1; i < size; ++i) {
            c = name.charAt(i);
            if (!this._charChecker.NCNameChar(c)) {
                return false;
            }
            if (isXML && i == 1 && c != 'm' && c != 'M') {
                isXML = false;
            }
            if (!isXML || i != 2 || c != 'l' && c != 'L') continue;
            return false;
        }
        return true;
    }
}

