/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.g11n.text.NCNameCoder;
import com.wm.util.CharacterClassChecker;
import com.wm.util.NCNameValidator;

public class NCName {
    static CharacterClassChecker CHARACTER_CLASS_CHECKER = new CharacterClassChecker();
    static NCNameValidator VALIDATOR = new NCNameValidator(CHARACTER_CLASS_CHECKER);

    public static boolean validate(String name) {
        boolean encodeXML = new Boolean(System.getProperty("watt.server.xml.ncname.encode.backward.compatibility", "false"));
        if (encodeXML) {
            return NCNameCoder.validate((String)name);
        }
        return NCNameCoder.validateLocalPart((String)name);
    }

    public static String encode(String name) {
        boolean encodeXML = new Boolean(System.getProperty("watt.server.xml.ncname.encode.backward.compatibility", "false"));
        if (encodeXML) {
            return NCNameCoder.encode((String)name);
        }
        return NCNameCoder.encodeLocalPart((String)name);
    }

    public static String decode(String name) {
        return NCNameCoder.decode((String)name);
    }

    public static boolean testEncode(String name) {
        StringBuffer buf = new StringBuffer();
        boolean success = false;
        try {
            buf.append("E> application-defined-name=");
            buf.append(name);
            buf.append("; encoded-name=");
            String encodedName = NCName.encode(name);
            buf.append(encodedName);
            buf.append("; decoded-name=");
            String decodedName = NCName.decode(encodedName);
            buf.append(decodedName);
            success = name.equals(decodedName);
            buf.append("; result=");
            if (success) {
                buf.append("SUCCESS");
            } else {
                buf.append("FAILED");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println(buf.toString());
        return success;
    }

    public static boolean testDecode(String encodedName, String actualName) {
        StringBuffer buf = new StringBuffer();
        boolean success = false;
        try {
            buf.append("D> encoded-name=");
            buf.append(encodedName);
            buf.append("; decoded-name=");
            String decodedName = NCName.decode(encodedName);
            buf.append(decodedName);
            success = actualName.equals(decodedName);
            buf.append("; result=");
            if (success) {
                buf.append("SUCCESS");
            } else {
                buf.append("FAILED");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println(buf.toString());
        return success;
    }

    public static boolean testValidate(String name, boolean expectedResult) {
        StringBuffer buf = new StringBuffer();
        boolean success = false;
        try {
            buf.append("V> given-name=");
            buf.append(name);
            buf.append("; valid=");
            boolean isValid = NCName.validate(name);
            buf.append(isValid);
            success = expectedResult == isValid;
            buf.append("; result=");
            if (success) {
                buf.append("SUCCESS");
            } else {
                buf.append("FAILED");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println(buf.toString());
        return success;
    }

    public static void main(String[] args) {
        NCName.testEncode("a:b");
        NCName.testEncode("@amount");
        NCName.testEncode("*body");
        NCName.testEncode("a?b");
        NCName.testEncode("oag:purchaseOrder");
        NCName.testEncode("purchaseOrder");
        NCName.testEncode("xml");
        NCName.testEncode("xml:lang");
        NCName.testEncode("_xPort");
        NCName.testEncode("t_xPort");
        char[] str = new char[]{'\uf301', 'a', ':', 'b'};
        NCName.testEncode(new String(str));
        NCName.testDecode("a_x005bc", "a_x005bc");
        NCName.testDecode("a_x00003A_b", "a:b");
        NCName.testDecode("a_x003a_b", "a:b");
        NCName.testDecode("a_x003s_b", "a_x003s_b");
        NCName.testValidate("a:b", false);
        NCName.testValidate("@amount", false);
        NCName.testValidate("*body", false);
        NCName.testValidate("a?b", false);
        NCName.testValidate("oag:purchaseOrder", false);
        NCName.testValidate("purchaseOrder", true);
        NCName.testValidate("xml", false);
        NCName.testValidate("xml:lang", false);
        NCName.testValidate("_xPort", false);
        NCName.testValidate("t_xPort", false);
    }
}

