/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.B2BListResourceBundle;
import com.wm.util.FacilityInfo;
import com.wm.util.LogStringInfo;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class MsgResources {
    private static String[] FAC_STR;
    protected Hashtable gLogStringMap = new Hashtable(101, 0.8f);
    protected Hashtable gFacilityMap = new Hashtable(101, 0.8f);
    protected Vector bundles = null;
    private static final int INITIAL_LOAD_CAPACITY = 101;

    public MsgResources() {
    }

    public MsgResources(String resPath) {
        if (this.bundles == null) {
            this.bundles = new Vector();
        }
        if (resPath == null) {
            return;
        }
        Vector v = MsgResources.getclassesInPackage(resPath);
        for (int i = 0; i < v.size(); ++i) {
            ResourceBundle locale_bundle;
            B2BListResourceBundle rb;
            Object o;
            try {
                Class<?> c = Class.forName(resPath + "." + v.elementAt(i));
                o = c.newInstance();
            }
            catch (Exception e) {
                continue;
            }
            if (!(o instanceof B2BListResourceBundle) || (rb = (B2BListResourceBundle)o).getClass().getName().indexOf("_") != -1 || (locale_bundle = ResourceBundle.getBundle(rb.getClass().getName())) == null) continue;
            this.registerBundle((B2BListResourceBundle)locale_bundle);
        }
    }

    public void registerBundle(B2BListResourceBundle rb) {
        if (rb != null) {
            DecimalFormat nf = new DecimalFormat("####");
            nf.setMinimumIntegerDigits(4);
            Enumeration<String> e = rb.getKeys();
            while (e.hasMoreElements()) {
                String fac_key = e.nextElement();
                Integer fac_code = new Integer(fac_key);
                String fac_str = nf.format(fac_code.intValue());
                FacilityInfo facinfo = new FacilityInfo(fac_str, null, rb.getProdGroup(), rb.getProdComponent());
                if (this.gFacilityMap.containsKey(fac_code)) continue;
                this.gFacilityMap.put(fac_code, facinfo);
                Object[][] ar = (Object[][])rb.getObject(fac_key);
                Hashtable<Integer, LogStringInfo> map = new Hashtable<Integer, LogStringInfo>(10);
                for (int k = 0; k < ar.length; ++k) {
                    int severity;
                    int err_key = -1;
                    if (!(ar[k][0] instanceof Integer)) continue;
                    err_key = (Integer)ar[k][0];
                    String logstr = (String)ar[k][2];
                    try {
                        severity = (Integer)ar[k][1];
                    }
                    catch (Exception nfe) {
                        severity = 3;
                    }
                    LogStringInfo LogInfo = new LogStringInfo();
                    LogInfo.gLogString = logstr;
                    LogInfo.gLogString = LogInfo.gLogString.trim();
                    LogInfo.gSeverity = severity;
                    if (map == null || err_key == -1) continue;
                    map.put(new Integer(err_key), LogInfo);
                }
                this.gLogStringMap.put(fac_code, map);
            }
        }
    }

    public Hashtable getFacilityMap() {
        return this.gFacilityMap;
    }

    public Hashtable getLogStringMap() {
        return this.gLogStringMap;
    }

    public static void init() {
    }

    public static Vector getclassesInPackage(String pkg) {
        Vector<String> v = new Vector<String>(20);
        try {
            char fileseparator = File.separator.charAt(0);
            String pkgfs = pkg.replace('.', '/');
            String pkgbs = pkg.replace('.', '\\');
            pkg = pkg.replace('.', fileseparator);
            Properties prop = System.getProperties();
            String str = prop.getProperty("wm.server.class.path") + File.pathSeparatorChar + prop.getProperty("java.class.path");
            StringTokenizer steTok = new StringTokenizer(str, File.pathSeparator);
            while (steTok.hasMoreElements()) {
                int start;
                String foundClassName;
                Object file;
                String tempStr = steTok.nextToken();
                String tolower = tempStr.toLowerCase().trim();
                if (tolower.endsWith(".zip") || tolower.endsWith(".jar")) {
                    file = null;
                    try {
                        file = new ZipFile(tempStr);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (file == null) continue;
                    Enumeration<? extends ZipEntry> enumvar = ((ZipFile)file).entries();
                    while (enumvar.hasMoreElements()) {
                        ZipEntry filefound = enumvar.nextElement();
                        foundClassName = filefound.getName();
                        if (!foundClassName.startsWith(pkgbs) && !foundClassName.startsWith(pkgfs) || !foundClassName.toLowerCase().endsWith(".class")) continue;
                        start = foundClassName.lastIndexOf("/");
                        if (start == -1) {
                            start = foundClassName.lastIndexOf("\\");
                        }
                        foundClassName = foundClassName.substring(start + 1, foundClassName.length() - 6);
                        v.addElement(foundClassName);
                    }
                    continue;
                }
                file = new File(tempStr + fileseparator + pkg);
                if (!((File)file).exists() || !((File)file).isDirectory()) continue;
                String[] classnames = ((File)file).list();
                for (int i = 0; i < classnames.length; ++i) {
                    foundClassName = classnames[i];
                    if (!foundClassName.toLowerCase().endsWith(".class")) continue;
                    start = foundClassName.lastIndexOf("/");
                    if (start == -1) {
                        start = foundClassName.lastIndexOf("\\");
                    }
                    foundClassName = foundClassName.substring(start + 1, foundClassName.length() - 6);
                    v.addElement(foundClassName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        return v;
    }

    public static void main(String[] args) {
        MsgResources msgres = new MsgResources();
        Hashtable h = msgres.getLogStringMap();
        if (h == null) {
            System.out.println("hashtable is null");
        }
    }
}

