/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.LocalizedException;
import com.wm.util.LocalizedExceptionInfo;
import com.wm.util.SpecifiedLocale;
import java.util.Locale;

public class LocalizedRuntimeException
extends RuntimeException
implements SpecifiedLocale {
    LocalizedExceptionInfo info;

    public String getLocalizedMessage() {
        if (this.info == null) {
            return super.getLocalizedMessage();
        }
        return this.info.format();
    }

    public String getLocalizedMessage(Locale locale) {
        if (this.info == null) {
            return super.getLocalizedMessage();
        }
        return this.info.format(locale);
    }

    public String getMessage() {
        if (this.info == null) {
            return super.getMessage();
        }
        return this.info.format(NULL_LOCALE);
    }

    public LocalizedRuntimeException(String s) {
        super(s);
    }

    public LocalizedRuntimeException() {
    }

    protected LocalizedRuntimeException(LocalizedException ex) {
        this.info = ex.info;
    }

    public LocalizedRuntimeException(String bundleBaseName, String bundleKey, Object[] substitutions, ClassLoader theBundleClassLoader) {
        this.info = new LocalizedExceptionInfo(bundleBaseName, bundleKey, substitutions, theBundleClassLoader);
    }

    public LocalizedRuntimeException(String bundleBaseName, String bundleKey, ClassLoader theBundleClassLoader) {
        this.info = new LocalizedExceptionInfo(bundleBaseName, bundleKey, theBundleClassLoader);
    }

    public LocalizedRuntimeException(String bundleBaseName, String bundleKey, String substitution, ClassLoader theBundleClassLoader) {
        this.info = new LocalizedExceptionInfo(bundleBaseName, bundleKey, substitution, theBundleClassLoader);
    }

    public LocalizedRuntimeException(Class bundleClass, String bundleKey, String sourceID, Object[] substitutions) {
        this.info = new LocalizedExceptionInfo(bundleClass, bundleKey, sourceID, substitutions);
    }

    public LocalizedRuntimeException(Class bundleClass, String bundleKey, String sourceID) {
        this.info = new LocalizedExceptionInfo(bundleClass, bundleKey, sourceID);
    }

    public LocalizedRuntimeException(Class bundleClass, String bundleKey, String sourceID, String substitution) {
        this.info = new LocalizedExceptionInfo(bundleClass, bundleKey, sourceID, substitution);
    }
}

