/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.B2BListResourceBundle;
import com.wm.util.JournalLogger;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class LocalizedExceptionInfo
implements Serializable {
    private final String format = "[{0}{1}.{2,number,0000}.{3,number,0000}] {4}";
    private final String msgIdFormat = "{0}{1}.{2,number,0000}.{3,number,0000}";
    private final String msgOnlyFormat = "{4}";
    private static final int ENTIRE_MSG = 1;
    private static final int ONLY_MSGID = 2;
    private static final int ONLY_MSG = 3;
    private String bundleBaseName;
    private String bundleKey;
    private Object[] substitutions;
    private Class bundleClass;
    private ClassLoader resourceClassLoader;

    public LocalizedExceptionInfo(String aBundleBaseName, String aBundleKey, Object[] someSubstitutions, ClassLoader aClassLoader) {
        this.assertNotNull(aBundleBaseName, aBundleKey);
        this.setBundleBaseName(aBundleBaseName);
        this.setBundleKey(aBundleKey);
        this.setSubstitutions(someSubstitutions);
        this.setResourceClassLoader(aClassLoader);
    }

    public LocalizedExceptionInfo(String aBundleBaseName, String aBundleKey, ClassLoader aClassLoader) {
        this.assertNotNull(aBundleBaseName, aBundleKey);
        this.setBundleBaseName(aBundleBaseName);
        this.setBundleKey(aBundleKey);
        this.setSubstitutions(null);
        this.setResourceClassLoader(aClassLoader);
    }

    public LocalizedExceptionInfo(String aBundleBaseName, String aBundleKey, String aSubstitution, ClassLoader aClassLoader) {
        this.assertNotNull(aBundleBaseName, aBundleKey);
        this.setBundleBaseName(aBundleBaseName);
        this.setBundleKey(aBundleKey);
        if (aSubstitution == null) {
            aSubstitution = "";
        }
        this.setSubstitutions(new Object[]{aSubstitution});
        this.setResourceClassLoader(aClassLoader);
    }

    public String format() {
        return this.format(Locale.getDefault());
    }

    public String formatMsgOnly() {
        return this.formatMsgOnly(Locale.getDefault());
    }

    public String formatMsgId() {
        return this.formatMsgId(Locale.getDefault());
    }

    public String format(Locale locale) {
        return this.format(locale, 1);
    }

    public String formatMsgOnly(Locale locale) {
        return this.format(locale, 3);
    }

    public String formatMsgId(Locale locale) {
        return this.format(locale, 2);
    }

    public String format(Locale aLocale, int aMessageType) {
        String msg = null;
        ResourceBundle resourceBundle = this.getResourceBundle(aLocale);
        if (resourceBundle instanceof B2BListResourceBundle) {
            try {
                Object[] ar;
                B2BListResourceBundle b2bListRB = (B2BListResourceBundle)resourceBundle;
                Object o = b2bListRB.getObject(this.getBundleKey());
                if (o instanceof String) {
                    msg = (String)o;
                } else if (o instanceof Object[] && (ar = (Object[])o)[2] instanceof String) {
                    msg = (String)ar[2];
                }
                if (this.substitutions != null) {
                    msg = MessageFormat.format(msg, this.substitutions);
                }
                ar = new Object[]{b2bListRB.getProdGroup(), b2bListRB.getProdComponent(), new Integer(b2bListRB.getFacility()), new Integer(this.getBundleKey()), msg};
                switch (aMessageType) {
                    case 2: {
                        msg = MessageFormat.format(this.getMsgIdFormat(), ar);
                        break;
                    }
                    case 3: {
                        msg = MessageFormat.format(this.getMsgOnlyFormat(), ar);
                        break;
                    }
                    default: {
                        msg = MessageFormat.format(this.getFormat(), ar);
                        break;
                    }
                }
            }
            catch (Exception e) {
                JournalLogger.log(9998, 77, e);
            }
        } else {
            msg = resourceBundle.getString(this.getBundleKey());
            if (this.substitutions != null) {
                msg = MessageFormat.format(msg, this.substitutions);
            }
        }
        return msg;
    }

    public Object[] getSubstitutions() {
        return this.substitutions;
    }

    private String getBundleBaseName() {
        if (this.bundleBaseName == null && this.getBundleClass() == null) {
            throw new IllegalStateException();
        }
        if (this.getBundleClass() != null) {
            return this.getBundleClass().getName();
        }
        return this.bundleBaseName;
    }

    private ResourceBundle getResourceBundle(Locale aLocale) {
        ResourceBundle resourceBundle = null;
        ClassLoader bndlClassLoader = null;
        bndlClassLoader = this.getBundleClass() != null ? this.getBundleClass().getClassLoader() : (this.getResourceClassLoader() != null ? this.getResourceClassLoader() : this.getClass().getClassLoader());
        resourceBundle = ResourceBundle.getBundle(this.getBundleBaseName(), aLocale, bndlClassLoader);
        return resourceBundle;
    }

    private void assertNotNull(String aBundleBaseName, String aBundleKey) {
        if (aBundleBaseName == null || aBundleKey == null) {
            throw new IllegalArgumentException();
        }
    }

    private String getFormat() {
        return "[{0}{1}.{2,number,0000}.{3,number,0000}] {4}";
    }

    private String getMsgIdFormat() {
        return "{0}{1}.{2,number,0000}.{3,number,0000}";
    }

    private String getMsgOnlyFormat() {
        return "{4}";
    }

    private String getBundleKey() {
        return this.bundleKey;
    }

    private Class getBundleClass() {
        return this.bundleClass;
    }

    private ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    private void setBundleBaseName(String bundleBaseName) {
        this.bundleBaseName = bundleBaseName;
    }

    private void setBundleKey(String bundleKey) {
        this.bundleKey = bundleKey;
    }

    private void setSubstitutions(Object[] substitutions) {
        this.substitutions = substitutions;
    }

    private void setBundleClass(Class bundleClass) {
        this.bundleClass = bundleClass;
    }

    private void setResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    public LocalizedExceptionInfo(Class bundleClass, String bundleKey, String sourceID, Object[] substitutions) {
        this.setBundleClass(bundleClass);
        this.setBundleKey(bundleKey);
        this.setSubstitutions(substitutions);
    }

    public LocalizedExceptionInfo(Class bundleClass, String bundleKey, String sourceID) {
        this.setBundleClass(bundleClass);
        this.setBundleKey(bundleKey);
        this.setSubstitutions(null);
    }

    public LocalizedExceptionInfo(Class bundleClass, String bundleKey, String sourceID, String substitution) {
        this.setBundleClass(bundleClass);
        this.setBundleKey(bundleKey);
        if (substitution == null) {
            substitution = "";
        }
        this.setSubstitutions(new Object[]{substitution});
    }
}

