/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.data.IData;
import com.wm.util.LocalizedExceptionInfo;
import com.wm.util.LocalizedMessage;
import com.wm.util.SpecifiedLocale;
import java.util.Locale;

public class LocalizedException
extends Exception
implements SpecifiedLocale {
    LocalizedExceptionInfo info;
    Throwable wrapped;
    IData details;

    public IData getErrorDetails() {
        return this.details;
    }

    public void setErrorDetails(IData details) {
        this.details = details;
    }

    public String getLocalizedMessage() {
        String ret = this.info == null ? super.getLocalizedMessage() : this.info.format();
        if (ret == null) {
            ret = new String();
        }
        return ret;
    }

    public Throwable getWrappedException() {
        return this.wrapped;
    }

    public String getLocalizedMessage(Locale locale) {
        String ret;
        if (this.info == null) {
            ret = super.getLocalizedMessage();
        } else {
            String string = ret = locale != null ? this.info.format(locale) : this.info.format();
        }
        if (ret == null) {
            ret = new String();
        }
        return ret;
    }

    public String getMessage() {
        if (this.info == null) {
            return super.getMessage();
        }
        return this.info.format(LocalizedMessage.NULL_LOCALE);
    }

    public String getMsgId() {
        if (this.info == null) {
            return null;
        }
        return this.info.formatMsgId(LocalizedMessage.NULL_LOCALE);
    }

    public String getMsgOnly() {
        return this.getMsgOnly(LocalizedMessage.NULL_LOCALE);
    }

    public String getMsgOnly(Locale locale) {
        if (this.info == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return this.info.formatMsgOnly(locale);
    }

    public LocalizedExceptionInfo getInfo() {
        return this.info;
    }

    public LocalizedException() {
    }

    public LocalizedException(LocalizedExceptionInfo info) {
        this.info = info;
    }

    public LocalizedException(String s) {
        super(s);
    }

    public LocalizedException(Throwable t) {
        super(t == null ? null : t.toString());
        if (t != null && t instanceof LocalizedException) {
            this.info = ((LocalizedException)t).getInfo();
        }
        this.wrapped = t;
    }

    public LocalizedException(String bundleBaseName, String bundleKey, ClassLoader theBundleClassLoader) {
        this.info = new LocalizedExceptionInfo(bundleBaseName, bundleKey, theBundleClassLoader);
    }

    public LocalizedException(String bundleBaseName, String bundleKey, String substitution, ClassLoader theBundleClassLoader) {
        this.info = new LocalizedExceptionInfo(bundleBaseName, bundleKey, substitution, theBundleClassLoader);
    }

    public LocalizedException(String bundleBaseName, String bundleKey, Object[] substitutions, ClassLoader theBundleClassLoader) {
        this.info = new LocalizedExceptionInfo(bundleBaseName, bundleKey, substitutions, theBundleClassLoader);
    }

    public LocalizedException(String bundleBaseName, String bundleKey, Throwable t, Object[] substitutions, ClassLoader theBundleClassLoader) {
        super(t == null ? null : t.toString());
        this.info = new LocalizedExceptionInfo(bundleBaseName, bundleKey, substitutions, theBundleClassLoader);
        this.wrapped = t;
    }

    public LocalizedException(Class bundleClass, String bundleKey, String sourceID) {
        this.info = new LocalizedExceptionInfo(bundleClass, bundleKey, sourceID);
    }

    public LocalizedException(Class bundleClass, String bundleKey, String sourceID, String substitution) {
        this.info = new LocalizedExceptionInfo(bundleClass, bundleKey, sourceID, substitution);
    }

    public LocalizedException(Class bundleClass, String bundleKey, String sourceID, Object[] substitutions) {
        this.info = new LocalizedExceptionInfo(bundleClass, bundleKey, sourceID, substitutions);
    }

    public LocalizedException(Class bundleClass, String bundleKey, String sourceID, Throwable t, Object[] substitutions) {
        super(t == null ? null : t.toString());
        this.info = new LocalizedExceptionInfo(bundleClass, bundleKey, sourceID, substitutions);
        this.wrapped = t;
    }
}

