/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.ListEnumerator;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class List
implements Serializable {
    Object[] list;
    int curPtr = 0;

    public List() {
        this(10);
    }

    public List(int size) {
        this.list = new Object[size];
    }

    public List(Object[] o) {
        if (o != null) {
            for (int i = 0; i < o.length; ++i) {
                this.addElement(o[i]);
            }
        }
    }

    public List(Enumeration e) {
        this();
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            this.addElement(e.nextElement());
        }
    }

    public void addElement(Object o) {
        this.list[this.curPtr++] = o;
        if (this.curPtr >= this.list.length) {
            Object[] newlist = new Object[this.list.length * 2];
            System.arraycopy(this.list, 0, newlist, 0, this.list.length);
            this.list = newlist;
        }
    }

    public boolean contains(Object o) {
        for (int i = 0; i < this.curPtr; ++i) {
            if (this.list[i] != o) continue;
            return true;
        }
        return false;
    }

    public Object elementAt(int index) {
        if (index >= 0 && index < this.list.length) {
            return this.list[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public int indexOf(Object o) {
        return this.indexOf(o, 0);
    }

    public int indexOf(Object o, int start) {
        for (int i = start; i < this.curPtr; ++i) {
            Object c = this.list[i];
            if (c == o) {
                return i;
            }
            if (c == null || !c.equals(o)) continue;
            return i;
        }
        return -1;
    }

    public void removeElement(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.removeElementAt(index);
        }
    }

    public Object lastElement() {
        if (this.curPtr > 0) {
            return this.list[this.curPtr - 1];
        }
        throw new NoSuchElementException();
    }

    public Object removeLastElement() {
        if (this.curPtr > 0) {
            return this.list[--this.curPtr];
        }
        throw new NoSuchElementException();
    }

    public void setElementAt(Object o, int index) {
        if (index < 0 || index >= this.list.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.list[index] = o;
    }

    public void removeElementAt(int index) {
        if (this.curPtr > 0 && index >= 0 && index < this.list.length) {
            if (index >= 0) {
                for (int i = index; i < this.curPtr; ++i) {
                    this.list[i] = this.list[i + 1];
                }
            }
            --this.curPtr;
        } else {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public void copyInto(Object[] o) {
        System.arraycopy(this.list, 0, o, 0, this.curPtr);
    }

    public int capacity() {
        return this.list.length;
    }

    public int size() {
        return this.curPtr;
    }

    public final boolean isEmpty() {
        return this.curPtr == 0;
    }

    public final void reset() {
        this.curPtr = 0;
    }

    public final void truncate(int newSize) {
        if (newSize >= 0 && newSize < this.curPtr) {
            this.curPtr = newSize;
        }
    }

    public Enumeration elements() {
        return new ListEnumerator(this);
    }

    public String[] getStrings() {
        Object[] s = new String[this.curPtr];
        this.copyInto(s);
        return s;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        for (int i = 0; i < this.curPtr; ++i) {
            if (i < this.curPtr - 1) {
                sb.append(this.list[i] + ", ");
                continue;
            }
            sb.append(this.list[i] == null ? "null" : this.list[i].toString());
        }
        sb.append("}");
        return sb.toString();
    }
}

