/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.app.log.JournalLogHandler;
import com.wm.app.log.JournalLogProducer;
import com.wm.app.log.impl.sc.LevelTranslator;
import com.wm.app.log.impl.sc.SCLogConsumer;
import com.wm.util.Config;
import com.wm.util.FacilityInfo;
import com.wm.util.Values;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Level;

public class JournalLogger {
    public static final int CRITICAL = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final int VERBOSE1 = 5;
    public static final int VERBOSE2 = 6;
    public static final int VERBOSE3 = 7;
    public static final int VERBOSE4 = 8;
    public static final int VERBOSE5 = 9;
    public static final int VERBOSE6 = 10;
    public static final int VERBOSE7 = 11;
    public static final int VERBOSE8 = 12;
    public static final int VERBOSE9 = 13;
    public static final int VERBOSE10 = 14;
    public static final int FAC_DEBUG = 0;
    public static final int FAC_LICENSE_MGR = 1;
    public static final int FAC_LDAP = 2;
    public static final int FAC_DATABASE_CON = 3;
    public static final int FAC_JDBC_CON = 4;
    public static final int FAC_B2BSVC = 5;
    public static final int FAC_SSL = 6;
    public static final int FAC_NIS = 8;
    public static final int FAC_CERTIFICATE = 9;
    public static final int FAC_PROXYRULE = 10;
    public static final int FAC_PROXY = 11;
    public static final int FAC_AUTHENTICATION = 12;
    public static final int FAC_CTHANDLER = 13;
    public static final int FAC_SERVERCORE = 14;
    public static final int FAC_SRVMGR = 15;
    public static final int FAC_CACHE = 16;
    public static final int FAC_OSTORE = 17;
    public static final int FAC_UTIL = 18;
    public static final int FAC_CACHEDISABLED = 19;
    public static final int FAC_CACHESMISS = 20;
    public static final int FAC_WIDLSRVMGR = 21;
    public static final int FAC_CODEGENERATOR = 22;
    public static final int FAC_TEMPLATELOADER = 23;
    public static final int FAC_USERMANAGER = 24;
    public static final int FAC_INITIALIZATION = 25;
    public static final int FAC_SERVICE = 26;
    public static final int FAC_SERVERCONFIG = 27;
    public static final int FAC_PACKAGE = 28;
    public static final int FAC_PACKAGEREPL = 29;
    public static final int FAC_NISUSERMGR = 30;
    public static final int FAC_MANIFEST = 31;
    public static final int FAC_STATEMGR = 32;
    public static final int FAC_CLUSTER = 33;
    public static final int FAC_ACL = 34;
    public static final int FAC_LOG = 35;
    public static final int FAC_CONTEXT = 36;
    public static final int FAC_TCONTEXT = 37;
    public static final int FAC_HTTPHDR = 38;
    public static final int FAC_HTTPREQ = 39;
    public static final int FAC_HTTPRSP = 40;
    public static final int FAC_HTTPCOOK = 41;
    public static final int FAC_XMLPARSER = 42;
    public static final int FAC_PARSESTREAM = 43;
    public static final int FAC_RMTLSTN = 44;
    public static final int FAC_HTTPLSTN = 46;
    public static final int FAC_HTTPSLSTN = 47;
    public static final int FAC_SRVLOG = 48;
    public static final int FAC_FLOWOP = 49;
    public static final int FAC_FLOWMAP = 50;
    public static final int FAC_PORTMGR = 51;
    public static final int FAC_CONNECTHNDLR = 52;
    public static final int FAC_HTTPDISPATCH = 53;
    public static final int FAC_HTTPDOCHNDLR = 54;
    public static final int FAC_JAVASERVICE = 55;
    public static final int FAC_MAILER = 56;
    public static final int FAC_SVCTHRD = 59;
    public static final int FAC_WEBTAP = 60;
    public static final int FAC_RMTSVR = 61;
    public static final int FAC_CORSVC = 62;
    public static final int FAC_TRXJOB = 63;
    public static final int FAC_NETSVC = 64;
    public static final int FAC_OBI = 65;
    public static final int FAC_VALHSH = 66;
    public static final int FAC_REPOSITORY = 67;
    public static final int FAC_EMAIL = 68;
    public static final int FAC_CRON = 69;
    public static final int FAC_LISTENER = 70;
    public static final int FAC_FTPLSTN = 71;
    public static final int FAC_REPORTER = 72;
    public static final int FAC_GATEWAY_MGR = 73;
    public static final int FAC_XTN_MGR = 74;
    public static final int FAC_DB = 75;
    public static final int FAC_CODER = 76;
    public static final int FAC_WMUTIL = 77;
    public static final int FAC_PRXHDL = 78;
    public static final int FAC_REVINV = 79;
    public static final int FAC_CONAPI = 80;
    public static final int FAC_NS = 81;
    public static final int FAC_XMLSCHEMA = 82;
    public static final int FAC_XQL = 83;
    public static final int FAC_ACCESS = 84;
    public static final int FAC_WMROOT = 85;
    public static final int FAC_WMPUBLIC = 86;
    public static final int FAC_WMWIN32 = 87;
    public static final int FAC_SOAP = 88;
    public static final int FAC_QUEUE = 89;
    public static final int FAC_FLOW_SVC = 90;
    public static final int FAC_ADMIN = 91;
    public static final int FAC_WSDL = 92;
    public static final int FAC_ISM = 93;
    public static final int FAC_REPOV4 = 94;
    public static final int FAC_AUDITLOG = 95;
    public static final int FAC_JDBCMGR = 96;
    public static final int FAC_BROKER_SYNC = 97;
    public static final int FAC_DISPATCHER = 98;
    public static final int FAC_BRKTRANSPORT = 99;
    public static final int FAC_WEBCONTAINER = 100;
    public static final int FAC_PRT_STATUS = 101;
    public static final int FAC_PRT = 101;
    public static final int FAC_XREF = 105;
    public static final int FAC_JOINMANAGER = 106;
    public static final int FAC_BROKER_TYPE_CODER = 107;
    public static final int FAC_PKI = 108;
    public static final int FAC_STATS = 109;
    public static final int FAC_ART_MBEAN = 113;
    public static final int FAC_ART = 114;
    public static final int FAC_ART_LISTENER = 115;
    public static final int FAC_ART_NOTIFICATION = 116;
    public static final int FAC_ART_ADAPTERSVC = 117;
    public static final int FAC_ART_CONNECTION = 118;
    public static final int FAC_MONITOR = 119;
    public static final int FAC_MONITOR_DB = 120;
    public static final int FAC_SCC_TM = 121;
    public static final int FAC_JBOSS = 122;
    public static final int FAC_BAS_FSDATA = 123;
    public static final int FAC_XSD_MAPPER = 124;
    public static final int FAC_CONTROL = 125;
    public static final int FAC_SCC_CM = 126;
    public static final int FAC_BAS_TS = 127;
    public static final int FAC_IDR = 128;
    public static final int FAC_NET = 129;
    public static final int FAC_MAINFRAME = 130;
    public static final int FAC_DIAGNOSTIC = 131;
    public static final int FAC_VCS = 132;
    public static final int FAC_DOM = 133;
    public static final int FAC_JMS = 134;
    public static final int FAC_JNDI = 135;
    public static final int FAC_TSPACE = 136;
    public static final int FAC_SCHED = 137;
    public static final int FAC_AP = 138;
    public static final int LOG_MSG = 9999;
    public static final int LOG_EXCEPTION = 9998;
    public static final String LOGGER_ROOT_PREFIX = "IS";
    public static final String LOGGER_SERVER_PREFIX = "SERVER";
    public static Hashtable<String, String> components = null;
    public static Hashtable<String, Hashtable> comp_facs = null;
    public static Hashtable<String, String> comp_bundles = null;
    public static File _configDir = null;
    public static final String DEFAULT_LOGLEVEL = "INFO";
    private static JournalLogProducer _logPro = null;
    private static JournalLogHandler _logHandler = null;
    private static String _level = "INFO";
    private static DateFormat _dateFormat = null;
    private static boolean initialized = false;
    private static SCLogConsumer _scLogConsumer = null;

    public static void init(JournalLogProducer logPro) {
        JournalLogger.init(logPro, null, null);
    }

    public static void init(JournalLogProducer logPro, JournalLogHandler logHandler, File configDir) {
        _logPro = logPro;
        _logHandler = logHandler;
        JournalLogger.initFacilities();
        JournalLogger.setDateFormat(System.getProperty("watt.server.dateStampFmt"));
        if (configDir != null) {
            _configDir = configDir;
        }
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void setSCLogConsumer(SCLogConsumer logCon) {
        _scLogConsumer = logCon;
    }

    public static String getComponentId(int facility) {
        return FacilityInfo.getComponentId(facility);
    }

    public static void log(int code, int facility, int severity, Object[] args) {
        if (_logPro == null) {
            return;
        }
        FacilityInfo f = FacilityInfo.lookup(facility);
        _logPro.logEntry(f.getBundleName(), f.getProductId(), facility, code, severity, null, args);
    }

    public static boolean isLogEnabled(int code, int facility, int severity) {
        if (_logPro == null) {
            return false;
        }
        FacilityInfo f = FacilityInfo.lookup(facility);
        return _logPro.anyListeners(f.getProductId(), facility, severity);
    }

    public static boolean isLogEnabled(int facility, int severity) {
        if (_logPro == null) {
            return false;
        }
        FacilityInfo f = FacilityInfo.lookup(facility);
        return _logPro.anyListeners(f.getProductId(), facility, severity);
    }

    public static void log(int code, int facility, int severity) {
        JournalLogger.log(code, facility, severity, null);
    }

    public static void log(int code, int facility, int severity, Object arg1) {
        JournalLogger.log(code, facility, severity, new Object[]{arg1});
    }

    public static void log(int code, int facility, int severity, Object arg1, Object arg2) {
        JournalLogger.log(code, facility, severity, new Object[]{arg1, arg2});
    }

    public static void log(int code, int facility) {
        JournalLogger.log(code, facility, 1, null);
    }

    public static void log(int code, int facility, Object[] args) {
        JournalLogger.log(code, facility, 1, args);
    }

    public static void log(int code, int facility, Object arg1) {
        JournalLogger.log(code, facility, 1, new Object[]{arg1});
    }

    public static void log(int code, int facility, Object arg1, Object arg2) {
        JournalLogger.log(code, facility, 1, new Object[]{arg1, arg2});
    }

    public static void logCritical(int code, int facility) {
        JournalLogger.log(code, facility, 0, null);
    }

    public static void logCritical(int code, int facility, Object[] args) {
        JournalLogger.log(code, facility, 0, args);
    }

    public static void logCritical(int code, int facility, Object arg1) {
        JournalLogger.log(code, facility, 0, new Object[]{arg1});
    }

    public static void logCritical(int code, int facility, Object arg1, Object arg2) {
        JournalLogger.log(code, facility, 0, new Object[]{arg1, arg2});
    }

    public static void logError(int code, int facility) {
        JournalLogger.log(code, facility, 1, null);
    }

    public static void logError(int code, int facility, Object[] args) {
        JournalLogger.log(code, facility, 1, args);
    }

    public static void logError(int code, int facility, Object arg1) {
        JournalLogger.log(code, facility, 1, new Object[]{arg1});
    }

    public static void logError(int code, int facility, Object arg1, Object arg2) {
        JournalLogger.log(code, facility, 1, new Object[]{arg1, arg2});
    }

    public static void logWarning(int code, int facility) {
        JournalLogger.log(code, facility, 2, null);
    }

    public static void logWarning(int code, int facility, Object[] args) {
        JournalLogger.log(code, facility, 2, args);
    }

    public static void logWarning(int code, int facility, Object arg1) {
        JournalLogger.log(code, facility, 2, new Object[]{arg1});
    }

    public static void logWarning(int code, int facility, Object arg1, Object arg2) {
        JournalLogger.log(code, facility, 2, new Object[]{arg1, arg2});
    }

    public static void logInfo(int code, int facility) {
        JournalLogger.log(code, facility, 3, null);
    }

    public static void logInfo(int code, int facility, Object[] args) {
        JournalLogger.log(code, facility, 3, args);
    }

    public static void logInfo(int code, int facility, Object arg1) {
        JournalLogger.log(code, facility, 3, new Object[]{arg1});
    }

    public static void logInfo(int code, int facility, Object arg1, Object arg2) {
        JournalLogger.log(code, facility, 3, new Object[]{arg1, arg2});
    }

    public static void logDebug(int code, int facility) {
        JournalLogger.log(code, facility, 4, null);
    }

    public static void logDebug(int code, int facility, Object[] args) {
        JournalLogger.log(code, facility, 4, args);
    }

    public static void logDebug(int code, int facility, Object arg1) {
        JournalLogger.log(code, facility, 4, new Object[]{arg1});
    }

    public static void logDebug(int code, int facility, Object arg1, Object arg2) {
        JournalLogger.log(code, facility, 4, new Object[]{arg1, arg2});
    }

    public static void logDebugPlus(int plus, int code, int facility) {
        JournalLogger.log(code, facility, 4 + plus, null);
    }

    public static void logDebugPlus(int plus, int code, int facility, Object[] args) {
        JournalLogger.log(code, facility, 4 + plus, args);
    }

    public static void logDebugPlus(int plus, int code, int facility, Object arg1) {
        JournalLogger.log(code, facility, 4 + plus, new Object[]{arg1});
    }

    public static void logDebugPlus(int plus, int code, int facility, Object arg1, Object arg2) {
        JournalLogger.log(code, facility, 4 + plus, new Object[]{arg1, arg2});
    }

    public static boolean isLogEnabledCritical(int code, int facility) {
        return JournalLogger.isLogEnabled(code, facility, 0);
    }

    public static boolean isLogEnabledError(int code, int facility) {
        return JournalLogger.isLogEnabled(code, facility, 1);
    }

    public static boolean isLogEnabledWarning(int code, int facility) {
        return JournalLogger.isLogEnabled(code, facility, 2);
    }

    public static boolean isLogEnabledDebug(int code, int facility) {
        return JournalLogger.isLogEnabled(code, facility, 4);
    }

    public static boolean isLogEnabledDebugPlus(int plus, int code, int facility) {
        return JournalLogger.isLogEnabled(code, facility, 4 + plus);
    }

    public static int getLevel() {
        int ret = _logHandler == null ? 0 : _logHandler.getFilterLevel();
        return ret;
    }

    public static void setSettings(Values in) {
        String datefmt = (String)in.get("watt.server.dateStampFmt");
        if (datefmt != null) {
            JournalLogger.setDateFormat(datefmt);
        }
        FacilityInfo.setSettings(in, _scLogConsumer);
    }

    public static void getSettings(Values in, Values serverSettings, Locale locale) {
        FacilityInfo.getSettings(in, serverSettings, locale);
    }

    public static void enableAllFacilities() {
        FacilityInfo.enableAllFacilities();
    }

    private static void enableFacilities(String[] saFacs) {
        Vector<Integer> v;
        String compId;
        int i;
        if (_logHandler == null) {
            return;
        }
        Hashtable<String, Vector<Integer>> h = new Hashtable<String, Vector<Integer>>();
        if (saFacs.length == 1 && saFacs[0].equals("999")) {
            FacilityInfo.enableAllFacilities();
            JournalLogger.removeISFilters();
            JournalLogger.addISFilters();
            return;
        }
        FacilityInfo.disableAllFacilities();
        for (i = 0; i < saFacs.length; ++i) {
            try {
                int fac = Integer.parseInt(saFacs[i]);
                if (!FacilityInfo.isValidCode(fac)) continue;
                FacilityInfo.enableFacility(fac);
                compId = JournalLogger.getComponentId(fac);
                v = (Vector)h.get(compId);
                if (v == null) {
                    v = new Vector<Integer>();
                    h.put(compId, v);
                }
                v.add(new Integer(fac));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        JournalLogger.removeISFilters();
        Enumeration enumvar = h.keys();
        while (enumvar.hasMoreElements()) {
            compId = (String)enumvar.nextElement();
            v = (Vector<Integer>)h.get(compId);
            int size = v.size();
            int[] ia = new int[size];
            for (i = 0; i < size; ++i) {
                ia[i] = (Integer)v.elementAt(i);
            }
            _logHandler.addFilterProductId(compId, ia);
        }
        if (saFacs.length == 0) {
            JournalLogger.addDummyISFilter();
        }
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < saFacs.length; ++i) {
            sb.append(saFacs[i]);
            sb.append(" ");
        }
        Config.setProperty("watt.debug2.facList", sb.toString());
    }

    private static void addISFilters() {
        ArrayList<String> prodIDs = new FacilityInfo().getISProductIDs();
        if (prodIDs != null) {
            for (String nextId : prodIDs) {
                _logHandler.addFilterProductId(nextId);
            }
        }
    }

    private static void removeISFilters() {
        ArrayList<String> prodIDs = new FacilityInfo().getISProductIDs();
        Hashtable h = _logHandler.getFilterProductIds();
        if (h != null) {
            Enumeration en = h.keys();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                if (!prodIDs.contains(s)) continue;
                _logHandler.removeFilterProductId(s);
            }
        }
    }

    private static void removeAllFilters() {
        Hashtable h = _logHandler.getFilterProductIds();
        if (h != null) {
            Enumeration en = h.keys();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                _logHandler.removeFilterProductId(s);
            }
        }
    }

    private static void addDummyISFilter() {
        _logHandler.addFilterProductId("ISS", new int[]{0});
    }

    public static void setLevel(int level) {
        if (_logHandler == null) {
            return;
        }
        _logHandler.setFilterLevel(level);
        _level = Integer.toString(level);
    }

    public static int getLogLevel(String optDebug) {
        int level;
        try {
            level = Integer.parseInt(optDebug);
        }
        catch (NumberFormatException e) {
            optDebug = JournalLogger.validateLogLevel(optDebug);
            if (optDebug == null) {
                optDebug = System.getProperty("watt.debug.level", Level.INFO.toString());
                if ((optDebug = JournalLogger.validateLogLevel(optDebug)) == null) {
                    optDebug = DEFAULT_LOGLEVEL;
                }
            }
            Level lvl = Level.toLevel((String)optDebug);
            level = LevelTranslator.findISLevelCode(lvl);
        }
        return level;
    }

    private static void initFacilities() {
        Vector<String> v = new Vector<String>();
        FacilityInfo.initFacilityDescriptions();
        String facs = System.getProperty("watt.debug2.facList", "");
        StringTokenizer st = new StringTokenizer(facs, ", ");
        while (st.hasMoreElements()) {
            String tok = (String)st.nextElement();
            v.add(tok);
        }
        String[] sa = new String[v.size()];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = (String)v.elementAt(i);
        }
        JournalLogger.enableFacilities(sa);
        if (_logHandler != null) {
            _level = Integer.toString(_logHandler.getFilterLevel());
        }
    }

    private static void setDateFormat(String sdf) {
        _dateFormat = sdf == null ? null : new SimpleDateFormat(sdf);
    }

    public static DateFormat getDateFormat() {
        return _dateFormat;
    }

    public static String getString(ResourceBundle bundle, int facility, int code, Object[] params) {
        StringBuffer key = new StringBuffer();
        key.append(facility).append('.').append(code);
        return JournalLogger.getString(bundle, key.toString(), params);
    }

    public static String getString(ResourceBundle bundle, String key, Object[] params) {
        try {
            if (bundle == null) {
                return key;
            }
            String msg = null;
            try {
                msg = bundle.getString(key);
            }
            catch (MissingResourceException mre) {
                return key;
            }
            if (msg == null) {
                return key;
            }
            if (params == null) {
                return msg;
            }
            MessageFormat mf = new MessageFormat(msg);
            mf.applyPattern(msg);
            return mf.format(params).toString();
        }
        catch (Exception e) {
            return key;
        }
    }

    public static int registerComponent(String componentCode, String componentDescription) {
        if (components == null) {
            components = new Hashtable();
        }
        if (components.get(componentCode) == null) {
            components.put(componentCode, componentDescription);
            return 1;
        }
        return 0;
    }

    public static int registerComponent(String componentCode, String componentDescription, String facilitiesBundle) {
        if (components == null) {
            components = new Hashtable();
        }
        if (components.get(componentCode) == null) {
            components.put(componentCode, componentDescription);
        }
        if (comp_bundles == null) {
            comp_bundles = new Hashtable();
        }
        if (comp_bundles.get(componentCode) == null) {
            comp_bundles.put(componentCode, facilitiesBundle);
            return 1;
        }
        return 0;
    }

    public static int registerFacility(String componentCode, String facCode, String facDescription) {
        Hashtable<String, String> facs;
        if (components == null || components.get(componentCode) == null) {
            return 0;
        }
        if (comp_facs == null) {
            comp_facs = new Hashtable();
        }
        if ((facs = comp_facs.get(componentCode)) == null) {
            facs = new Hashtable<String, String>();
            facs.put(facCode, facDescription);
            comp_facs.put(componentCode, facs);
        } else {
            facs.put(facCode, facDescription);
            comp_facs.put(componentCode, facs);
        }
        return 1;
    }

    public static Hashtable getComponents() {
        return components;
    }

    public static Hashtable getComponentFacilities() {
        return comp_facs;
    }

    public static Hashtable getComponentBundles() {
        return comp_bundles;
    }

    private static String validateLogLevel(String logLevel) {
        if ((logLevel = logLevel.toUpperCase()) == null || logLevel.length() == 0) {
            return DEFAULT_LOGLEVEL;
        }
        if (logLevel.equals("OFF") || logLevel.equals("FATAL") || logLevel.equals("ERROR") || logLevel.equals("WARN") || logLevel.equals(DEFAULT_LOGLEVEL) || logLevel.equals("DEBUG") || logLevel.equals("TRACE")) {
            return logLevel;
        }
        if (logLevel.equals("WARNING")) {
            return "WARN";
        }
        return null;
    }
}

