/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.List;
import com.wm.util.Values;
import java.util.Enumeration;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;

public class JNDIReaderWriter {
    protected Values attribNames = null;

    public void returnAttribute(String name) {
        if (this.attribNames == null) {
            this.attribNames = new Values();
        }
        this.attribNames.put(name, name);
    }

    public void returnAttributes(String[] attribs) {
        this.attribNames = null;
        if (attribs != null) {
            for (int i = 0; i < attribs.length; ++i) {
                this.returnAttribute(attribs[i]);
            }
        }
    }

    public String[] getAttributes() {
        return this.attribNames == null ? null : this.attribNames.getValueKeys();
    }

    public void ignoreAttribute(String name) {
        if (this.attribNames != null) {
            this.attribNames.remove(name);
        }
    }

    public void removeAllAttributes() {
        this.attribNames = null;
    }

    public Values read(DirContext ctx) {
        Values v = null;
        if (ctx != null) {
            try {
                Attributes attribs = ctx.getAttributes("");
                v = this.read(attribs);
            }
            catch (NamingException e) {
                v = new Values();
                v.put("$error", e.getMessage());
                v.put("$errorType", e.getClass().getName());
            }
        }
        return v;
    }

    public Values read(Attributes attribs) {
        Values v = null;
        if (attribs != null) {
            try {
                if (this.attribNames == null) {
                    v = JNDIReaderWriter.valuesFromAttributes(attribs);
                } else {
                    v = new Values();
                    Enumeration enumvar = this.attribNames.keys();
                    while (enumvar.hasMoreElements()) {
                        String name = (String)enumvar.nextElement();
                        Attribute a = attribs.get(name);
                        v.put(name, JNDIReaderWriter.objectFromAttribute(a));
                    }
                }
            }
            catch (NamingException e) {
                v.put("$error", e.getMessage());
                v.put("$errorType", e.getClass().getName());
            }
        }
        return v;
    }

    public Values[] readAttributes(Enumeration enumvar) {
        Object[] output = null;
        if (enumvar != null) {
            try {
                List l = new List();
                while (enumvar.hasMoreElements()) {
                    Values v = null;
                    SearchResult sr = (SearchResult)enumvar.nextElement();
                    Object o = sr.getObject();
                    if (o != null && o instanceof DirContext) {
                        DirContext dc = (DirContext)o;
                        v = this.read(dc);
                    } else {
                        Attributes attribs = sr.getAttributes();
                        v = this.read(attribs);
                    }
                    v.put("$name", sr.getName());
                    l.addElement(v);
                }
                if (l.size() > 0) {
                    output = new Values[l.size()];
                    l.copyInto(output);
                }
            }
            catch (Exception e) {
                output = new Values[]{new Values()};
                output[0].put("$error", e.getMessage());
                ((Values)output[0]).put("$errorType", e.getClass().getName());
            }
        }
        return output;
    }

    public Object[] readObjects(Enumeration enumvar) {
        Object[] o = null;
        if (enumvar != null) {
            try {
                List l = new List();
                while (enumvar.hasMoreElements()) {
                    SearchResult sr = (SearchResult)enumvar.nextElement();
                    l.addElement(sr.getObject());
                }
                if (l.size() > 0) {
                    o = new Object[l.size()];
                    l.copyInto(o);
                }
            }
            catch (Exception e) {
                o = new Values[]{new Values()};
                o[0].put("$error", e.getMessage());
                ((Values)o[0]).put("$errorType", e.getClass().getName());
            }
        }
        return o;
    }

    public Values[] read(Enumeration enumvar) {
        Object[] output = null;
        List list = new List();
        if (enumvar != null) {
            try {
                while (enumvar.hasMoreElements()) {
                    SearchResult sr = (SearchResult)enumvar.nextElement();
                    Attributes attribs = sr.getAttributes();
                    Object o = sr.getObject();
                    Values v = this.read(attribs);
                    v.put("$name", sr.getName());
                    if (o != null) {
                        v.put("$object", o);
                    }
                    list.addElement(v);
                }
                if (list.size() > 0) {
                    output = new Values[list.size()];
                    list.copyInto(output);
                }
            }
            catch (Exception e) {
                output = new Values[]{new Values()};
                ((Values)output[0]).put("$error", e.getMessage());
                ((Values)output[0]).put("$errorType", e.getClass().getName());
            }
        }
        return output;
    }

    public Values write(DirContext ctx, String name, Object obj) {
        return this.write(ctx, name, obj, null);
    }

    public Values write(DirContext ctx, String name, Object obj, Attributes a) {
        Values v = null;
        try {
            boolean overwrite = true;
            try {
                ctx.lookup(name);
            }
            catch (Throwable t) {
                overwrite = true;
            }
            if (overwrite) {
                ctx.rebind(name, obj, a);
            } else {
                ctx.bind(name, obj, a);
            }
        }
        catch (NamingException e) {
            v = new Values();
            v.put("$error", e.getMessage());
            v.put("$errorType", e.getClass().getName());
        }
        return v;
    }

    public static Object objectFromAttribute(Attribute a) throws NamingException {
        NamingEnumeration<?> ne;
        Object o = null;
        if (a != null && (ne = a.getAll()).hasMore()) {
            Object first = ne.next();
            boolean bytes = first instanceof byte[];
            List l = new List();
            l.addElement(first);
            while (ne.hasMore()) {
                l.addElement(ne.next());
            }
            if (l.size() == 1) {
                return first;
            }
            if (bytes) {
                byte[][] out = new byte[l.size()][];
                l.copyInto((Object[])out);
                o = out;
            } else {
                Object[] out = new String[l.size()];
                l.copyInto(out);
                o = out;
            }
        }
        return o;
    }

    public static Values valuesFromAttributes(Attributes attribs) throws NamingException {
        Values v = null;
        if (attribs != null) {
            v = new Values();
            NamingEnumeration<String> enumvar = attribs.getIDs();
            while (enumvar.hasMoreElements()) {
                String name = (String)enumvar.nextElement();
                Attribute a = attribs.get(name);
                v.put(name, JNDIReaderWriter.objectFromAttribute(a));
            }
        }
        return v;
    }
}

