/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.IntegerListEnumerator;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IntegerList
implements Serializable {
    int[] list;
    int curPtr = 0;

    public IntegerList() {
        this(10);
    }

    public IntegerList(int size) {
        this.list = new int[size];
    }

    public IntegerList(int[] o) {
        if (o != null) {
            for (int i = 0; i < o.length; ++i) {
                this.addInteger(o[i]);
            }
        }
    }

    public IntegerList(Enumeration e) {
        this();
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            this.addInteger((Integer)e.nextElement());
        }
    }

    public void addInteger(int o) {
        this.list[this.curPtr++] = o;
        if (this.curPtr >= this.list.length) {
            int[] newlist = new int[this.list.length * 2];
            System.arraycopy(this.list, 0, newlist, 0, this.list.length);
            this.list = newlist;
        }
    }

    public int integerAt(int index) {
        if (index >= 0 && index < this.list.length) {
            return this.list[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public int indexOf(int o) {
        return this.indexOf(o, 0);
    }

    public int indexOf(int o, int start) {
        for (int i = start; i < this.curPtr; ++i) {
            if (this.list[i] != o) continue;
            return i;
        }
        return -1;
    }

    public void removeInteger(int o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.removeIntegerAt(index);
        }
    }

    public int lastInteger() {
        if (this.curPtr > 0) {
            return this.list[this.curPtr - 1];
        }
        throw new NoSuchElementException();
    }

    public void setIntegerAt(int o, int index) {
        if (index < 0 || index >= this.list.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.list[index] = o;
    }

    public void removeIntegerAt(int index) {
        if (this.curPtr > 0 && index >= 0 && index < this.list.length) {
            if (index >= 0) {
                for (int i = index; i < this.curPtr; ++i) {
                    this.list[i] = this.list[i + 1];
                }
            }
            --this.curPtr;
        } else {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public void copyInto(int[] o) {
        System.arraycopy(this.list, 0, o, 0, this.curPtr);
    }

    public int size() {
        return this.curPtr;
    }

    public final boolean isEmpty() {
        return this.curPtr == 0;
    }

    public final void reset() {
        this.curPtr = 0;
    }

    public Enumeration elements() {
        return new IntegerListEnumerator(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        for (int i = 0; i < this.curPtr; ++i) {
            if (i < this.curPtr - 1) {
                sb.append(this.list[i] + ", ");
                continue;
            }
            sb.append("" + this.list[i]);
        }
        sb.append("}");
        return sb.toString();
    }
}

