/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataSharedCursor;
import com.wm.data.IDataTreeCursor;
import com.wm.data.IDataUtil;
import com.wm.data.ValuesEmulator;
import com.wm.util.coder.IDataBinCoder;
import com.wm.util.coder.IDataCoder;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

public class IDataRegistry
implements IData {
    Exception error;
    File registryFile;
    IDataCoder coder;
    IData idata;

    public IDataRegistry(String filename, IDataCoder coder) {
        this(new File(filename), coder);
    }

    public IDataRegistry(File file, IDataCoder coder) {
        this.registryFile = file;
        this.init(coder);
    }

    private void init(IDataCoder coder) {
        this.idata = IDataFactory.create();
        this.coder = coder;
        this.error = null;
        if (!this.registryFile.exists()) {
            File parent = new File(this.registryFile.getParent());
            if (!parent.exists()) {
                parent.mkdirs();
            }
            this.writeToFile();
        } else {
            this.readFromFile();
        }
    }

    public synchronized Object removeWithWrite(String key) {
        Object o = ValuesEmulator.remove(this.idata, key);
        this.writeToFile();
        return o;
    }

    public synchronized Object putWithWrite(String k, Object value) {
        Object o = ValuesEmulator.put(this.idata, k, value);
        this.writeToFile();
        return o;
    }

    public final synchronized boolean readFromFile() {
        try {
            IData idata = this.coder.readFromFile(this.registryFile);
            IDataUtil.copy(idata, this.idata);
            this.error = null;
            return true;
        }
        catch (IOException e) {
            this.error = e;
            return false;
        }
    }

    public final synchronized boolean writeToFile() {
        try {
            this.coder.writeToFile(this.registryFile, this.idata);
            this.error = null;
            return true;
        }
        catch (IOException e) {
            this.error = e;
            return false;
        }
    }

    public final synchronized Exception getError() {
        return this.error;
    }

    public IDataCursor getCursor() {
        return this.idata.getCursor();
    }

    public IDataIndexCursor getIndexCursor() {
        return this.idata.getIndexCursor();
    }

    public IDataHashCursor getHashCursor() {
        return this.idata.getHashCursor();
    }

    public IDataTreeCursor getTreeCursor() {
        return this.idata.getTreeCursor();
    }

    public IDataSharedCursor getSharedCursor() {
        return this.idata.getSharedCursor();
    }

    public Object get(String key) {
        return ValuesEmulator.get(this.idata, key);
    }

    public String getString(String key) {
        return ValuesEmulator.getString(this.idata, key);
    }

    public Object put(String key, Object value) {
        return ValuesEmulator.put(this.idata, key, value);
    }

    public Object remove(String key) {
        return ValuesEmulator.remove(this.idata, key);
    }

    public Enumeration keys() {
        return ValuesEmulator.keys(this.idata);
    }

    public int size() {
        return ValuesEmulator.size(this.idata);
    }

    public static void main(String[] args) {
        File regFile = new File(System.getProperty("user.dir") + File.separator + "idata.reg");
        IDataRegistry reg = new IDataRegistry(regFile, (IDataCoder)new IDataBinCoder());
        reg.put("1", "one");
        reg.put("2", "two");
        reg.put("3", "three");
        reg.writeToFile();
        reg.removeWithWrite("3");
        reg.readFromFile();
        System.out.println("1: " + reg.getString("1"));
        System.out.println("2: " + reg.getString("2"));
        String s = null;
        s = reg.getString("3");
        if (s != null) {
            System.out.println("removeWithWrite did not work: " + s);
        }
        System.out.println("Dont forget to remove idata.reg");
    }
}

