/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.ByteOutputBuffer;
import com.wm.util.LocalizedIOException;
import com.wm.util.Streams;
import com.wm.util.ZipManifest;
import com.wm.util.ZipManifestEntry;
import com.wm.util.resources.UtilExceptionBundle;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Files {
    public static boolean isChildOf(File root, File child) {
        try {
            return child.getCanonicalPath().startsWith(root.getCanonicalPath());
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] img = null;
        try {
            img = Streams.readFully(fis);
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
        return img;
    }

    public static void write(File file, byte[] data) throws IOException {
        if (data != null) {
            FileOutputStream w = new FileOutputStream(file);
            ((OutputStream)w).write(data);
            w.flush();
            ((OutputStream)w).close();
        }
    }

    public static void append(File file, byte[] data) throws IOException {
        if (data != null) {
            FileOutputStream w = new FileOutputStream(file.getAbsolutePath(), true);
            ((OutputStream)w).write(data);
            w.flush();
            ((OutputStream)w).close();
        }
    }

    public static void backup(File trg) throws IOException {
        if (trg == null) {
            return;
        }
        if (!trg.exists()) {
            return;
        }
        String parent = trg.getParent();
        String oldname = trg.getName();
        String newname = oldname + ".bak";
        File bak = new File(parent, newname);
        Files.backup(bak);
        Files.copy(trg, bak);
    }

    public static boolean copy(File src, File dst) throws IOException {
        boolean dirs = src.isDirectory();
        if (dst.exists() && dirs != dst.isDirectory()) {
            return false;
        }
        if (dirs) {
            if (!dst.exists()) {
                dst.mkdirs();
            }
            String[] files = src.list();
            for (int i = 0; i < files.length; ++i) {
                File src1 = new File(src, files[i]);
                File dst1 = new File(dst, files[i]);
                Files.copy(src1, dst1);
            }
        } else {
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            Streams.pipe(in, out, 8192, -1, false);
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        return true;
    }

    public static boolean rmrf(File root) {
        String[] f;
        if (!root.exists()) {
            return false;
        }
        if (root.isDirectory() && (f = root.list()) != null && f.length > 0) {
            for (int i = 0; i < f.length; ++i) {
                if (Files.rmrf(new File(root, f[i]))) continue;
                return false;
            }
        }
        return root.delete();
    }

    public static void unzip(InputStream zipStream, File destDir) throws IOException {
        ZipEntry e;
        destDir.mkdirs();
        ZipInputStream zi = new ZipInputStream(zipStream);
        while ((e = zi.getNextEntry()) != null) {
            File pf;
            File f = new File(destDir, e.getName().replace('/', File.separatorChar));
            if (e.isDirectory()) {
                f.mkdir();
                continue;
            }
            String p = f.getParent();
            if (p != null && !(pf = new File(p)).exists()) {
                pf.mkdirs();
            }
            ByteOutputBuffer bob = new ByteOutputBuffer();
            byte[] b = new byte[1024];
            int read = 0;
            while ((read = zi.read(b, 0, b.length)) > 0) {
                bob.write(b, 0, read);
            }
            Files.write(f, bob.toByteArray());
        }
        zi.close();
    }

    public static void zip(File src, String base, boolean compress, OutputStream output, FilenameFilter filter) throws IOException {
        ZipManifest manifest = new ZipManifest();
        if (!src.exists()) {
            throw new LocalizedIOException(UtilExceptionBundle.class, UtilExceptionBundle.FILE_IO_DIR, "");
        }
        if (!src.isDirectory()) {
            throw new LocalizedIOException(UtilExceptionBundle.class, UtilExceptionBundle.FILE_IO_FILE, "");
        }
        ZipOutputStream zo = new ZipOutputStream(output);
        if (compress) {
            zo.setMethod(8);
        } else {
            zo.setMethod(0);
        }
        String[] list = src.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                Files.zipAdd(new File(src.getAbsolutePath() + File.separator + list[i]), base, manifest, filter);
            }
        }
        manifest.writeToZip(zo);
        zo.close();
    }

    private static void zipAdd(File file, String base, ZipManifest manifest, FilenameFilter filter) throws IOException {
        ZipEntry ze;
        String bname;
        ZipManifestEntry me = new ZipManifestEntry();
        CRC32 crc = new CRC32();
        String name = file.getName();
        String parent = file.getParent();
        String string = bname = base != null ? base + File.separator : "";
        if (filter != null && !filter.accept(parent != null ? new File(parent) : null, name)) {
            return;
        }
        if (file.isDirectory()) {
            bname = bname + name;
            String[] list = file.list();
            ze = new ZipEntry(bname.replace('\\', '/') + "/");
            ze.setSize(0L);
            ze.setCrc(0L);
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    File nf = new File(file.getAbsolutePath() + File.separator + list[i]);
                    Files.zipAdd(nf, bname, manifest, filter);
                }
            }
        } else {
            ze = new ZipEntry(bname.replace('\\', '/') + name);
            ze.setSize(file.length());
            FileInputStream fi = new FileInputStream(file);
            DataInputStream da = new DataInputStream(fi);
            byte[] data = new byte[(int)file.length()];
            da.readFully(data);
            fi.close();
            crc.update(data);
            ze.setCrc(crc.getValue());
            me.setData(data);
        }
        me.setEntry(ze);
        manifest.addEntry(me);
    }
}

