/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.Files;
import com.wm.util.List;
import com.wm.util.Streams;
import com.wm.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static boolean isFileSystemCaseSensitive = false;

    public static void main(String[] args) {
        System.out.println("casesensitive=" + isFileSystemCaseSensitive);
    }

    public Hashtable getDirectoryContents(File dir) {
        return this.getDirectoryContents(null, null, dir);
    }

    public Hashtable getDirectoryContents(Hashtable h, String pathinfo, File dir) {
        if (h == null) {
            h = new Hashtable<String, Object[]>(11);
        } else {
            pathinfo = pathinfo == null ? dir.getName() : Strings.cat(pathinfo, "/", dir.getName());
        }
        List wrklst = new List();
        String[] files = dir.list();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File infile = new File(dir, files[i]);
                wrklst.addElement(infile);
                if (infile.isFile()) continue;
                this.getDirectoryContents(h, pathinfo, infile);
            }
            if (!wrklst.isEmpty()) {
                Object[] items = new File[wrklst.size()];
                wrklst.copyInto(items);
                if (pathinfo == null) {
                    pathinfo = "";
                }
                h.put(pathinfo, items);
            }
        }
        return h;
    }

    public byte[] createZipByteArray(File dir) throws IOException {
        return this.createZipByteArray(dir, null, null);
    }

    public byte[] createZipByteArray(File dir, String filteropt, String[] filter) throws IOException {
        boolean include = false;
        boolean includeall = true;
        if (filteropt != null && filteropt.equalsIgnoreCase("include")) {
            include = true;
            includeall = false;
        } else if (filteropt != null && filteropt.equalsIgnoreCase("exclude")) {
            includeall = false;
        }
        Hashtable ziplist = this.getDirectoryContents(dir);
        if (ziplist != null && !ziplist.isEmpty()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(bos);
            Enumeration en = ziplist.keys();
            while (en.hasMoreElements()) {
                String pathinfo = (String)en.nextElement();
                File[] files = (File[])ziplist.get(pathinfo);
                for (int i = 0; i < files.length; ++i) {
                    boolean addFile = true;
                    String zeid = pathinfo.equals("") ? (!files[i].isDirectory() ? files[i].getName() : files[i].getName() + "/") : (!files[i].isDirectory() ? pathinfo + "/" + files[i].getName() : pathinfo + "/" + files[i].getName() + "/");
                    if (!includeall && filter != null) {
                        boolean hit = false;
                        for (int j = 0; j < filter.length; ++j) {
                            if (!zeid.equalsIgnoreCase(filter[j])) continue;
                            hit = true;
                            break;
                        }
                        if (hit && include) {
                            addFile = true;
                        } else if (hit && !include) {
                            addFile = false;
                        } else if (!hit && include) {
                            addFile = false;
                        } else if (!hit && !include) {
                            addFile = true;
                        }
                    }
                    if (!addFile) continue;
                    ZipEntry ze = new ZipEntry(zeid);
                    zos.putNextEntry(ze);
                    if (!files[i].isDirectory()) {
                        byte[] filedata = this.readFile(files[i]);
                        zos.write(filedata, 0, filedata.length);
                    }
                    zos.closeEntry();
                }
            }
            zos.close();
            bos.close();
            return bos.toByteArray();
        }
        return null;
    }

    public void createZip(File dir, String filteropt, String[] filter, File dest) throws IOException {
        boolean include = false;
        boolean includeall = true;
        if (filteropt != null && filteropt.equalsIgnoreCase("include")) {
            include = true;
            includeall = false;
        } else if (filteropt != null && filteropt.equalsIgnoreCase("exclude")) {
            includeall = false;
        } else if (filteropt != null && filteropt.equalsIgnoreCase("includeall")) {
            includeall = true;
        }
        Hashtable ziplist = this.getDirectoryContents(dir);
        if (ziplist != null && !ziplist.isEmpty()) {
            FileOutputStream fos = new FileOutputStream(dest);
            ZipOutputStream zos = new ZipOutputStream(fos);
            Enumeration en = ziplist.keys();
            while (en.hasMoreElements()) {
                String pathinfo = (String)en.nextElement();
                File[] files = (File[])ziplist.get(pathinfo);
                for (int i = 0; i < files.length; ++i) {
                    boolean addFile = true;
                    String zeid = pathinfo.equals("") ? (!files[i].isDirectory() ? files[i].getName() : files[i].getName() + "/") : (!files[i].isDirectory() ? pathinfo + "/" + files[i].getName() : pathinfo + "/" + files[i].getName() + "/");
                    if (!includeall && filter != null) {
                        boolean hit = false;
                        for (int j = 0; j < filter.length; ++j) {
                            if (!zeid.equalsIgnoreCase(filter[j])) continue;
                            hit = true;
                            break;
                        }
                        if (hit && include) {
                            addFile = true;
                        } else if (hit && !include) {
                            addFile = false;
                        } else if (!hit && include) {
                            addFile = false;
                        } else if (!hit && !include) {
                            addFile = true;
                        }
                    }
                    if (!addFile) continue;
                    ZipEntry ze = new ZipEntry(zeid);
                    zos.putNextEntry(ze);
                    if (!files[i].isDirectory()) {
                        FileInputStream fis = new FileInputStream(files[i]);
                        byte[] b = new byte[4096];
                        int read = 0;
                        while ((read = fis.read(b, 0, b.length)) > 0) {
                            zos.write(b, 0, read);
                        }
                        fis.close();
                    }
                    zos.closeEntry();
                }
            }
            fos.flush();
            zos.close();
            fos.close();
        }
    }

    public byte[] readBytes(InputStream is, long size) throws IOException {
        return Streams.readBytes(is, size);
    }

    public byte[] readFile(File f) throws IOException {
        return Files.readFully(f);
    }

    public void writeFile(File f, byte[] data) throws IOException {
        Files.write(f, data);
    }

    public static boolean copyTo(File src, File dst) throws IOException {
        return Files.copy(src, dst);
    }

    public static void backup(File trg) throws IOException {
        Files.backup(trg);
    }

    public static boolean rmDir(File d) throws IOException {
        return Files.rmrf(d);
    }

    public static boolean rmDir(File d, boolean b) throws IOException {
        if (d == null) {
            return false;
        }
        if (!b) {
            return d.delete();
        }
        String[] l = d.list();
        if (l != null) {
            for (int i = 0; i < l.length; ++i) {
                FileUtil.rmDir(new File(d, l[i]), true);
            }
        }
        return d.delete();
    }

    static {
        try {
            String time = String.valueOf(System.currentTimeMillis());
            String testFile = "btwob" + time.substring(time.length() - 3) + ".tst";
            File temp = new File(testFile);
            if (!temp.exists()) {
                RandomAccessFile raf = new RandomAccessFile(testFile, "rw");
                File caseTest = new File(testFile.toUpperCase());
                isFileSystemCaseSensitive = !caseTest.exists();
                raf.close();
                temp.delete();
                raf = null;
                temp = null;
                caseTest = null;
            }
            testFile = null;
            time = null;
        }
        catch (Exception e) {
            System.out.println("Exception in the static initializer of FileUTil" + e);
        }
    }
}

