/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.FastHashEntry;
import com.wm.util.FastHashEnumerator;
import java.util.Enumeration;

public class FastHash
implements Cloneable {
    transient FastHashEntry[] table;
    transient int count;
    int threshold;
    float loadFactor;

    public FastHash(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new FastHashEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public FastHash(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public FastHash() {
        this(101, 0.75f);
    }

    public FastHash(Object[] o) {
        int len = o != null ? o.length : 0;
        this.loadFactor = 1.0f;
        this.table = new FastHashEntry[len];
        this.threshold = len;
        if (o != null) {
            for (int i = 0; i < o.length; ++i) {
                this.put(o[i], null);
            }
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new FastHashEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new FastHashEnumerator(this.table, false);
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        FastHashEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            FastHashEntry e = tab[i];
            while (e != null) {
                if (this.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        FastHashEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && this.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object findEntry(String name, int hash) {
        FastHashEntry[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && this.equals(e.key.toString(), name)) {
                return e.key;
            }
            e = e.next;
        }
        return null;
    }

    public Object get(Object key) {
        FastHashEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && this.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        FastHashEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && this.equals(e.key, key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        tab[index] = e = new FastHashEntry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public Object remove(Object key) {
        FastHashEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashEntry e = tab[index];
        FastHashEntry prev = null;
        while (e != null) {
            if (e.hash == hash && this.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        FastHashEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            FastHash t = (FastHash)super.clone();
            t.table = new FastHashEntry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (FastHashEntry)this.table[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected boolean equals(Object rhs, Object lhs) {
        return rhs.equals(lhs);
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        Object o1 = null;
        Object o2 = null;
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            o1 = k.nextElement();
            o2 = e.nextElement();
            buf.append(o1 != null ? o1.toString() : "null");
            buf.append('=');
            buf.append(o2 != null ? o2.toString() : "null");
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }
}

