/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.app.log.IFacilityInfo;
import com.wm.app.log.impl.sc.SCLogConsumer;
import com.wm.data.ValuesEmulator;
import com.wm.util.JournalLogger;
import com.wm.util.Strings;
import com.wm.util.Values;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacilityInfo
implements IFacilityInfo {
    private static final String FAC_DESC_BUNDLE_NAME = "com.wm.util.resources.FacilitiesBundle";
    private static final DecimalFormat MAJOR_FMT = new DecimalFormat("0000");
    private static final String CORE_BUNDLE_NAME = "com.wm.resources.B2BCoreMsgBundle";
    private static final String SERVER_BUNDLE_NAME = "com.wm.resources.B2BServMsgBundle";
    private static final String LDAP_BUNDLE_NAME = "com.wm.app.b2b.server.ldap.resources.LDAPBundle";
    private static final String ROOT_BUNDLE_NAME = "com.wm.resources.WmRootMsgBundle";
    private static final String DEPR_BUNDLE_NAME = "com.wm.resources.B2BDeprMsgBundle";
    private static final String PARTNER_BUNDLE_NAME = "com.wm.resources.WmPartnersMsgBundle";
    private static final String WIN32_BUNDLE_NAME = "com.wm.resources.WmWin32MsgBundle";
    private static final String PUB_BUNDLE_NAME = "com.wm.resources.WmPublicMsgBundle";
    private static final String PRT_BUNDLE_NAME = "com.wm.app.prt.resources.PRTMessageBundle";
    private static final String PKI_BUNDLE_NAME = "com.wm.resources.PKIMsgBundle";
    private static final String OMI_ART_BUNDLE_NAME = "omi.wm.art.resources.ARTMbeanBundle";
    private static final String ART_BUNDLE_NAME = "com.wm.pkg.art.i18n.resources.AdapterRuntimeResourceBundle";
    private static final String PM_BUNDLE_NAME = "com.wm.monitor.util.PMMessages";
    private static final String DB_BUNDLE_NAME = "com.wm.monitor.util.DBMessages";
    private static final String JCA_BUNDLE_NAME = "com.wm.app.b2b.server.jca.transactions.resources.TranLogBundle";
    private static final String FSDATA_BUNDLE_NAME = "com.wm.driver.data.fs.resource.FSDataLogMsgs";
    private static final String CONN_BUNDLE_NAME = "com.wm.app.b2b.server.jca.resources.WmConnectionBundle";
    private static final String TSLOG_BUNDLE_NAME = "com.wm.app.store.resources.TSLogMsgs";
    private static final String DOTNET_BUNDLE_NAME = "com.wm.dotnet.pkg.resources.PackageBundle";
    private static final String MAINFRAME_BUNDLE_NAME = "com.wm.pkg.mainframe.resources.PackageBundle";
    private static final String VCS_BUNDLE_NAME = "com.webmethods.vcs.resources.VCSMessageBundle";
    private static final String DOM_BUNDLE_NAME = "com.wm.dom.resources.DOMMessageBundle";
    private static final String JMS_BUNDLE_NAME = "com.wm.app.b2b.server.jms.resources.JMSBundle";
    private static final String JNDI_BUNDLE_NAME = "com.wm.app.b2b.server.jndi.resources.JNDIBundle";
    private static final String WEB_CONTAINER_BUNDLE_NAME = "com.wm.app.b2b.server.web.WebContainerBundle";
    private static final String SCHED_BUNDLE_NAME = "com.wm.app.b2b.server.scheduler.resources.SchedBundle";
    private static final String AP_BUNDLE_NAME = "com.webmethods.ap.resources.APMessageBundle";
    private static final FacilityInfo[] FAC_TABLE = new FacilityInfo[]{new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 0, "ISU"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 1, "ISS"), new FacilityInfo("com.wm.app.b2b.server.ldap.resources.LDAPBundle", 2, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 3, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 4, "ISS"), null, new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 6, "ISC"), null, new FacilityInfo("com.wm.resources.B2BServMsgBundle", 8, "ISS"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 9, "ISC"), null, new FacilityInfo("com.wm.resources.B2BServMsgBundle", 11, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 12, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 13, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 14, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 15, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 16, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 17, "ISS"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 18, "ISC"), null, null, new FacilityInfo("com.wm.resources.B2BServMsgBundle", 21, "ISS"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 22, "ISC"), null, new FacilityInfo("com.wm.resources.B2BServMsgBundle", 24, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 25, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 26, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 27, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 28, "ISS"), null, null, null, null, new FacilityInfo("com.wm.resources.B2BServMsgBundle", 33, "ISS"), null, new FacilityInfo("com.wm.resources.B2BServMsgBundle", 35, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 36, "ISS"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 37, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 38, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 39, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 40, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 41, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 42, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 43, "ISC"), null, null, new FacilityInfo("com.wm.resources.WmRootMsgBundle", 46, "ISP"), new FacilityInfo("com.wm.resources.WmRootMsgBundle", 47, "ISP"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 48, "ISS"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 49, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 50, "ISC"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 51, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 52, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 53, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 54, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 55, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 56, "ISS"), null, null, new FacilityInfo("com.wm.resources.B2BServMsgBundle", 59, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 60, "ISS"), new FacilityInfo("com.wm.resources.WmRootMsgBundle", 61, "ISP"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 62, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 63, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 64, "ISC"), null, new FacilityInfo("com.wm.resources.B2BDeprMsgBundle", 66, "ISC"), new FacilityInfo("com.wm.resources.B2BDeprMsgBundle", 67, "ISC"), new FacilityInfo("com.wm.resources.WmRootMsgBundle", 68, "ISP"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 69, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 70, "ISS"), new FacilityInfo("com.wm.resources.WmRootMsgBundle", 71, "ISP"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 72, "ISC"), new FacilityInfo("com.wm.resources.WmPartnersMsgBundle", 73, "ISP"), new FacilityInfo("com.wm.resources.WmPartnersMsgBundle", 74, "ISP"), new FacilityInfo("com.wm.resources.WmWin32MsgBundle", 75, "ISP"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 76, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 77, "ISC"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 78, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 79, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 80, "ISS"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 81, "ISC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 82, "ISC"), null, null, new FacilityInfo("com.wm.resources.WmRootMsgBundle", 85, "ISP"), null, new FacilityInfo("com.wm.resources.WmWin32MsgBundle", 87, "ISP"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 88, "ISC"), null, new FacilityInfo("com.wm.resources.WmPublicMsgBundle", 90, "ISP"), new FacilityInfo("com.wm.resources.WmRootMsgBundle", 91, "ISP"), null, null, new FacilityInfo("com.wm.resources.B2BServMsgBundle", 94, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 95, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 96, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 97, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 98, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 99, "ISS"), new FacilityInfo("com.wm.app.b2b.server.web.WebContainerBundle", 100, "ISS"), new FacilityInfo("com.wm.app.prt.resources.PRTMessageBundle", 101, "PRT"), null, null, null, new FacilityInfo("com.wm.resources.B2BServMsgBundle", 105, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 106, "ISS"), null, new FacilityInfo("com.wm.resources.PKIMsgBundle", 108, "ISP"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 109, "ISS"), null, null, null, new FacilityInfo("omi.wm.art.resources.ARTMbeanBundle", 113, "ART"), new FacilityInfo("com.wm.pkg.art.i18n.resources.AdapterRuntimeResourceBundle", 114, "ART"), new FacilityInfo("com.wm.pkg.art.i18n.resources.AdapterRuntimeResourceBundle", 115, "ART"), new FacilityInfo("com.wm.pkg.art.i18n.resources.AdapterRuntimeResourceBundle", 116, "ART"), new FacilityInfo("com.wm.pkg.art.i18n.resources.AdapterRuntimeResourceBundle", 117, "ART"), new FacilityInfo("com.wm.pkg.art.i18n.resources.AdapterRuntimeResourceBundle", 118, "ART"), new FacilityInfo("com.wm.monitor.util.PMMessages", 119, "MON"), new FacilityInfo("com.wm.monitor.util.DBMessages", 120, "MOD"), new FacilityInfo("com.wm.app.b2b.server.jca.transactions.resources.TranLogBundle", 121, "SCC"), new FacilityInfo("com.wm.resources.B2BCoreMsgBundle", 122, "JBS"), new FacilityInfo("com.wm.driver.data.fs.resource.FSDataLogMsgs", 123, "BAS"), null, new FacilityInfo("com.wm.resources.B2BServMsgBundle", 125, "ISS"), new FacilityInfo("com.wm.app.b2b.server.jca.resources.WmConnectionBundle", 126, "SCC"), new FacilityInfo("com.wm.app.store.resources.TSLogMsgs", 127, "BAT"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 128, "ISS"), new FacilityInfo("com.wm.dotnet.pkg.resources.PackageBundle", 129, "NET"), new FacilityInfo("com.wm.pkg.mainframe.resources.PackageBundle", 130, "MNP"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 131, "ISS"), new FacilityInfo("com.webmethods.vcs.resources.VCSMessageBundle", 132, "VCS"), new FacilityInfo("com.wm.dom.resources.DOMMessageBundle", 133, "ISC"), new FacilityInfo("com.wm.app.b2b.server.jms.resources.JMSBundle", 134, "ISS"), new FacilityInfo("com.wm.app.b2b.server.jndi.resources.JNDIBundle", 135, "ISS"), new FacilityInfo("com.wm.resources.B2BServMsgBundle", 136, "ISS"), new FacilityInfo("com.wm.app.b2b.server.scheduler.resources.SchedBundle", 137, "ISS"), new FacilityInfo("com.webmethods.ap.resources.APMessageBundle", 138, "ISS")};
    private static ArrayList<String> IS_PRODUCT_IDS = null;
    private static ArrayList<String> COMP_PRODUCT_IDS = null;
    private String bundle;
    private String prodId;
    private String loggerId;
    private String desc;
    private int facId;
    private boolean enabled;
    public String facilityStr;
    public String facilityDesc;
    public String facilityComp;
    public String facilityGroup;

    static void initIDs() {
        String[] IDs = new String[]{"ISS", "ISP", "ISU", "ISC", "PRT", "ART", "MON", "MOD", "SCC", "JBS", "BAS", "BAT", "VCS"};
        IS_PRODUCT_IDS = new ArrayList();
        for (String nextProd : IDs) {
            IS_PRODUCT_IDS.add(nextProd);
        }
        String[] CompIDs = new String[]{"BAA", "BAJ", "BAL", "BAP", "BAR", "BAU", "BAC", "BAB", "BAF", "BAQ", "BAS", "BAT"};
        COMP_PRODUCT_IDS = new ArrayList();
        for (String nextProd : CompIDs) {
            COMP_PRODUCT_IDS.add(nextProd);
        }
    }

    FacilityInfo(String facStr, String facDesc) {
        this.facilityStr = facStr;
        this.facilityDesc = facDesc;
        this.facilityComp = null;
        this.facilityGroup = null;
    }

    FacilityInfo(String facStr, String facDesc, String facGroup, String facComp) {
        this.facilityStr = facStr;
        this.facilityDesc = facDesc;
        this.facilityComp = facComp;
        this.facilityGroup = facGroup;
    }

    private FacilityInfo(String inBundleName, int inFacCode, String inProdId) {
        this.bundle = inBundleName;
        this.facId = inFacCode;
        this.prodId = inProdId;
        this.loggerId = this.assembleLoggerId(inProdId, inFacCode);
        this.desc = "";
        this.enabled = true;
    }

    public FacilityInfo() {
    }

    public String getBundleName() {
        return this.bundle;
    }

    public int getFacilityCode() {
        return this.facId;
    }

    public String getFacilityDescription() {
        return this.desc;
    }

    public String getProductId() {
        return this.prodId;
    }

    public String getLoggerId() {
        return this.loggerId;
    }

    @Override
    public String getLoggerId(int facility) {
        FacilityInfo facinfo = null;
        facinfo = facility >= FAC_TABLE.length ? FAC_TABLE[0] : FAC_TABLE[facility];
        return facinfo.getLoggerId();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private String assembleLoggerId(String inProdId, int inFacId) {
        StringBuilder buff = new StringBuilder("SERVER");
        buff.append(".");
        buff.append(inProdId);
        buff.append(".");
        buff.append(MAJOR_FMT.format(inFacId));
        return buff.toString();
    }

    public static String getComponentId(int facility) {
        return facility >= FAC_TABLE.length || FAC_TABLE[facility] == null ? "" : FacilityInfo.FAC_TABLE[facility].prodId;
    }

    static Values[] buildFacs(Locale locale) {
        ArrayList<Values> v = new ArrayList<Values>();
        v.add(FacilityInfo.buildISFacs(locale));
        Hashtable components = JournalLogger.getComponents();
        Hashtable comp_facs = JournalLogger.getComponentFacilities();
        comp_facs = FacilityInfo.buildCompFacs(comp_facs, locale);
        if (components != null && comp_facs != null) {
            Enumeration comp_keys = components.keys();
            Values component = null;
            String compCode = null;
            Hashtable facs = null;
            StringBuilder loggerPrefix = null;
            String facCode = null;
            while (comp_keys.hasMoreElements()) {
                compCode = (String)comp_keys.nextElement();
                facs = (Hashtable)comp_facs.get(compCode);
                if (facs == null) continue;
                loggerPrefix = new StringBuilder("IS");
                loggerPrefix.append(".");
                loggerPrefix.append(compCode);
                Level serverLvl = Logger.getLogger((String)loggerPrefix.toString()).getLevel();
                if (serverLvl == null && (serverLvl = Logger.getLogger((String)"IS").getLevel()) == null) {
                    serverLvl = Logger.getRootLogger().getLevel();
                }
                component = new Values();
                component.put("CompCode", compCode);
                component.put("CompDesc", (String)components.get(compCode));
                component.put("Threshold", FacilityInfo.formatLevelString(serverLvl.toString()));
                Enumeration keys = facs.keys();
                ArrayList<Values> v2 = new ArrayList<Values>();
                Values val = null;
                while (keys.hasMoreElements()) {
                    val = new Values();
                    facCode = (String)keys.nextElement();
                    val.put("FacCode", facCode);
                    val.put("FacDesc", (String)facs.get(facCode));
                    Level level = Logger.getLogger((String)(loggerPrefix.toString() + "." + facCode)).getLevel();
                    val.put("Threshold", level == null ? FacilityInfo.formatLevelString(serverLvl.toString()) : FacilityInfo.formatLevelString(level.toString()));
                    v2.add(val);
                }
                Values[] faclist = new Values[v2.size()];
                for (int i = 0; i < v2.size(); ++i) {
                    faclist[i] = (Values)v2.get(i);
                }
                component.put("Facs", faclist);
                v.add(component);
            }
        }
        Values[] comps = new Values[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            comps[i] = (Values)v.get(i);
        }
        return comps;
    }

    private static String formatLevelString(String level) {
        if ("FATAL".equalsIgnoreCase(level)) {
            return "Fatal";
        }
        if ("ERROR".equalsIgnoreCase(level)) {
            return "Error";
        }
        if ("WARN".equalsIgnoreCase(level)) {
            return "Warn";
        }
        if ("INFO".equalsIgnoreCase(level)) {
            return "Info";
        }
        if ("DEBUG".equalsIgnoreCase(level)) {
            return "Debug";
        }
        if ("TRACE".equalsIgnoreCase(level)) {
            return "Trace";
        }
        if ("OFF".equalsIgnoreCase(level)) {
            return "Off";
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Values buildISFacs(Locale locale) {
        int i;
        String serverLevel;
        ArrayList<Values> v = new ArrayList<Values>();
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(JournalLogger._configDir, "loggers.cnf"));
            props.load(fis);
        }
        catch (IOException e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        DecimalFormat df = new DecimalFormat("####");
        df.setMinimumIntegerDigits(4);
        ResourceBundle rb = ResourceBundle.getBundle(FAC_DESC_BUNDLE_NAME, locale);
        Locale gotThis = rb.getLocale();
        if (!gotThis.getLanguage().equals(locale.getLanguage())) {
            rb = ResourceBundle.getBundle(FAC_DESC_BUNDLE_NAME, new Locale("", ""));
        }
        if ((serverLevel = props.getProperty("SERVER")) == null) {
            Level serverLvl = Logger.getLogger((String)"IS").getLevel();
            if (serverLvl == null) {
                serverLvl = Logger.getRootLogger().getLevel();
            }
            serverLevel = serverLvl.toString();
        }
        Values component = new Values();
        component.put("CompCode", "SERVER");
        component.put("CompDesc", "Integration Server");
        component.put("Threshold", FacilityInfo.formatLevelString(serverLevel));
        for (i = 0; i < FAC_TABLE.length; ++i) {
            FacilityInfo fi = FAC_TABLE[i];
            if (fi == null) continue;
            Values val = new Values();
            val.put("FacCode", df.format(i));
            String desc = "";
            try {
                desc = rb.getString(Integer.toString(i));
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            val.put("FacDesc", desc);
            String level = props.getProperty("SERVER." + fi.getProductId() + "." + df.format(i));
            val.put("Threshold", level == null ? FacilityInfo.formatLevelString(serverLevel) : FacilityInfo.formatLevelString(level));
            v.add(val);
        }
        int size = v.size();
        Values[] facs = new Values[size];
        for (i = 0; i < size; ++i) {
            facs[i] = (Values)v.get(i);
        }
        component.put("Facs", facs);
        return component;
    }

    static Hashtable buildCompFacs(Hashtable comp_facs, Locale locale) {
        DecimalFormat FAC_FORMAT = new DecimalFormat("0000");
        Hashtable comp_bundles = JournalLogger.getComponentBundles();
        if (comp_bundles == null || comp_bundles.size() == 0) {
            return comp_facs;
        }
        if (comp_facs == null) {
            comp_facs = new Hashtable();
        }
        String compCode = null;
        Hashtable<String, String> facs = null;
        String facCode = null;
        String bundle = null;
        Enumeration comp_keys = comp_bundles.keys();
        while (comp_keys.hasMoreElements()) {
            ResourceBundle rb;
            block9: {
                compCode = (String)comp_keys.nextElement();
                bundle = (String)comp_bundles.get(compCode);
                if (Strings.isEmpty(bundle)) continue;
                facs = (Hashtable<String, String>)comp_facs.get(compCode);
                if (facs == null) {
                    facs = new Hashtable<String, String>();
                }
                rb = null;
                try {
                    rb = ResourceBundle.getBundle(bundle, locale);
                    Locale gotThis = rb.getLocale();
                    if (gotThis.getLanguage().equals(locale.getLanguage())) break block9;
                    rb = ResourceBundle.getBundle(bundle, new Locale("", ""));
                }
                catch (MissingResourceException mre) {
                    facs.put(new DecimalFormat("0000").format(1L), mre.getLocalizedMessage());
                    comp_facs.put(compCode, facs);
                    continue;
                }
            }
            Enumeration<String> fac_keys = rb.getKeys();
            while (fac_keys.hasMoreElements()) {
                facCode = fac_keys.nextElement();
                String desc = "";
                try {
                    desc = rb.getString(facCode);
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
                facs.put(FAC_FORMAT.format(Integer.parseInt(facCode)), desc);
            }
            comp_facs.put(compCode, facs);
        }
        return comp_facs;
    }

    public static void getSettings(Values in, Values serverSettings, Locale locale) {
        serverSettings.put("Components", FacilityInfo.buildFacs(locale));
        Level level = Logger.getLogger((String)"IS").getLevel();
        if (level == null) {
            level = Logger.getRootLogger().getLevel();
        }
        serverSettings.put("DebugLevel", FacilityInfo.formatLevelString(level.toString()));
    }

    public static void setSettings(Values in, SCLogConsumer scLogConsumer) {
        boolean logSettings;
        String level = (String)in.get("watt.debug.level");
        if (level != null) {
            JournalLogger.setLevel(JournalLogger.getLogLevel(level));
        }
        if (!(logSettings = ValuesEmulator.getBoolean(in, "logSettings"))) {
            return;
        }
        String[] facilityList = (String[])in.get("facilityList");
        Properties currentProps = FacilityInfo.loadLoggersFile();
        String prefix = "IS.";
        Enumeration<Object> keys = currentProps.keys();
        String loggerName = null;
        while (keys.hasMoreElements()) {
            loggerName = (String)keys.nextElement();
            Logger.getLogger((String)(prefix + loggerName)).setLevel(null);
            scLogConsumer.removeFilter(loggerName);
        }
        Properties prop = new Properties();
        if (facilityList == null) {
            FacilityInfo.writeLoggersFile(prop);
            return;
        }
        String fac = null;
        String val = null;
        for (int i = 0; i < facilityList.length; ++i) {
            if (facilityList[i] == null) continue;
            int index = facilityList[i].indexOf(61);
            if (index > 0) {
                fac = facilityList[i].substring(0, index);
                val = facilityList[i].substring(index + 1);
                index = fac.indexOf("SERVER.");
                if (index >= 0 && (index = fac.indexOf(46)) > 0) {
                    fac = fac.substring(index + 1);
                    FacilityInfo fi = FacilityInfo.lookup(Integer.parseInt(fac));
                    fac = "SERVER." + fi.getProductId() + "." + fac;
                }
            }
            Logger.getLogger((String)(prefix + fac)).setLevel(Level.toLevel(val));
            scLogConsumer.setFilter(fac, Level.toLevel((String)val));
            prop.put(fac, val);
        }
        FacilityInfo.writeLoggersFile(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadLoggersFile() {
        Properties currentProps = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(JournalLogger._configDir, "loggers.cnf"));
            currentProps.load(fis);
        }
        catch (IOException e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        return currentProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLoggersFile(Properties prop) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(JournalLogger._configDir, "loggers.cnf"));
            prop.store(out, "Integration Server logger settings");
            out.flush();
        }
        catch (IOException e) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static Values[] buildComps() {
        Values val = new Values();
        val.put("dbgComp", "SERVER");
        Values[] ret = new Values[]{val};
        return ret;
    }

    static void enableAllFacilities() {
        for (FacilityInfo nextFac : FAC_TABLE) {
            if (nextFac == null) continue;
            nextFac.enabled = true;
        }
    }

    static void disableAllFacilities() {
        for (FacilityInfo nextFac : FAC_TABLE) {
            if (nextFac == null) continue;
            nextFac.enabled = false;
        }
    }

    @Override
    public ArrayList<String> getISProductIDs() {
        if (IS_PRODUCT_IDS == null) {
            FacilityInfo.initIDs();
        }
        return IS_PRODUCT_IDS;
    }

    @Override
    public ArrayList<String> getBasisComponentProductIDs() {
        if (COMP_PRODUCT_IDS == null) {
            FacilityInfo.initIDs();
        }
        return COMP_PRODUCT_IDS;
    }

    static void initFacilityDescriptions() {
        try {
            ResourceBundle rb = ResourceBundle.getBundle(FAC_DESC_BUNDLE_NAME);
            for (int i = 0; i < FAC_TABLE.length; ++i) {
                try {
                    if (FAC_TABLE[i] == null) continue;
                    FacilityInfo.FAC_TABLE[i].desc = rb.getString(Integer.toString(i));
                    continue;
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public static boolean isValidCode(int facility) {
        return facility >= 0 && facility < FAC_TABLE.length && FAC_TABLE[facility] != null;
    }

    public static FacilityInfo lookup(int facility) {
        if (facility >= FAC_TABLE.length) {
            return FAC_TABLE[0];
        }
        return FAC_TABLE[facility];
    }

    public static void enableFacility(int facility) {
        if (facility >= 0 && facility < FAC_TABLE.length) {
            FacilityInfo.FAC_TABLE[facility].enabled = true;
        }
    }

    public static void disableFacility(int facility) {
        if (facility >= 0 && facility < FAC_TABLE.length) {
            FacilityInfo.FAC_TABLE[facility].enabled = false;
        }
    }

    static {
        FacilityInfo.initIDs();
    }
}

