/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import java.util.BitSet;

public class ExtBitSet {
    BitSet bs;
    int len;

    public ExtBitSet(BitSet bs, int len) {
        this.bs = bs;
        this.len = len;
    }

    public ExtBitSet(int len) {
        this.bs = new BitSet(len);
        this.len = len;
    }

    public ExtBitSet(byte[] b, int blocklen) {
        this(b, blocklen, blocklen);
    }

    public ExtBitSet(byte[] b, int blocklen, int olen) {
        this(b.length * blocklen - b.length * blocklen % olen);
        for (int i = 0; i < b.length; ++i) {
            int val = b[i];
            for (int j = 0; j < blocklen; ++j) {
                if ((val & 1) > 0) {
                    this.set(i * blocklen + j);
                } else {
                    this.clear(i * blocklen + j);
                }
                val >>= 1;
            }
        }
    }

    public int getSize() {
        return this.len;
    }

    public boolean get(int pos) {
        return this.bs.get(pos);
    }

    public void set(int pos) {
        this.bs.set(pos);
    }

    public void clear(int pos) {
        this.bs.clear(pos);
    }

    public byte[] getBytes(int blocklen) {
        int num = this.len / blocklen + (this.len % blocklen > 0 ? 1 : 0);
        byte[] b = new byte[num];
        boolean bn = false;
        for (int i = 0; i < num; ++i) {
            int val = 0;
            for (int j = 0; j < blocklen; ++j) {
                if (this.get(i * blocklen + j)) {
                    val |= 0x80;
                }
                if (j >= blocklen - 1) continue;
                val >>= 1;
            }
            b[i] = (byte)(val >>= 8 - blocklen);
        }
        return b;
    }

    public boolean equals(Object o) {
        if (o instanceof BitSet) {
            return ((BitSet)o).equals(this.bs);
        }
        if (o instanceof ExtBitSet) {
            return ((ExtBitSet)o).bs.equals(this.bs);
        }
        return false;
    }

    public void append(ExtBitSet nbs) {
        this.bs = ExtBitSet.append((ExtBitSet)this, (ExtBitSet)nbs).bs;
    }

    private boolean xor(boolean b1, boolean b2) {
        return b1 != b2;
    }

    public void xor(ExtBitSet mbs) {
        int ml = mbs.getSize();
        int spos = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.xor(this.get(i), mbs.get(spos++))) {
                this.set(i);
            } else {
                this.clear(i);
            }
            if (spos < ml) continue;
            spos = 0;
        }
    }

    public static ExtBitSet append(ExtBitSet bs1, ExtBitSet bs2) {
        int b1s = bs1.getSize();
        int b2s = bs2.getSize();
        BitSet nb = new BitSet(b1s + b2s);
        for (int i = 0; i < b1s; ++i) {
            if (bs1.get(i)) {
                nb.set(i);
                continue;
            }
            nb.clear(i);
        }
        for (int j = 0; j < b2s; ++j) {
            if (bs2.get(j)) {
                nb.set(j + b1s);
                continue;
            }
            nb.clear(j + b1s);
        }
        return new ExtBitSet(nb, b1s + b2s);
    }

    public String getString() {
        return this.getString(0);
    }

    public String getString(int mark) {
        StringBuffer sb = new StringBuffer(this.len);
        for (int i = 0; i < this.len; ++i) {
            sb.append(this.get(i) ? "1" : "0");
            if (mark <= 0 || i % mark != mark - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getString();
    }
}

