/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import java.util.HashMap;

public class EncodingNames {
    static HashMap nameMap;
    static HashMap IANAMap;

    public static String getJavaName(String name) {
        String ret;
        if (name == null || name.length() == 0 || name.equalsIgnoreCase("autodetect")) {
            ret = null;
        } else {
            ret = (String)nameMap.get(name.toUpperCase());
            if (ret == null) {
                ret = name;
            }
        }
        return ret;
    }

    public static String getIANAName(String name) {
        String ret;
        if (name == null || name.length() == 0 || name.equalsIgnoreCase("autodetect")) {
            ret = null;
        } else {
            ret = (String)IANAMap.get(name.toUpperCase());
            if (ret == null) {
                ret = name;
            }
        }
        return ret;
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Usage: EncodingNames name");
        } else {
            System.out.println("result=\"" + EncodingNames.getJavaName(argv[0]) + "\"");
        }
    }

    static {
        String[] table = new String[]{"UTF8", "UTF8", "UTF-8", "UTF8", "ASCII", "ASCII", "ISO_8859-1", "8859_1", "ISO8859_1", "8859_1", "ISO_8859-2", "8859_2", "ISO_8859-3", "8859_3", "ISO_8859-4", "8859_4", "ISO_8859-5", "8859_5", "ISO_8859-6", "8859_6", "ISO_8859-7", "8859_7", "ISO_8859-8", "8859_8", "ISO_8859-9", "8859_9", "ISO-8859-1", "8859_1", "ISO-8859-2", "8859_2", "ISO-8859-3", "8859_3", "ISO-8859-4", "8859_4", "ISO-8859-5", "8859_5", "ISO-8859-6", "8859_6", "ISO-8859-7", "8859_7", "ISO-8859-8", "8859_8", "ISO-8859-9", "8859_9", "CP1252", "Cp1252", "BIG5", "Big5", "BIG-5", "Big5", "GB2312", "EUC-CN", "SHIFT_JIS", "SJIS", "EUC-JP", "EUC_JP", "EUC-TW", "EUC_TW", "ISO-2022-JP", "ISO2022JP", "ISO-2022-KR", "ISO2022KR", "ISO-2022-CN", "ISO2022CN", "GBK", "GBK", "EUC-KR", "EUC_KR", "EUC-CN", "EUC_CN", "JOHAB", "Johab", "IBM037", "Cp037"};
        nameMap = new HashMap(table.length / 2, 1.0f);
        IANAMap = new HashMap(table.length / 2, 1.0f);
        for (int i = 0; i < table.length; i += 2) {
            nameMap.put(table[i], table[i + 1]);
            IANAMap.put(table[i + 1], table[i]);
        }
    }
}

