/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.g11n.util.encodingUtils;
import com.wm.lang.xml.token.WmDocReaderHtmlScanner;
import com.wm.lang.xml.token.WmDocReaderXmlScanner;
import com.wm.net.EncodeURL;
import com.wm.net.UTF8Utility;
import com.wm.util.EncodingNames;
import com.wm.util.LocalizedIOException;
import com.wm.util.resources.UtilExceptionBundle;
import com.wm.util.text.Normalizer;
import com.wm.util.text.NormalizerFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class EncUtil {
    public static final String WATT_FILE_ENCODING = "watt.server.fileEncoding";
    public static final String WATT_NET_ENCODING = "watt.server.netEncoding";
    public static final String WATT_LOG_ENCODING = "watt.server.logEncoding";
    public static final String SYSTEM_FILE_ENCODING = "file.encoding";
    private static final String DISABLE_XSS_FILTER = "watt.server.disableXSSFilter";
    public static final int FILE_ENCODING = 0;
    public static final int NET_ENCODING = 1;
    public static final int LOG_ENCODING = 2;
    public static final int URL_ENCODING = 3;
    public static final int LOG_FILE_ENCODING = 4;
    public static final String UTF8 = "UTF8";
    public static final String UNICODE = "Unicode";
    static Normalizer Normalizer;
    static boolean disableXSSFilter;
    static String[] encodings;
    static String unknownTypeEncoding;

    private static String initEncoding(int enctype) {
        String encoding = null;
        switch (enctype) {
            case 0: {
                encoding = System.getProperty(WATT_FILE_ENCODING);
                break;
            }
            case 1: {
                encoding = System.getProperty(WATT_NET_ENCODING);
                if (encoding != null) break;
                encoding = UTF8;
                break;
            }
            case 2: {
                encoding = System.getProperty(WATT_LOG_ENCODING);
                break;
            }
            case 3: {
                encoding = System.getProperty(WATT_NET_ENCODING);
                break;
            }
            case 4: {
                encoding = System.getProperty(WATT_LOG_ENCODING);
                if (encoding != null) break;
                encoding = UTF8;
            }
        }
        if (encoding == null) {
            return System.getProperty(SYSTEM_FILE_ENCODING);
        }
        encoding = EncodingNames.getJavaName(encoding);
        return encoding;
    }

    public static final String getEncoding(int enctype) {
        if (enctype < 0 || enctype > 4) {
            return unknownTypeEncoding;
        }
        return encodings[enctype];
    }

    public static final byte[] getBytes(int enctype, String str) {
        String encoding = EncUtil.getEncoding(enctype);
        if (encoding == null) {
            return str.getBytes();
        }
        try {
            return str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return str.getBytes();
        }
    }

    public static final String getString(int enctype, byte[] bytes) {
        String encoding = EncUtil.getEncoding(enctype);
        if (encoding == null) {
            return new String(bytes);
        }
        try {
            String retval = new String(bytes, encoding);
            if (retval != null) {
                return retval;
            }
            return new String(bytes);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return new String(bytes);
        }
    }

    public static String encodeUnicode(String str) {
        return encodingUtils.native2ascii((String)str);
    }

    public static String decodeUnicode(String str) {
        return encodingUtils.ascii2native((String)str);
    }

    private static Character getUnicodeChar(String seq) {
        Character ret = null;
        try {
            int hiByte = Integer.parseInt(seq.substring(0, 2), 16) & 0xFF;
            int loByte = Integer.parseInt(seq.substring(2), 16) & 0xFF;
            char ch = (char)(hiByte << 8 | loByte);
            ret = new Character(ch);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    public static final byte[] getFileBytes(String str) {
        return EncUtil.getBytes(0, str);
    }

    public static final byte[] getNetBytes(String str) {
        return EncUtil.getBytes(1, str);
    }

    public static final byte[] getLogBytes(String str) {
        return EncUtil.getBytes(2, str);
    }

    public static final String getFileString(byte[] bytes) {
        return EncUtil.getString(0, bytes);
    }

    public static final String getFileString(File file) throws IOException {
        return EncUtil.getFileString(file, null);
    }

    public static final String getFileString(File file, String encoding) throws IOException {
        String charset;
        int read;
        FileInputStream instream = new FileInputStream(file);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((read = instream.read(buf)) > 0) {
            outstream.write(buf, 0, read);
        }
        outstream.flush();
        instream.close();
        if (encoding == null) {
            charset = EncUtil.detectEncoding(file);
            if (charset == null) {
                throw new LocalizedIOException(UtilExceptionBundle.class, UtilExceptionBundle.UNKNOWN_ENCODING, "", file.getName());
            }
        } else {
            if (!EncUtil.testEncoding(file, encoding)) {
                Object[] subs = new String[]{encoding, file.getName()};
                throw new LocalizedIOException(UtilExceptionBundle.class, UtilExceptionBundle.INVALID_ENCODING, "", subs);
            }
            charset = encoding;
        }
        String content = null;
        byte[] b = outstream.toByteArray();
        content = new String(b, MimeUtility.javaCharset((String)charset));
        return content;
    }

    public static final String getNetString(byte[] bytes) {
        return EncUtil.getString(1, bytes);
    }

    public static final String getLogString(byte[] bytes) {
        return EncUtil.getString(2, bytes);
    }

    public static final String getFileEncoding() {
        return EncUtil.getEncoding(0);
    }

    public static final String getNetEncoding() {
        return EncUtil.getEncoding(1);
    }

    public static final String getLogEncoding() {
        return EncUtil.getEncoding(2);
    }

    public static final String getLogFileEncoding() {
        return EncUtil.getEncoding(4);
    }

    public static final String getURLEncoding() {
        return EncUtil.getEncoding(3);
    }

    public static String getString(byte[] bytes) {
        return EncUtil.getString(bytes, null);
    }

    public static String getString(byte[] bytes, String enc) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return new String();
        }
        if (UTF8.equalsIgnoreCase(EncodingNames.getJavaName(enc))) {
            if (UTF8Utility.isUTF8(bytes)) {
                try {
                    return new String(bytes, UTF8);
                }
                catch (UnsupportedEncodingException iee) {
                    return null;
                }
            }
            return null;
        }
        try {
            int bytesread;
            int bufsize = bytes.length < 8192 ? bytes.length : 8192;
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            InputStreamReader isr = enc != null ? new InputStreamReader((InputStream)bis, enc) : new InputStreamReader(bis);
            CharArrayWriter out = new CharArrayWriter();
            boolean offset = false;
            char[] buffer = new char[bufsize];
            while ((bytesread = isr.read(buffer, 0, bufsize)) != -1) {
                out.write(buffer, 0, bytesread);
            }
            char[] chararray = out.toCharArray();
            return new String(chararray);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final String getString(InputStream is) {
        String ret;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] b = new byte[8192];
        try {
            int read;
            while ((read = is.read(b)) > 0) {
                os.write(b, 0, read);
            }
            byte[] buf = os.toByteArray();
            ret = new String(buf, EncUtil.detectEncoding(buf));
            buf = null;
            os = null;
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public static boolean isUTF8(byte[] buf) {
        if (buf == null) {
            return false;
        }
        if (buf.length > 2 && (buf[0] & 0xFF) == 239 && (buf[1] & 0xFF) == 187 && (buf[2] & 0xFF) == 191) {
            return true;
        }
        return UTF8Utility.isUTF8(buf);
    }

    public static boolean isUTF8(File file) {
        try {
            if (!file.exists()) {
                return false;
            }
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[4092];
            int offset = 0;
            int amount_read = 0;
            while ((amount_read = bis.read(buf, offset, 4092)) != -1) {
                offset += 4092;
                if (!UTF8Utility.isUTF8(buf, amount_read)) {
                    return false;
                }
                if (amount_read >= 4092) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isUnicode(byte[] buf) {
        return buf.length > 2 && ((buf[0] & 0xFF) == 254 && (buf[1] & 0xFF) == 255 || (buf[0] & 0xFF) == 255 && (buf[1] & 0xFF) == 254);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAscii(File file) {
        boolean ret = true;
        FileInputStream is = null;
        try {
            int read;
            is = new FileInputStream(file.getCanonicalPath());
            byte[] buf = new byte[8192];
            block11: while ((read = is.read(buf)) > 0) {
                for (int i = 0; i < read; ++i) {
                    if (buf[i] >= 0 && buf[i] <= 127) continue;
                    ret = false;
                    continue block11;
                }
            }
        }
        catch (Exception e) {
            ret = false;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return ret;
    }

    public static boolean isAscii(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ((c & 0xFF00) != 0) {
                return false;
            }
            byte b2 = (byte)(c & 0xFF);
            if (b2 >= 0 && b2 <= 127) continue;
            return false;
        }
        return true;
    }

    public static String detectEncoding(byte[] buf) {
        if (EncUtil.isUnicode(buf)) {
            return new String(UNICODE);
        }
        if (EncUtil.isUTF8(buf)) {
            return UTF8;
        }
        return MimeUtility.getDefaultJavaCharset();
    }

    public static String detectEncoding(File file) {
        if (EncUtil.testEncoding(file, UTF8)) {
            return UTF8;
        }
        if (EncUtil.testEncoding(file, MimeUtility.getDefaultJavaCharset())) {
            return MimeUtility.getDefaultJavaCharset();
        }
        if (EncUtil.testEncoding(file, UNICODE)) {
            return UNICODE;
        }
        return null;
    }

    public static String normalize(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        return Normalizer.normalize(str);
    }

    public static String normalize(String str, boolean fixRaceCases) {
        if (str == null || str.length() == 0) {
            return "";
        }
        return Normalizer.normalize(str, fixRaceCases);
    }

    public static String fixRaceCases(String str) {
        char[] array = str.toCharArray();
        boolean changed = false;
        for (int i = 0; i < str.length(); ++i) {
            if (array[i] == '\u3002') {
                array[i] = 65294;
                changed = true;
                continue;
            }
            if (array[i] == '\u30fc') {
                array[i] = 45;
                changed = true;
                continue;
            }
            if (array[i] != '\uff1b') continue;
            array[i] = 59;
            changed = true;
        }
        if (changed) {
            str = new String(array);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testEncoding(File file, String encoding) {
        boolean ret = true;
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(file), MimeUtility.javaCharset((String)encoding));
            char[] b = new char[8192];
            while (isr.read(b) > 0) {
            }
        }
        catch (Exception e) {
            ret = false;
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception e) {}
            }
        }
        return ret;
    }

    public static String getDocEncoding(char[] data, boolean isXml) {
        if (data == null) {
            return null;
        }
        String enc = null;
        if (isXml) {
            WmDocReaderXmlScanner xmlScanner = new WmDocReaderXmlScanner();
            for (int i = 0; i < data.length && (Character.isWhitespace(data[i]) && i > 5 && i < data.length - 1 && (data[i - 1] == '=' || data[i + 1] == '=') || (enc = xmlScanner.process(data[i])) == null); ++i) {
            }
        } else {
            WmDocReaderHtmlScanner htmlScanner = new WmDocReaderHtmlScanner();
            for (int i = 0; i < data.length && (Character.isWhitespace(data[i]) && i > 5 && i < data.length - 1 && (data[i - 1] == '=' || data[i + 1] == '=') || (enc = htmlScanner.process(data[i])) == null); ++i) {
            }
        }
        if (enc != null && enc.equals("")) {
            enc = null;
        }
        return enc;
    }

    public static String filterHTML(String unfiltered) {
        if (unfiltered == null) {
            return null;
        }
        if (disableXSSFilter || unfiltered.indexOf(60) == -1 && unfiltered.indexOf(62) == -1 && unfiltered.indexOf(38) == -1 && unfiltered.indexOf(34) == -1) {
            return unfiltered;
        }
        char[] content = new char[unfiltered.length()];
        unfiltered.getChars(0, unfiltered.length(), content, 0);
        StringBuffer result = new StringBuffer(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String filterHTMLSansAmp(String unfiltered) {
        if (unfiltered == null) {
            return null;
        }
        try {
            unfiltered = EncodeURL.decode(unfiltered, EncUtil.getURLEncoding());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (disableXSSFilter || unfiltered.indexOf(60) == -1 && unfiltered.indexOf(62) == -1 && unfiltered.indexOf(34) == -1) {
            return unfiltered;
        }
        char[] content = new char[unfiltered.length()];
        unfiltered.getChars(0, unfiltered.length(), content, 0);
        StringBuffer result = new StringBuffer(content.length + 50);
        block7: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String filterXSSHTML(String unfiltered) {
        if (unfiltered == null) {
            return null;
        }
        if (disableXSSFilter) {
            return unfiltered;
        }
        String temp = unfiltered;
        temp = temp.toLowerCase();
        int startTag = temp.indexOf("<script");
        int endtag = temp.indexOf("</script");
        if (startTag == -1 && endtag == -1) {
            return unfiltered;
        }
        unfiltered = unfiltered.replaceAll("<[s|S][c|C][r|R][i|I][p|P][t|T]", "&lt;script");
        unfiltered = unfiltered.replaceAll("</[s|S][c|C][r|R][i|I][p|P][t|T]", "&lt;/script");
        return unfiltered;
    }

    public static String decodeText(String etext) throws UnsupportedEncodingException {
        String lwsp = " \t\n\r\"";
        if (etext.indexOf("=?") == -1) {
            return etext;
        }
        StringTokenizer st = new StringTokenizer(etext, lwsp, true);
        StringBuffer sb = new StringBuffer();
        StringBuffer wsb = new StringBuffer();
        boolean prevWasEncoded = false;
        while (st.hasMoreTokens()) {
            String word;
            String s = st.nextToken();
            char c = s.charAt(0);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                wsb.append(c);
                continue;
            }
            try {
                word = MimeUtility.decodeWord((String)s);
                if (!prevWasEncoded && wsb.length() > 0) {
                    sb.append(wsb);
                }
                prevWasEncoded = true;
            }
            catch (ParseException pex) {
                word = s;
                if (wsb.length() > 0) {
                    sb.append(wsb);
                }
                prevWasEncoded = false;
            }
            sb.append(word);
            wsb.setLength(0);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String test = "\u007f";
        if (EncUtil.isAscii(test)) {
            System.out.println("Is ascii");
        } else {
            System.out.println("Is not ascii");
        }
    }

    static {
        disableXSSFilter = false;
        encodings = null;
        unknownTypeEncoding = null;
        Normalizer = NormalizerFactory.getInstance();
        disableXSSFilter = Boolean.getBoolean(DISABLE_XSS_FILTER);
        encodings = new String[5];
        for (int i = 0; i < encodings.length; ++i) {
            EncUtil.encodings[i] = EncUtil.initEncoding(i);
        }
        unknownTypeEncoding = EncUtil.initEncoding(6);
    }
}

