/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.Cron;
import com.wm.util.CronJob;
import com.wm.util.Masks;
import com.wm.util.Values;
import java.util.Calendar;
import java.util.Date;

public class CronJobExt
extends CronJob {
    long startDate;
    long endDate;
    long minuteMask;
    int hourMask;
    int dayOfMonthMask;
    int monthMask;
    int dayOfWeekMask;
    long lastRun;

    protected CronJobExt(Values val) {
        super(val);
    }

    public static CronJobExt createExt(Values val) {
        if (val != null) {
            return new CronJobExt(val);
        }
        return null;
    }

    public CronJobExt() {
        super(null, null, 0L);
    }

    public CronJobExt(String name, Runnable target, long startDate, long endDate, long minuteMask, int hourMask, int dayOfMonthMask, int dayOfWeekMask, int monthMask) {
        super(name, target, 0L);
        this.startDate = startDate;
        this.endDate = endDate;
        this.minuteMask = minuteMask;
        this.hourMask = hourMask;
        this.dayOfMonthMask = dayOfMonthMask;
        this.dayOfWeekMask = dayOfWeekMask;
        this.monthMask = monthMask;
        this.lastRun = 0L;
    }

    public boolean shouldRun(long time) {
        boolean ok;
        Calendar c;
        if (time - this.lastRun < 61000L) {
            c = Calendar.getInstance();
            c.setTime(new Date(this.lastRun));
            int lastRunMinute = c.get(12);
            c.setTime(new Date(time));
            int currentMinute = c.get(12);
            if (currentMinute == lastRunMinute) {
                return false;
            }
        }
        c = Calendar.getInstance();
        c.setTime(new Date(time));
        int dayOfWeek = c.get(7);
        int dayOfMonth = c.get(5);
        int month = c.get(2);
        int hour = c.get(11);
        int min = c.get(12);
        boolean bl = ok = !(this.startDate != 0L && this.startDate >= time || this.endDate != 0L && this.endDate <= time || !Masks.isMatch(this.dayOfWeekMask, dayOfWeek) || !Masks.isMatch(this.dayOfMonthMask, dayOfMonth) || !Masks.isMatch(this.monthMask, month) || !Masks.isMatch(this.hourMask, hour) || !Masks.isMatch(this.minuteMask, min));
        if (ok) {
            this.lastRun = time;
        }
        return ok;
    }

    public boolean isExpired() {
        return this.endDate > 0L && System.currentTimeMillis() > this.endDate;
    }

    public void update(Cron cr) {
        cr.updateTask(this);
    }

    public void calcNextTime() {
    }

    public int getRepeatType() {
        return 2;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public long getMinuteMask() {
        return this.minuteMask;
    }

    public int getHourMask() {
        return this.hourMask;
    }

    public int getDayMonthMask() {
        return this.dayOfMonthMask;
    }

    public int getMonthMask() {
        return this.monthMask;
    }

    public int getDayWeekMask() {
        return this.dayOfWeekMask;
    }

    public Values getValues() {
        long now = System.currentTimeMillis();
        Values v = super.getValues();
        v.copyFrom(new Values(new Object[][]{{"type", "complex"}, {"lastRun", this.lastRun == 0L ? null : Long.toString(this.lastRun)}, {"msDelta", this.lastRun == 0L ? null : Long.toString(now - this.lastRun)}, {"startDate", Long.toString(this.startDate)}, {"endDate", Long.toString(this.endDate)}, {"minuteMask", Long.toString(this.minuteMask)}, {"hourMask", Long.toString(this.hourMask)}, {"dayOfMonthMask", Long.toString(this.dayOfMonthMask)}, {"monthMask", Long.toString(this.monthMask)}, {"dayOfWeekMask", Long.toString(this.dayOfWeekMask)}}));
        return v;
    }

    public void setValues(Values v) {
        super.setValues(v);
        this.lastRun = v.getLong("lastRun");
        this.startDate = v.getLong("startDate");
        this.endDate = v.getLong("endDate");
        this.minuteMask = v.getLong("minuteMask");
        this.hourMask = v.getInt("hourMask");
        this.dayOfMonthMask = v.getInt("dayOfMonthMask");
        this.monthMask = v.getInt("monthMask");
        this.dayOfWeekMask = v.getInt("dayOfWeekMask");
    }
}

