/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.data.IData;
import com.wm.data.IDataPortable;
import com.wm.util.Config;
import com.wm.util.Cron;
import com.wm.util.Values;
import com.wm.util.coder.Codable;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.synch.PostBarrier;

public class CronJob
implements IDataPortable,
Codable,
ValuesCodable,
Runnable {
    public static final int ONE_TIME_ONLY = -1;
    public static final int REPEAT_FROM_START = 0;
    public static final int REPEAT_FROM_END = 1;
    public static final int REPEAT_COMPLEX = 2;
    public static final int STATE_RUNNABLE = 0;
    public static final int STATE_PENDING = 1;
    public static final int STATE_SUSPENDED = 2;
    public static final int STATE_CANCELLED = 3;
    static String gMyHost;
    String gHost;
    Cron cron;
    Runnable target;
    String name;
    long nextRun;
    long interval;
    int schedState;
    int execState;
    Values customData;
    boolean doNotOverlap;
    String id;
    PostBarrier barrier;
    boolean justRan = false;

    private static String stringState(int state) {
        switch (state) {
            case 1: {
                return "pending";
            }
            case 2: {
                return "suspended";
            }
            case 3: {
                return "cancelled";
            }
        }
        return "running";
    }

    private static int intState(String state) {
        if (state != null) {
            if (state.equalsIgnoreCase("pending")) {
                return 1;
            }
            if (state.equalsIgnoreCase("suspended")) {
                return 2;
            }
            if (state.equalsIgnoreCase("cancelled")) {
                return 3;
            }
        }
        return 0;
    }

    protected CronJob(Values val) {
        this.gHost = gMyHost;
        this.setValues(val);
        if (this.doNotOverlap) {
            this.barrier = new PostBarrier(1, 1);
        }
    }

    public static CronJob create(Cron cron, Values val) {
        CronJob cj = null;
        if (val != null) {
            cj = new CronJob(val);
            cj.cron = cron;
        }
        return cj;
    }

    public static CronJob create(Values val) {
        if (val != null) {
            return new CronJob(val);
        }
        return null;
    }

    public CronJob(String name, Runnable target, long when) {
        this(name, target, when, 0L, null, false);
    }

    public CronJob(String name, Runnable target, long when, long interval) {
        this(name, target, when, interval, null, false);
    }

    public CronJob(String name, Runnable target, long when, long interval, Cron cron, boolean doNotOverlap) {
        this.name = name;
        this.target = target;
        this.nextRun = when == 0L ? System.currentTimeMillis() : when;
        this.interval = interval;
        this.cron = cron;
        this.execState = 0;
        this.schedState = 0;
        this.doNotOverlap = doNotOverlap;
        this.id = null;
        if (doNotOverlap) {
            this.barrier = new PostBarrier(1, 1);
        }
    }

    public void setJustRan(boolean justRan) {
        this.justRan = justRan;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSchedState(int STATE) {
        this.schedState = STATE;
    }

    public int getSchedState() {
        return this.schedState;
    }

    public void setTarget(Runnable target) {
        this.target = target;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setNextRun(long next) {
        this.nextRun = next;
    }

    public void setCustomData(Values data) {
        this.customData = data;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean getJustRan() {
        return this.justRan;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Runnable getTarget() {
        return this.doNotOverlap ? this : this.target;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getNextRun() {
        return this.nextRun;
    }

    public Values getCustomData() {
        return this.customData;
    }

    public String getHost() {
        return this.gHost;
    }

    public String toString() {
        StringBuffer rep = new StringBuffer();
        rep.append("(");
        rep.append(this.name).append(", ");
        rep.append((double)this.interval / 1000.0).append(", ");
        rep.append(this.nextRun).append(", ");
        rep.append(CronJob.stringState(this.execState));
        rep.append(")");
        return rep.toString();
    }

    public int getRepeatType() {
        if (this.interval < 1L) {
            return -1;
        }
        return this.doNotOverlap ? 1 : 0;
    }

    public boolean repeats() {
        return this.getRepeatType() != -1;
    }

    public void calcNextTime() {
        this.calcNextTime(false);
    }

    public void calcNextTime(boolean fromNow) {
        if (this.getRepeatType() == -1) {
            return;
        }
        this.nextRun = fromNow ? System.currentTimeMillis() + this.interval : (this.nextRun += this.interval);
    }

    public void cancel() {
        this.execState = 3;
    }

    public void suspend() {
        this.execState = 2;
    }

    public void unsuspend() {
        this.execState = 0;
    }

    public boolean isCancelled() {
        return this.execState == 3;
    }

    public boolean isSuspended() {
        return this.execState == 2;
    }

    public boolean isRunnable() {
        return this.schedState == 0 && this.execState == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule(Cron cron) {
        if (this.isCancelled()) {
            return;
        }
        this.gHost = gMyHost;
        switch (this.getRepeatType()) {
            case -1: {
                break;
            }
            case 0: {
                this.calcNextTime();
                cron.scheduleTask(this);
                break;
            }
            case 1: {
                CronJob cronJob = this;
                synchronized (cronJob) {
                    if (this.isSuspended()) {
                        this.calcNextTime();
                        cron.scheduleTask(this);
                    } else {
                        this.schedState = 1;
                        this.nextRun = Long.MAX_VALUE;
                        cron.scheduleTask(this);
                        if (this.barrier != null) {
                            this.barrier.barrierPost();
                        }
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.isCancelled()) {
            return;
        }
        if (this.isSuspended()) {
            return;
        }
        if (this.barrier != null) {
            this.barrier.barrierWait();
        }
        try {
            if (this.target != null) {
                this.target.run();
            }
        }
        finally {
            if (this.cron == null) {
                return;
            }
            this.setJustRan(true);
            this.cron.interruptAndReschedule(this);
        }
    }

    public synchronized void resetForNextRun() {
        this.calcNextTime(true);
        this.schedState = 0;
        this.setJustRan(true);
    }

    public Values getValues() {
        long now = System.currentTimeMillis();
        long next = this.getNextRun();
        Object[][] o = new Object[][]{{"type", "normal"}, {"name", this.name}, {"nextRun", Long.toString(next)}, {"msDelta", Long.toString(next - now)}, {"interval", Long.toString(this.getInterval())}, {"oid", this.id}, {"custom", this.getCustomData()}, {"execState", CronJob.stringState(this.execState)}, {"schedState", CronJob.stringState(this.schedState)}, {"doNotOverlap", new Boolean(this.doNotOverlap).toString()}, {"target", this.target}, {"host", this.gHost}};
        return new Values(o);
    }

    public void setValues(Values v) {
        this.gHost = v.getString("host");
        this.name = v.getString("name");
        this.nextRun = v.getLong("nextRun");
        this.interval = v.getLong("interval");
        this.setTarget((Runnable)v.get("target"));
        if (v.containsKey("cancelled")) {
            this.execState = 0;
            this.schedState = 0;
        } else {
            String oid;
            if (v.containsKey("schedState")) {
                this.schedState = CronJob.intState(v.getString("schedState"));
            }
            if (v.containsKey("execState")) {
                this.execState = CronJob.intState(v.getString("execState"));
            }
            if (v.containsKey("oid") && (oid = v.getString("oid")).charAt(0) == 'J') {
                this.id = oid;
            }
        }
        this.doNotOverlap = v.getBoolean("doNotOverlap");
        this.setCustomData(v.getValues("custom"));
    }

    public void setTarget(CronJob cj) {
        this.target = cj.target;
    }

    public boolean equals(Object obj) {
        try {
            CronJob cj = (CronJob)obj;
            if (cj.getId() != null) {
                return cj.getId().equalsIgnoreCase(this.getId());
            }
            if (cj.getName() != null) {
                return cj.getName().equalsIgnoreCase(this.getName()) && cj.getInterval() == this.getInterval();
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void update(Cron cr) {
        cr.updateTask(this);
    }

    public Object getValue(String key) {
        if (key.equalsIgnoreCase("type")) {
            return "normal";
        }
        if (key.equalsIgnoreCase("name")) {
            return this.name;
        }
        if (key.equalsIgnoreCase("nextRun")) {
            long next = this.getNextRun();
            return Long.toString(next);
        }
        if (key.equalsIgnoreCase("msDelta")) {
            long now = System.currentTimeMillis();
            long next = this.getNextRun();
            return Long.toString(next - now);
        }
        if (key.equalsIgnoreCase("interval")) {
            return Long.toString(this.getInterval());
        }
        if (key.equalsIgnoreCase("oid")) {
            return this.id;
        }
        if (key.equalsIgnoreCase("custom")) {
            return this.getCustomData();
        }
        if (key.equalsIgnoreCase("execState")) {
            return CronJob.stringState(this.execState);
        }
        if (key.equalsIgnoreCase("schedState")) {
            return CronJob.stringState(this.schedState);
        }
        if (key.equalsIgnoreCase("doNotOverlap")) {
            return new Boolean(this.doNotOverlap).toString();
        }
        if (key.equalsIgnoreCase("target")) {
            return this.getTarget();
        }
        if (key.equalsIgnoreCase("host")) {
            return this.gHost;
        }
        return null;
    }

    public void setValue(String key, Object value) {
        if (!key.equalsIgnoreCase("type")) {
            if (key.equalsIgnoreCase("name")) {
                this.name = (String)value;
            } else if (key.equalsIgnoreCase("nextRun")) {
                this.nextRun = (Long)value;
            } else if (!key.equalsIgnoreCase("msDelta")) {
                if (key.equalsIgnoreCase("interval")) {
                    this.interval = (Long)value;
                } else if (key.equalsIgnoreCase("oid")) {
                    String oid = (String)value;
                    if (oid.charAt(0) == 'J') {
                        this.id = oid;
                    }
                } else if (key.equalsIgnoreCase("custom")) {
                    this.setCustomData((Values)value);
                } else if (key.equalsIgnoreCase("execState")) {
                    this.execState = CronJob.intState((String)value);
                } else if (key.equalsIgnoreCase("cancelled")) {
                    this.execState = 0;
                    this.schedState = 0;
                } else if (key.equalsIgnoreCase("schedState")) {
                    this.schedState = CronJob.intState((String)value);
                } else if (key.equalsIgnoreCase("doNotOverlap")) {
                    this.doNotOverlap = (Boolean)value;
                } else if (key.equalsIgnoreCase("target")) {
                    this.setTarget((Runnable)value);
                } else if (key.equalsIgnoreCase("host")) {
                    this.gHost = (String)value;
                }
            }
        }
    }

    public String[] getValueKeys() {
        String[] s = new String[]{"type", "name", "nextRun", "msDelta", "interval", "oid", "custom", "execState", "schedState", "doNotOverlap", "target", "host"};
        return s;
    }

    public IData getAsData() {
        System.err.println("getAsData()");
        return this.getValues().getIData();
    }

    public void setFromData(IData data) {
        System.err.println("setFromData()");
        this.setValues(Values.use(data));
    }

    static {
        try {
            gMyHost = Config.getProperty(Config.getLocalHost().getHostName(), "watt.server.cluster.name");
        }
        catch (Exception e) {
            gMyHost = "127.0.0.1";
        }
    }
}

