/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.CronJob;
import com.wm.util.CronJobExt;
import com.wm.util.CronTest;
import com.wm.util.pool.PooledThread;
import com.wm.util.pool.ThreadPool;
import java.util.Enumeration;
import java.util.Vector;

public class Cron
implements Runnable {
    public static final int DEFAULT_MIN_THREADS = 2;
    public static final int DEFAULT_MAX_THREADS = 5;
    protected Vector tasks = new Vector(1);
    protected Vector extTasks = new Vector(1);
    protected Thread current;
    protected ThreadPool pool;
    protected boolean useComplexQ = false;
    protected boolean running;
    protected CronJob outOfPlaceJob;
    protected long scanComplexQInterval = 30000L;

    public Cron() {
        this(2, 5);
    }

    public Cron(int minThread, int maxThread) {
        this(minThread, maxThread, "Cron Daemon");
    }

    public Cron(int minThread, int maxThread, String name) {
        this(minThread, maxThread, "Cron Daemon", true);
    }

    public Cron(int minThread, int maxThread, String name, boolean startMe) {
        this.pool = new ThreadPool(minThread, maxThread, name + " Pool");
        this.current = new Thread((Runnable)this, name);
        this.outOfPlaceJob = null;
        if (startMe) {
            this.running = true;
            this.current.start();
        }
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.current.start();
        }
    }

    public void enableComplexQ(Cron cron) {
        this.useComplexQ = true;
        long start = System.currentTimeMillis();
        start = start - start % 1000L + 50L;
        cron.scheduleTask(new CronJob("Complex Job Manager", new Runnable(){

            public void run() {
                Cron.this.scanComplexQ();
            }
        }, start, this.scanComplexQInterval));
    }

    public void scanComplexQ() {
        if (!this.useComplexQ) {
            return;
        }
        long now = System.currentTimeMillis();
        Vector tlist = (Vector)this.extTasks.clone();
        Enumeration e = this.extTasks.elements();
        while (e.hasMoreElements()) {
            CronJobExt job = (CronJobExt)e.nextElement();
            if (job.isRunnable() && job.shouldRun(now)) {
                this.dispatch(job);
            }
            if (!job.isExpired()) continue;
            tlist.removeElement(job);
        }
        this.extTasks = tlist;
    }

    public void scheduleTask(CronJob job) {
        if (job.isCancelled()) {
            return;
        }
        if (job instanceof CronJobExt) {
            this.scheduleComplexTask((CronJobExt)job);
            return;
        }
        long next = job.getNextRun();
        long now = System.currentTimeMillis();
        int rt = job.getRepeatType();
        if (next < now && rt == -1) {
            return;
        }
        this.addToSimpleTaskList(job);
    }

    public void updateTask(CronJob job) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleComplexTask(CronJobExt job) {
        if (!this.useComplexQ) {
            return;
        }
        if (job.isExpired()) {
            return;
        }
        Vector vector = this.extTasks;
        synchronized (vector) {
            this.extTasks.addElement(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToSimpleTaskList(CronJob job) {
        Vector vector = this.tasks;
        synchronized (vector) {
            for (int i = 0; i < this.tasks.size(); ++i) {
                CronJob cmp = (CronJob)this.tasks.elementAt(i);
                if (job.nextRun >= cmp.nextRun - 10L) continue;
                this.tasks.insertElementAt(job, i);
                if (i == 0) {
                    this.interruptAndReschedule(null);
                }
                return;
            }
            this.tasks.addElement(job);
            this.current.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Enumeration e;
        Vector vector = this.tasks;
        synchronized (vector) {
            e = this.tasks.elements();
            while (e.hasMoreElements()) {
                this.cancelTask((CronJob)e.nextElement());
            }
        }
        vector = this.extTasks;
        synchronized (vector) {
            e = this.extTasks.elements();
            while (e.hasMoreElements()) {
                this.cancelTask((CronJob)e.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(CronJob job) {
        if (job instanceof CronJobExt) {
            Vector vector = this.extTasks;
            synchronized (vector) {
                job.cancel();
                this.extTasks.removeElement(job);
            }
        }
        Vector vector = this.tasks;
        synchronized (vector) {
            job.cancel();
            CronJob firstJob = null;
            if (this.tasks.size() > 0) {
                firstJob = (CronJob)this.tasks.elementAt(0);
            }
            this.tasks.removeElement(job);
            if (job == firstJob) {
                this.interruptAndReschedule(null);
            }
        }
    }

    public void interrupt() {
        this.running = false;
        if (this.current != null) {
            this.current.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAndReschedule(CronJob job) {
        if (Thread.currentThread() == this.current) {
            return;
        }
        if (job != null) {
            CronJob cronJob = job;
            synchronized (cronJob) {
                long next = job.getNextRun();
                long now = System.currentTimeMillis();
                int rt = job.getRepeatType();
                if (next < now && rt == -1) {
                    return;
                }
                Vector vector = this.tasks;
                synchronized (vector) {
                    if (rt != -1) {
                        job.resetForNextRun();
                    }
                    if (this.tasks.removeElement(job)) {
                        this.addToSimpleTaskList(job);
                    }
                }
            }
        }
        if (this.current != null) {
            this.current.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CronJob nextJob() {
        Vector vector = this.tasks;
        synchronized (vector) {
            while (this.tasks.size() == 0) {
                try {
                    this.tasks.wait();
                }
                catch (InterruptedException _ex) {
                    Thread.interrupted();
                    if (this.tasks.isEmpty()) continue;
                    return (CronJob)this.tasks.firstElement();
                }
            }
            return (CronJob)this.tasks.firstElement();
        }
    }

    public void dispatch(CronJob job) {
        PooledThread pt = (PooledThread)this.pool.allocate(this.scanComplexQInterval);
        if (pt != null) {
            pt.runTarget(job.getTarget());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        CronJob job = null;
        while (true) {
            try {
                while (true) {
                    Vector vector = this.tasks;
                    synchronized (vector) {
                        job = null;
                        job = this.nextJob();
                        long sleepTime = job.nextRun == Long.MAX_VALUE ? Integer.MAX_VALUE : job.nextRun - System.currentTimeMillis();
                        if (sleepTime > 0L) {
                            this.tasks.wait(sleepTime);
                            if (this.current.isInterrupted()) {
                                throw new InterruptedException();
                            }
                        }
                        if (job.isRunnable()) {
                            this.dispatch(job);
                        }
                        this.tasks.removeElement(job);
                        job.reschedule(this);
                    }
                }
            }
            catch (InterruptedException e) {
                if (this.running) continue;
                return;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CronJob[] getTaskList() {
        Vector vector = this.tasks;
        synchronized (vector) {
            Object[] jobs = new CronJob[this.tasks.size()];
            this.tasks.copyInto(jobs);
            return jobs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CronJobExt[] getExtTaskList() {
        if (!this.useComplexQ) {
            return null;
        }
        Vector vector = this.extTasks;
        synchronized (vector) {
            Object[] jobs = new CronJobExt[this.extTasks.size()];
            this.extTasks.copyInto(jobs);
            return jobs;
        }
    }

    public static void main(String[] args) throws Exception {
        Cron c = new Cron();
        CronTest ct1 = new CronTest(140L);
        CronTest ct2 = new CronTest(200L);
        CronTest ct3 = new CronTest(180L);
        CronTest ct4 = new CronTest(165L);
        CronJob cj1 = new CronJob("ct1", ct1, System.currentTimeMillis() + 100L, 140L);
        CronJob cj2 = new CronJob("ct2", ct2, System.currentTimeMillis() + 100L, 200L);
        CronJob cj3 = new CronJob("ct3", ct3, System.currentTimeMillis() + 200L, 180L);
        CronJob cj4 = new CronJob("ct4", ct4, System.currentTimeMillis() + 200L, 165L);
        c.scheduleTask(cj1);
        c.scheduleTask(cj2);
        c.scheduleTask(cj3);
        c.scheduleTask(cj4);
        Thread.sleep(20000L);
        System.out.println("CANCELLING TASKS");
        c.cancelTask(cj1);
        c.cancelTask(cj2);
        c.cancelTask(cj3);
        c.cancelTask(cj4);
        System.out.println("cancelled all tasks");
    }
}

