/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.JournalLogger;
import com.wm.util.ProxySettings;
import com.wm.util.Strings;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Config {
    private static int timeout = 0;
    private static int retries = 0;
    private static final String defaultUserAgent = "Mozilla/4.0 [en] (WinNT; I)";
    public static boolean useCookies = true;
    public static int maxRedirects = 5;
    public static String eol = System.getProperty("line.separator");
    private static String encoding;
    private static InetAddress localhost;
    private static String rootProp;
    private static ArrayList userAgentList;

    public static void processProperties() {
        Config.setLocalHost(Config.getProperty("watt.net.localhost"));
        Config.setUserAgent(Config.getProperty(defaultUserAgent, "watt.net.userAgent"));
        Config.setRetries(Integer.parseInt(Config.getProperty(retries, "watt.net.retries")));
        Config.setTimeout(Integer.parseInt(Config.getProperty(timeout, "watt.net.timeout")));
        Config.setMaxRedirects(Integer.parseInt(Config.getProperty(maxRedirects, "watt.net.maxRedirects")));
        String val = Config.getProperty(new Boolean(useCookies).toString(), "watt.net.useCookies");
        if (val != null) {
            Config.setUseCookies(new Boolean(val));
        }
    }

    public static String[] processCmdLine(String[] args) {
        if (args == null) {
            return null;
        }
        Properties props = System.getProperties();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-config") && args.length > i + 1) {
                try {
                    Config.loadProperties(new FileInputStream(args[i + 1]));
                }
                catch (IOException e) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-proxy") && args.length > i + 1) {
                ProxySettings.setProxy(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-port") && args.length > i + 1) {
                Config.setPort(args[i + 1], false);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-secureport") && args.length > i + 1) {
                Config.setPort(args[i + 1], true);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-httpauth") && args.length > i + 2) {
                Config.setHttpAuth(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-proxyauth") && args.length > i + 2) {
                ProxySettings.setProxyAuth(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            v.addElement(args[i]);
        }
        Object[] res = new String[v.size()];
        v.copyInto(res);
        return res;
    }

    public static void setRetries(int retryVal) {
        retries = retryVal;
        Config.setProperty("watt.net.retries", Integer.toString(retryVal));
    }

    public static void setMaxRedirects(int maxRedir) {
        maxRedirects = maxRedir;
        Config.setProperty("watt.net.maxRedirects", Integer.toString(maxRedir));
    }

    public static void setTimeout(int timeoutVal) {
        timeout = timeoutVal;
        Config.setProperty("watt.net.timeout", Integer.toString(timeoutVal));
    }

    public static void setUseCookies(boolean acceptCookies) {
        useCookies = acceptCookies;
        Config.setProperty("watt.net.useCookies", new Boolean(acceptCookies).toString());
    }

    public static void setUserAgent(String newAgent) {
        if (newAgent != null) {
            Config.setProperty("watt.net.userAgent", newAgent);
        }
    }

    private static void setHttpAuth(String user, String password) {
        Config.setProperty("watt.net.httpUser", user);
        Config.setProperty("watt.net.httpPass", password);
    }

    private static void setPort(String port, boolean secure) {
        if (secure) {
            Config.setProperty("watt.server.securePort", port);
        } else {
            Config.setProperty("watt.server.port", port);
        }
    }

    public static String getEncoding() {
        return encoding;
    }

    public static InetAddress getBroadcast() throws UnknownHostException {
        String bc = System.getProperty("watt.net.broadcast");
        if (bc == null) {
            return null;
        }
        return InetAddress.getByName(bc);
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        if (localhost == null) {
            localhost = InetAddress.getLocalHost();
            localhost = InetAddress.getByName(localhost.getHostAddress());
        }
        return localhost;
    }

    public static void setLocalHost(String hostname) {
        if (hostname == null || hostname.length() == 0) {
            return;
        }
        try {
            localhost = InetAddress.getByName(hostname);
            localhost = InetAddress.getByName(localhost.getHostAddress());
        }
        catch (Exception e) {
            Object[] parms = new String[]{e.toString()};
            JournalLogger.log(1, 77, 1, parms);
        }
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static int timeout() {
        return timeout;
    }

    public static int retries() {
        return retries;
    }

    public static void setProperty(String key, Object value) {
        if (value == null) {
            System.getProperties().remove(key);
            return;
        }
        System.getProperties().put(key, value);
    }

    static String getProperty(int value, String key) {
        return Config.getProperty(Integer.toString(value), key);
    }

    public static String getProperty(String value, String key) {
        String v = Config.getProperty(key);
        if (v != null) {
            return v;
        }
        return value;
    }

    public static String getProperty(String key) {
        return System.getProperty(key);
    }

    public static int getIntProperty(int defaultValue, String key) {
        int value;
        String v = Config.getProperty(key);
        if (v == null || v.length() < 1) {
            return defaultValue;
        }
        v = v.trim();
        try {
            value = Integer.parseInt(v);
        }
        catch (NumberFormatException nfe) {
            value = defaultValue;
            Object[] parms = new String[]{key, v, String.valueOf(defaultValue)};
            JournalLogger.logError(6, 77, parms);
        }
        return value;
    }

    public static int getPositiveIntProperty(int defaultValue, String key) {
        int value;
        String v = Config.getProperty(key);
        if (v == null || v.length() < 1) {
            return defaultValue;
        }
        v = v.trim();
        try {
            value = Integer.parseInt(v);
            if (value < 0) {
                value = defaultValue;
                Object[] parms = new String[]{key, v, String.valueOf(defaultValue)};
                JournalLogger.logError(6, 77, parms);
            }
        }
        catch (NumberFormatException nfe) {
            value = defaultValue;
            Object[] parms = new String[]{key, v, String.valueOf(defaultValue)};
            JournalLogger.logError(6, 77, parms);
        }
        return value;
    }

    public static boolean getBooleanProperty(boolean defaultValue, String key) {
        boolean value;
        String v = Config.getProperty(key);
        if (v == null || v.length() < 1) {
            return defaultValue;
        }
        if ((v = v.trim()).equalsIgnoreCase("true")) {
            value = true;
        } else if (v.equalsIgnoreCase("false")) {
            value = false;
        } else {
            value = defaultValue;
            Object[] parms = new String[]{key, v, String.valueOf(defaultValue)};
            JournalLogger.logError(6, 77, parms);
        }
        return value;
    }

    public static Properties getProperties() {
        return System.getProperties();
    }

    public static void loadProperties(InputStream inputStream) {
        try {
            System.getProperties().load(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Config.processProperties();
    }

    public static void saveProperties(FileOutputStream outputStream, String label) {
        System.getProperties().save(outputStream, label);
    }

    public static void setProtocolPath() {
        String packagePrefixList = Config.getProperty("java.protocol.handler.pkgs");
        if (packagePrefixList != null && packagePrefixList.indexOf("com.wm.net.protocol") != -1) {
            return;
        }
        if (packagePrefixList != "") {
            packagePrefixList = packagePrefixList + "|";
        }
        packagePrefixList = packagePrefixList + "com.wm.net.protocol";
        Config.setProperty("java.protocol.handler.pkgs", packagePrefixList);
    }

    public static void setupSystemProperties() {
        String pstring = Config.getProperty("watt.config.systemProperties");
        String[] list = Strings.parseCSL(pstring);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                int idx = list[i].indexOf(61);
                if (idx == -1) continue;
                String key = list[i].substring(0, idx);
                String val = list[i].substring(idx + 1);
                System.setProperty(key, val);
            }
        }
    }

    public static void setupReAuthAgentList() {
        String reauth_agents = Config.getProperty("watt.server.http.reauth.user-agent.list");
        if (reauth_agents != null) {
            StringTokenizer sTknzr = null;
            sTknzr = new StringTokenizer(reauth_agents, ";");
            while (sTknzr.hasMoreTokens()) {
                userAgentList.add(sTknzr.nextToken().toLowerCase());
            }
        }
    }

    public static ArrayList getReAuthAgentList() {
        return userAgentList;
    }

    static {
        try {
            encoding = new OutputStreamWriter(System.out).getEncoding();
        }
        catch (Exception e) {
            System.err.println("Unable to obtain encoding from System. Using ISO8859_1.");
            encoding = "ISO8859_1";
        }
        localhost = null;
        rootProp = "watt.";
        userAgentList = new ArrayList();
    }
}

