/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ClasspathUtils {
    public static String[] parseClasspath(String aClasspath) {
        ArrayList<String> pathElementList = new ArrayList<String>();
        StringTokenizer sTknzr = null;
        sTknzr = aClasspath.indexOf(";") != -1 ? new StringTokenizer(aClasspath, ";") : new StringTokenizer(aClasspath, System.getProperty("path.separator"));
        while (sTknzr.hasMoreTokens()) {
            pathElementList.add(sTknzr.nextToken());
        }
        return pathElementList.toArray(new String[0]);
    }

    public static URL[] getURLsFromClasspath(String aClassPath) {
        if (aClassPath == null) {
            return null;
        }
        String[] classPathElements = ClasspathUtils.parseClasspath(aClassPath);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < classPathElements.length; ++i) {
            URL aURL = ClasspathUtils.getURLFromPathElementString(classPathElements[i]);
            urls.add(aURL);
        }
        URL[] urlArray = urls.toArray(new URL[0]);
        return urlArray;
    }

    public static URL getURLFromPathElementString(String aClassPathElement) {
        URL url = null;
        try {
            String pathElement = aClassPathElement;
            if (pathElement.startsWith("file:") || pathElement.startsWith("http:")) {
                return new URL(pathElement);
            }
            String urlSpecification = null;
            urlSpecification = pathElement.replace('/', File.separatorChar);
            urlSpecification = urlSpecification.replace('\\', File.separatorChar);
            urlSpecification = "file:" + urlSpecification;
            url = new URL(urlSpecification);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        return url;
    }

    public static String getClasspathFromFiles(File[] someFiles) {
        if (someFiles == null || someFiles.length == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < someFiles.length; ++i) {
            if (someFiles[i].isDirectory() && someFiles[i].listFiles() != null) {
                buffer.append(ClasspathUtils.getClasspathFromFiles(someFiles[i].listFiles()));
            } else {
                if (!someFiles[i].getPath().endsWith("jar") && !someFiles[i].getPath().endsWith("zip") && !someFiles[i].getPath().endsWith("class")) continue;
                buffer.append(someFiles[i].getPath());
            }
            if (i == someFiles.length - 1) continue;
            buffer.append(System.getProperty("path.separator"));
        }
        String path = buffer.toString();
        return path;
    }

    public static String createURLClasspathString(URL[] urls) {
        StringBuffer cpBuffer = new StringBuffer("");
        for (int i = 0; i < urls.length; ++i) {
            String urlString = urls[i].getPath();
            urlString = urlString.replace('/', File.separatorChar);
            urlString = urlString.replace('\\', File.separatorChar);
            cpBuffer.append(urlString);
            if (i >= urls.length - 1) continue;
            cpBuffer.append(File.pathSeparator);
        }
        return cpBuffer.toString();
    }

    public static String createClasspathString(String[] filenames) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < filenames.length; ++i) {
            buf.append(filenames[i]);
            if (i + 1 >= filenames.length) continue;
            buf.append(System.getProperty("path.separator"));
        }
        return buf.toString();
    }
}

