/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.LocalizedIOException;
import com.wm.util.resources.UtilExceptionBundle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class ByteOutputBuffer
extends OutputStream {
    int blen;
    int idx;
    int size;
    int waiters;
    Vector v;
    byte[] cur;
    boolean closed;
    int readPtr;
    int readIdx;
    int readOff;
    byte[] readBuf;

    public ByteOutputBuffer() {
        this(256);
    }

    public ByteOutputBuffer(int size) {
        this.blen = size;
        this.idx = 0;
        this.size = 0;
        this.waiters = 0;
        this.v = new Vector();
        this.cur = new byte[this.blen];
        this.closed = false;
    }

    public void reset() {
        this.idx = 0;
        this.size = 0;
        this.v.removeAllElements();
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ByteOutputBuffer byteOutputBuffer = this;
        synchronized (byteOutputBuffer) {
            this.notify();
            this.closed = true;
        }
    }

    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            throw new LocalizedIOException(UtilExceptionBundle.class, UtilExceptionBundle.BYTEOUTPUTBUFFER_IO, "");
        }
        if (this.idx >= this.blen) {
            this.roll();
        }
        this.cur[this.idx++] = (byte)b;
        ++this.size;
        if (this.waiters > 0) {
            this.notify();
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int rem;
        if (this.closed) {
            throw new LocalizedIOException(UtilExceptionBundle.class, UtilExceptionBundle.BYTEOUTPUTBUFFER_IO, "");
        }
        int olen = len;
        while ((rem = this.blen - this.idx) < len) {
            System.arraycopy(b, off, this.cur, this.idx, rem);
            this.roll();
            off += rem;
            len -= rem;
        }
        System.arraycopy(b, off, this.cur, this.idx, len);
        this.idx += len;
        this.size += olen;
        if (this.waiters > 0) {
            this.notify();
        }
    }

    public int size() {
        return this.size;
    }

    void roll() {
        this.v.addElement(this.cur);
        if (this.blen < 0x100000) {
            this.blen *= 2;
        }
        this.cur = new byte[this.blen];
        this.idx = 0;
    }

    public void writeToStream(OutputStream out) throws IOException {
        int vl = this.v.size();
        for (int i = 0; i < vl; ++i) {
            out.write((byte[])this.v.elementAt(i));
        }
        out.write(this.cur, 0, this.idx);
    }

    public byte[] toByteArray() {
        int pos = 0;
        byte[] b = new byte[this.size];
        int vl = this.v.size();
        for (int i = 0; i < vl; ++i) {
            byte[] bb = (byte[])this.v.elementAt(i);
            int l = bb.length;
            System.arraycopy(bb, 0, b, pos, l);
            pos += l;
        }
        System.arraycopy(this.cur, 0, b, pos, this.idx);
        return b;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String encoding) throws Exception {
        return new String(this.toByteArray(), encoding);
    }

    public void resetRead() {
        this.readIdx = 0;
        this.readPtr = 0;
        this.readOff = 0;
        this.readBuf = null;
    }

    public synchronized int read() {
        if (!this.waitData()) {
            return -1;
        }
        byte ret = this.readBuf[this.readOff++];
        ++this.readIdx;
        if (this.readOff >= this.readBuf.length) {
            this.incrReadBuf();
        }
        return ret;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int off, int len) {
        int chunk;
        if (!this.waitData()) {
            return -1;
        }
        int toSend = Math.min(len, this.available());
        for (int read = 0; read < toSend; read += chunk) {
            chunk = Math.min(len - read, this.leftInBuf());
            System.arraycopy(this.readBuf, this.readOff, b, off + read, chunk);
            this.readOff += chunk;
            this.readIdx += chunk;
            if (this.readOff < this.readBuf.length) continue;
            this.incrReadBuf();
        }
        return toSend;
    }

    boolean waitData() {
        if (this.leftInBuf() > 0) {
            return true;
        }
        if (this.readBuf == null) {
            return this.incrReadBuf();
        }
        if (this.buffersLeft() <= 0) {
            if (this.closed) {
                return this.incrReadBuf();
            }
            try {
                ++this.waiters;
                this.wait();
                --this.waiters;
            }
            catch (Exception e) {
                --this.waiters;
                return false;
            }
        }
        return this.buffersLeft() > 0;
    }

    public byte[] getRemainder() {
        byte[] a = this.toByteArray();
        byte[] b = new byte[this.size - this.readIdx];
        System.arraycopy(a, this.readIdx, b, 0, b.length);
        return b;
    }

    public int buffersLeft() {
        return this.v.size() - this.readPtr;
    }

    public int leftInBuf() {
        if (this.readBuf == null) {
            return 0;
        }
        return Math.min(this.readBuf.length - this.readOff, this.size - this.readIdx);
    }

    public int available() {
        return this.size - this.readIdx;
    }

    boolean incrReadBuf() {
        if (this.readPtr < this.v.size()) {
            this.readOff = 0;
            this.readBuf = (byte[])this.v.elementAt(this.readPtr++);
            return true;
        }
        if (this.readPtr == this.v.size()) {
            this.readOff = 0;
            this.readBuf = this.cur;
            ++this.readPtr;
            return true;
        }
        return false;
    }
}

