/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.Name;

public class BrokerUtil {
    private static Name[] RESERVED_WORDS = new Name[]{Name.create("any"), Name.create("boolean"), Name.create("byte"), Name.create("char"), Name.create("const"), Name.create("date"), Name.create("double"), Name.create("enum"), Name.create("false"), Name.create("final"), Name.create("float"), Name.create("int"), Name.create("long"), Name.create("null"), Name.create("short"), Name.create("string"), Name.create("struct"), Name.create("true"), Name.create("typedef"), Name.create("unicode_char"), Name.create("unicode_string"), Name.create("union"), Name.create("unsigned")};

    public static boolean validateFieldName(String name) {
        char[] c = name.toCharArray();
        if (c.length < 1 || c.length > 255) {
            return false;
        }
        if (Character.isDigit(c[0]) || BrokerUtil.isUnderscore(c[0])) {
            return false;
        }
        for (int i = 0; i < c.length; ++i) {
            if (Character.isLetterOrDigit(c[i]) || BrokerUtil.isUnderscore(c[i])) continue;
            return false;
        }
        return c.length <= 2 || c.length >= 9 && c.length != 12 && c.length != 14 || !BrokerUtil.isReservedWord(name);
    }

    private static boolean isUnderscore(char c) {
        return c == '_' || c == '\u0332' || c == '\ufe33' || c == '\ufe4e' || c == '\uff3f';
    }

    private static boolean isReservedWord(String word) {
        Name normalizedWord = Name.create(word.toLowerCase());
        for (int i = 0; i < RESERVED_WORDS.length; ++i) {
            if (RESERVED_WORDS[i] != normalizedWord) continue;
            return true;
        }
        return false;
    }

    public static String retrieveStringValue(byte[] data, byte[] field) {
        String value = null;
        int envCount = 0;
        int pos = 0;
        if (data == null || data.length < 4) {
            return null;
        }
        int dataLength = BrokerUtil.readInt(data, pos);
        if (data.length < dataLength) {
            return null;
        }
        pos = dataLength + 4;
        envCount = BrokerUtil.readShort(data, pos);
        pos += 4;
        while (envCount > 0) {
            int len = BrokerUtil.readInt(data, pos);
            int nameLen = BrokerUtil.readShort(data, pos + 6);
            if (nameLen == field.length) {
                boolean found = true;
                for (int i = 0; i < field.length; ++i) {
                    if (data[pos + 8 + i] == field[i]) continue;
                    found = false;
                    break;
                }
                if (found) {
                    int posShift = 12 + (field.length + 3 >> 2 << 2);
                    int valLen = BrokerUtil.readInt(data, pos + posShift - 4);
                    int realLen = valLen - 4;
                    value = BrokerUtil.readString(data, pos + posShift, realLen);
                    break;
                }
            }
            pos += len;
            --envCount;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readString(byte[] data, int pos, int len) {
        StringBuffer buffer;
        if (data == null || data.length - pos < len) {
            return null;
        }
        int sizeOfCharArray = len / 2;
        StringBuffer stringBuffer = buffer = new StringBuffer(sizeOfCharArray);
        synchronized (stringBuffer) {
            for (int i = 0; i < sizeOfCharArray; ++i) {
                buffer.append((char)(data[pos + i * 2] << 8 | data[pos + i * 2 + 1] & 0xFF));
            }
        }
        return buffer.toString();
    }

    private static int readInt(byte[] data, int pos) {
        if (data == null || data.length - pos < 4) {
            return 0;
        }
        return (data[pos + 0] & 0xFF) << 24 | (data[pos + 1] & 0xFF) << 16 | (data[pos + 2] & 0xFF) << 8 | (data[pos + 3] & 0xFF) << 0;
    }

    private static int readShort(byte[] data, int pos) {
        if (data == null || data.length - pos < 2) {
            return 0;
        }
        return (data[pos + 0] & 0xFF) << 8 | (data[pos + 1] & 0xFF) << 0;
    }

    public static String retrieveEventID(byte[] data) {
        if (data == null || data.length < 30) {
            return null;
        }
        int eventTypeNameLength = (data[28] & 0xFF) << 8 | (data[29] & 0xFF) << 0;
        int offset = 29 + eventTypeNameLength;
        int diff = (offset + 1) % 4;
        if (diff > 0) {
            offset += 4 - diff;
        }
        if (data.length < offset + 9) {
            return null;
        }
        long eventID = (long)((data[offset + 1] & 0xFF) << 24 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 8 | (data[offset + 4] & 0xFF) << 0) << 32 | (long)((data[offset + 5] & 0xFF) << 24 | (data[offset + 6] & 0xFF) << 16 | (data[offset + 7] & 0xFF) << 8 | (data[offset + 8] & 0xFF) << 0) & 0xFFFFFFFFL;
        return Long.toString(eventID);
    }
}

