/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.BooleanListEnumerator;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class BooleanList
implements Serializable {
    boolean[] list;
    int curPtr = 0;

    public BooleanList() {
        this(10);
    }

    public BooleanList(int size) {
        this.list = new boolean[size];
    }

    public BooleanList(boolean[] o) {
        if (o != null) {
            for (int i = 0; i < o.length; ++i) {
                this.addBoolean(o[i]);
            }
        }
    }

    public BooleanList(Enumeration e) {
        this();
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            this.addBoolean((Boolean)e.nextElement());
        }
    }

    public void addBoolean(boolean o) {
        this.list[this.curPtr++] = o;
        if (this.curPtr >= this.list.length) {
            boolean[] newlist = new boolean[this.list.length * 2];
            System.arraycopy(this.list, 0, newlist, 0, this.list.length);
            this.list = newlist;
        }
    }

    public boolean booleanAt(int index) {
        if (index >= 0 && index < this.list.length) {
            return this.list[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public boolean lastBoolean() {
        if (this.curPtr > 0) {
            return this.list[this.curPtr - 1];
        }
        throw new NoSuchElementException();
    }

    public void setBooleanAt(boolean o, int index) {
        if (index < 0 || index >= this.list.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.list[index] = o;
    }

    public void removeBooleanAt(int index) {
        if (this.curPtr > 0 && index >= 0 && index < this.list.length) {
            if (index >= 0) {
                for (int i = index; i < this.curPtr; ++i) {
                    this.list[i] = this.list[i + 1];
                }
            }
            --this.curPtr;
        } else {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public void copyInto(boolean[] o) {
        System.arraycopy(this.list, 0, o, 0, this.curPtr);
    }

    public int size() {
        return this.curPtr;
    }

    public final boolean isEmpty() {
        return this.curPtr == 0;
    }

    public final void reset() {
        this.curPtr = 0;
    }

    public Enumeration elements() {
        return new BooleanListEnumerator(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        for (int i = 0; i < this.curPtr; ++i) {
            if (i < this.curPtr - 1) {
                sb.append(this.list[i] + ", ");
                continue;
            }
            sb.append("" + this.list[i]);
        }
        sb.append("}");
        return sb.toString();
    }
}

