/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.data.IData;
import com.wm.data.IDataPortable;
import com.wm.util.BasisException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Locale;

public class BasisSQLException
extends SQLException
implements IDataPortable {
    public static String BUNDLE = "com.wm.resources.CoreExcpMsgs";
    private BasisException ex;
    private Throwable t;

    public BasisSQLException() {
        this.ex = new BasisException();
    }

    public BasisSQLException(String id, String bundle) {
        this.ex = new BasisException(id, bundle);
    }

    public BasisSQLException(String id) {
        this.ex = new BasisException(id, BUNDLE);
    }

    public BasisSQLException(String id, String[] parms) {
        this.ex = new BasisException(id, BUNDLE, parms);
    }

    public BasisSQLException(String id, String bundle, int errorCode, int reasonCode) {
        this.ex = new BasisException(id, bundle, errorCode, reasonCode);
    }

    public BasisSQLException(String id, String bundle, String[] parms) {
        this.ex = new BasisException(id, bundle, parms);
    }

    public BasisSQLException(String id, String bundle, int errorCode, int reasonCode, String[] parms) {
        this.ex = new BasisException(id, bundle, errorCode, reasonCode, parms);
    }

    public BasisSQLException(String id, String bundle, String dfltMsg) {
        this.ex = new BasisException(id, bundle, dfltMsg);
    }

    public BasisSQLException(String id, String bundle, String[] parms, String dfltMsg) {
        this.ex = new BasisException(id, bundle, parms, dfltMsg);
    }

    public BasisSQLException(String id, String bundle, int errorCode, int reasonCode, String[] parms, String dfltMsg) {
        this.ex = new BasisException(id, bundle, errorCode, reasonCode, parms, dfltMsg);
    }

    private static String getTrace(Throwable excpt) {
        String trace = null;
        if (excpt != null) {
            StringWriter sWriter = new StringWriter();
            excpt.printStackTrace(new PrintWriter(sWriter));
            trace = sWriter.toString();
            try {
                sWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return trace;
    }

    public BasisSQLException(Throwable excpt) {
        super(BasisSQLException.getTrace(excpt));
        this.ex = new BasisException("BAC.0002.0000", BUNDLE, excpt);
    }

    public BasisSQLException(String id, String bundle, Throwable excpt) {
        super(BasisSQLException.getTrace(excpt));
        this.ex = new BasisException(id, bundle, excpt);
    }

    public BasisSQLException(String id, String bundle, String[] parms, Throwable excpt) {
        super(BasisSQLException.getTrace(excpt));
        this.ex = new BasisException(id, bundle, parms, excpt);
    }

    public BasisSQLException(String id, String bundle, String dfltMsg, Throwable excpt) {
        super(BasisSQLException.getTrace(excpt));
        this.ex = new BasisException(id, bundle, dfltMsg, excpt);
    }

    public BasisSQLException(String id, String bundle, String[] parms, String dfltMsg, Throwable excpt) {
        super(BasisSQLException.getTrace(excpt));
        this.ex = new BasisException(id, bundle, parms, dfltMsg, excpt);
    }

    public BasisSQLException(String id, String bundle, int errorCode, int reasonCode, String[] parms, String dfltMsg, Throwable excpt) {
        super(BasisSQLException.getTrace(excpt));
        this.ex = new BasisException(id, bundle, errorCode, reasonCode, parms, dfltMsg, excpt);
    }

    public String getId() {
        return this.ex.getId();
    }

    public String[] getParms() {
        return this.ex.getParms();
    }

    public int getErrorCode() {
        int iErrCd = this.ex != null ? this.ex.getErrorCode() : -99;
        return iErrCd;
    }

    public int getReasonCode() {
        int iReasCd = this.ex != null ? this.ex.getReasonCode() : -99;
        return iReasCd;
    }

    public Throwable getWrappedException() {
        return this.ex.getWrappedException();
    }

    public void setWrappedException(Throwable excpt) {
        this.ex.setWrappedException(excpt);
    }

    public String getMessage() {
        String msg = this.ex != null ? this.ex.getMessage() : super.getMessage();
        return msg;
    }

    public String getMessage(Locale loc) {
        String msg = this.ex != null ? this.ex.getMessage(loc) : super.getMessage();
        return msg;
    }

    public String getMessage(ClassLoader loader) {
        String msg = this.ex != null ? this.ex.getMessage(loader) : super.getMessage();
        return msg;
    }

    public String getMessage(Locale loc, ClassLoader loader) {
        String msg = this.ex != null ? this.ex.getMessage(loc, loader) : super.getMessage();
        return msg;
    }

    public void printStackTrace() {
        if (this.ex != null) {
            this.ex.printStackTrace();
        } else {
            System.err.println(this.getMessage());
        }
    }

    public void printStackTrace(PrintStream ps) {
        if (this.ex != null) {
            this.ex.printStackTrace(ps);
        } else {
            ps.println(this.getMessage());
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.ex != null) {
            this.ex.printStackTrace(pw);
        } else {
            pw.println(this.getMessage());
        }
    }

    public IData getAsData() {
        return this.ex.getAsData();
    }

    public void setFromData(IData data) {
        this.ex.setFromData(data);
    }
}

